/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.api;

import android.content.SharedPreferences;
import com.genesys.gms.mobile.callback.demo.legacy.BuildConfig;
import com.genesys.gms.mobile.callback.demo.legacy.data.retrofit.GmsEndpoint;
import com.genesys.gms.mobile.callback.demo.legacy.data.retrofit.GmsRequestInterceptor;
import com.genesys.gms.mobile.callback.demo.legacy.util.Globals;
import com.google.gson.Gson;
import com.squareup.okhttp.OkHttpClient;
import dagger.Module;
import dagger.Provides;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.GsonConverter;
import timber.log.Timber;

import javax.inject.Singleton;

/**
 * Created by stau on 11/27/2014.
 */
@Module(
    complete = false,
    library = true
)
public class ApiModule {
  @Provides
  @Singleton
  GmsEndpoint provideEndpoint(SharedPreferences sharedPreferences) {
    GmsEndpoint gmsEndpoint = new GmsEndpoint();
    String host = sharedPreferences.getString(Globals.PROPERTY_HOST, "localhost");
    Boolean isSecure = sharedPreferences.getBoolean(Globals.PROPERTY_PROTOCOL, Boolean.FALSE);
    String protocol = isSecure? "https":"http";
    String strPort = sharedPreferences.getString(Globals.PROPERTY_PORT, "8080");
    String strApiVersion = sharedPreferences.getString(Globals.PROPERTY_API_VERSION, "1");
    String strApp = sharedPreferences.getString(Globals.PROPERTY_APP, "genesys");
    if (!host.isEmpty() && !strPort.isEmpty() && !strApiVersion.isEmpty()) {
      Integer port = null;
      Integer apiVersion = null;
      try {
        port = Integer.valueOf(strPort);
        apiVersion = Integer.valueOf(strApiVersion);
      } catch (NumberFormatException e) {
        ;
      }
      gmsEndpoint.setUrl(protocol,host, port, strApp, apiVersion);
    }
    return gmsEndpoint;
  }

  @Provides
  @Singleton
  GmsRequestInterceptor provideRequestInterceptor(SharedPreferences sharedPreferences) {
    GmsRequestInterceptor gmsRequestInterceptor = new GmsRequestInterceptor();
    String gmsUser = sharedPreferences.getString(Globals.PROPERTY_GMS_USER, null);
    String apigeeKey = sharedPreferences.getString(Globals.PROPERTY_APIGEEKEY, null);
    String serviceParams = sharedPreferences.getString(Globals.PROPERTY_SIMPLE_PARAMS, null);
    gmsRequestInterceptor.setGmsUser(gmsUser);
    gmsRequestInterceptor.setSimpleParams(serviceParams);
    gmsRequestInterceptor.setApiGeeKey(apigeeKey);
    return gmsRequestInterceptor;
  }

  @Provides
  @Singleton
  Client provideClient(OkHttpClient client) {
    return new OkClient(client);
  }

  @Provides
  @Singleton
  RestAdapter provideRestAdapter(GmsEndpoint endpoint, GmsRequestInterceptor requestInterceptor, Client client, Gson gson) {
    RestAdapter.Builder builder = new RestAdapter.Builder()
        .setClient(client)
        .setEndpoint(endpoint)
        .setRequestInterceptor(requestInterceptor)
        .setConverter(new GsonConverter(gson));
    if (BuildConfig.DEBUG) {
      builder.setLogLevel(RestAdapter.LogLevel.FULL)
          .setLog(new RestAdapter.Log() {
            @Override
            public void log(String msg) {
              Timber.tag("Retrofit");
              Timber.d(msg);
            }
          });
    }
    return builder.build();
  }

  @Provides
  @Singleton
  CallbackApi provideCallbackService(RestAdapter restAdapter) {
    return restAdapter.create(CallbackApi.class);
  }

  @Provides
  @Singleton
  ChatApi provideChatService(RestAdapter restAdapter) {
    return restAdapter.create(ChatApi.class);
  }
}