/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.api;

import retrofit.Callback;
import retrofit.client.Response;
import retrofit.http.*;
import retrofit.mime.TypedFile;

import java.util.Map;

/**
 * Created by stau on 5/7/2015.
 */
public interface StorageApi {
  @FormUrlEncoded
  @POST("/storage/{ttl}")
  public Response create(@Path("ttl") int ttl,
                         @FieldMap Map<String, String> payload);

  @FormUrlEncoded
  @POST("/storage/{ttl}")
  public void create(@Path("ttl") int ttl,
                     @FieldMap Map<String, String> payload,
                     Callback<Response> callback);

  @FormUrlEncoded
  @POST("/storage/{storage_id}/{ttl}")
  public Response update(@Path("storage_id") String storageId,
                         @Path("ttl") int ttl,
                         @FieldMap Map<String, String> payload);

  @FormUrlEncoded
  @POST("/storage/{storage_id}/{ttl}")
  public void update(@Path("storage_id") String storageId,
                     @Path("ttl") int ttl,
                     @FieldMap Map<String, String> payload,
                     Callback<Response> callback);

  @Multipart
  @POST("/storage/{storage_id}/{ttl}")
  public Response updateBinary(@Path("storage_id") String storageId,
                               @Path("ttl") int ttl,
                               @PartMap Map<String, TypedFile> params);

  @Multipart
  @POST("/storage/{storage_id}/{ttl}")
  public void updateBinary(@Path("storage_id") String storageId,
                           @Path("ttl") int ttl,
                           @PartMap Map<String, TypedFile> params,
                           Callback<Response> callback);

  @GET("/storage/{storage_id}")
  public Map<String, String> queryAllKeys(@Path("storage_id") String storageId);

  @GET("/storage/{storage_id}")
  public void queryAllKeys(@Path("storage_id") String storageId,
                           Callback<Map<String, String>> callback);

  @GET("/storage/{storage_id}/{key}")
  public Response queryOneKey(@Path("storage_id") String storageId,
                              @Path("key") String key);

  @GET("/storage/{storage_id}/{key}")
  public void queryOneKey(@Path("storage_id") String storageId,
                          @Path("key") String key,
                          Callback<Response> callback);

  @GET("/storage/binary/{storage_id}/{key}")
  public Response queryBinary(@Path("storage_id") String storageId,
                              @Path("key") String key);

  @GET("/storage/binary/{storage_id}/{key}")
  public void queryBinary(@Path("storage_id") String storageId,
                          @Path("key") String key,
                          Callback<Response> callback);

  @DELETE("/storage/{storage_id}")
  public Response delete(@Path("storage_id") String storageId);

  @DELETE("/storage/{storage_id}")
  public void delete(@Path("storage_id") String storageId,
                     Callback<Response> callback);
}
