/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo;

/**
 * Created by stau on 2/6/2015.
 */
public class TranscriptEntry {
    private final ChatEvent chatEvent;
    private final String nickname;
    private final String text;
    private final String partyId;
    private final ChatPartyType chatPartyType;
    private final String messageIndex;


    public TranscriptEntry(ChatEvent chatEvent,
                           String nickname,
                           String text,
                           String partyId,
                           ChatPartyType chatPartyType, String messageIndex){
        this.chatEvent = chatEvent;
        this.nickname = nickname;
        this.text = text;
        this.partyId = partyId;
        this.chatPartyType = chatPartyType;
        this.messageIndex = messageIndex;
    }

  public TranscriptEntry(ChatEvent chatEvent,
                         String nickname,
                         String text,
                         String partyId,
                         ChatPartyType chatPartyType ) {
        this.chatEvent = chatEvent;
        this.nickname = nickname;
        this.text = text;
        this.partyId = partyId;
        this.chatPartyType = chatPartyType;
        this.messageIndex = "";
  }

  public ChatEvent getChatEvent() {
    return chatEvent;
  }

  public String getNickname() {
    return nickname;
  }

  public String getText() {
    return text;
  }

  public String getPartyId() {
    return partyId;
  }

  public ChatPartyType getChatPartyType() {
    return chatPartyType;
  }

    public String getMessageIndex() {
        return messageIndex;
    }

  @Override
  public String toString() {
    return getClass().getName() + "@" + hashCode() +
        "[" +
        "chatEvent=" + chatEvent +
        ",nickname=" + nickname +
        ",text=" + text +
        ",partyId=" + partyId +
        ",messageIndex=" + messageIndex +
        "]";
  }
}
