/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.ui;

import android.app.DialogFragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.support.v4.app.Fragment;
import android.support.v4.preference.PreferenceFragment;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Toast;

import com.genesys.gms.mobile.callback.demo.legacy.R;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.GcmManager;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo.GcmSyncMessage;
import com.genesys.gms.mobile.callback.demo.legacy.data.capture.CaptureManager;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.UnknownErrorEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackAvailabilityDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackCheckQueueDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackDialogDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackErrorEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackStartDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.ServiceStartDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.capture.StartCaptureEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmErrorEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmReceiveEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmRegisterDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmRegisterEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmUnregisterDoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmUnregisterEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.retrofit.GmsEndpoint;
import com.genesys.gms.mobile.callback.demo.legacy.data.retrofit.GmsRequestInterceptor;
import com.genesys.gms.mobile.callback.demo.legacy.util.Globals;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.json.JSONException;
import org.json.JSONObject;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.inject.Inject;

import de.greenrobot.event.EventBus;
import hugo.weaving.DebugLog;
import retrofit.mime.TypedByteArray;
import timber.log.Timber;

import static android.R.attr.action;

/** Main activity for Callback sample app */
public class GenesysSampleActivity extends AbstractTabActivity implements OnSharedPreferenceChangeListener {
  public static final CharSequence[] EMPTY_LIST = {};

  // TODO: These belong in a Controller/Presenter class
  @Inject
  SharedPreferences sharedPreferences;
  @Inject
  GmsEndpoint gmsEndpoint;
  @Inject
  GmsRequestInterceptor gmsRequestInterceptor;
  @Inject
  Gson gson;
  @Inject
  GenesysSampleController controller;
  private final EventBus bus;
  private Menu menu;

  @DebugLog
  public GenesysSampleActivity() {
    this.bus = EventBus.getDefault();
  }

  /** Must use startActivityForResult to acquire permission for screencap */
  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    if (requestCode != CaptureManager.CREATE_SCREEN_CAPTURE) {
      super.onActivityResult(requestCode, resultCode, data);
      return;
    }
    bus.post(new StartCaptureEvent(resultCode, data));
  }

  private void tryUpdateEndpoint() {
    String strHost = sharedPreferences.getString(Globals.PROPERTY_HOST, null);
    Boolean isSecure = sharedPreferences.getBoolean(Globals.PROPERTY_PROTOCOL, Boolean.FALSE);
    String strProtocol = isSecure? "https":"http";
    String strPort = sharedPreferences.getString(Globals.PROPERTY_PORT, null);
    String strApiVersion = sharedPreferences.getString(Globals.PROPERTY_API_VERSION, null);
    String strApp = sharedPreferences.getString(Globals.PROPERTY_APP, null);
    if (strProtocol == null || strHost == null || strPort == null || strApp == null || strApiVersion == null) {
      return;
    }
    Timber.d("strPort: %s, strApp: %s strApiVersion: %s", strPort, strApp, strApiVersion);
    Integer port = null;
    Integer version = null;
    try {
      port = Integer.valueOf(strPort);
      version = Integer.valueOf(strApiVersion);
    } catch (NumberFormatException e) {
      ;
    }
    gmsEndpoint.setUrl(strProtocol.trim(), strHost.trim(), port, strApp, version);
  }

  @Override
  public void onCreate(Bundle inState) {
    super.onCreate(inState);
    //LoggingExceptionHandler.setDefaultUncaughtExceptionHandler(log);

    if (inState != null) {
      controller.restoreState(inState);
    }
      registerReceiver(mReceiver, new IntentFilter("ACTION_UPDATE_FCM_TOKEN"));
  }

    /**
   * As main activity is composed of PreferenceFragments, instead of listening
   * to onClick events, we listen to SharedPreferences changes.
   *
   * This section handles the scenario field, username field, desired time and
   * selected time selectors as well as the GCM registration toggle.
   * @param sharedPreferences
   * @param key
   */
  // TODO: This really needs to be broken up into individual handlers
  public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
    // TODO: Should delegate preference handling to Controller
    PreferenceFragment callbackFragment = (PreferenceFragment) this.getFragment(0);
    PreferenceFragment settingsFragment = (PreferenceFragment) this.getFragment(1);
    // TODO: When desired_date changes, start async task to update time_slots
    if (key.equals("scenario")){
      checkDesiredTimeEnabled(callbackFragment);
      //Log.d("Test scenario = ", sharedPreferences.getString("scenario", null));
      //gmsRequestInterceptor.setScenario(sharedPreferences.getString("scenario", null));
    } else if(key.equals(Globals.PROPERTY_SIMPLE_PARAMS)){
      gmsRequestInterceptor.setSimpleParams(sharedPreferences.getString(Globals.PROPERTY_SIMPLE_PARAMS, null));
    } else if (key.equals(Globals.PROPERTY_GMS_USER)) {
      String strGmsUser = sharedPreferences.getString(Globals.PROPERTY_GMS_USER, null);
      String apigeeKey = sharedPreferences.getString(Globals.PROPERTY_APIGEEKEY, null);
      gmsRequestInterceptor.setGmsUser(strGmsUser);
      gmsRequestInterceptor.setApiGeeKey(apigeeKey);
    } else if (key.equals("desired_time")) {
      Preference desiredTimePref = callbackFragment.findPreference("desired_time");
      if (desiredTimePref == null) {
        return;
      }
      String desiredTime = sharedPreferences.getString("desired_time", null);
      if (desiredTime != null) {
        ListPreference selectedTimePref = (ListPreference) callbackFragment.findPreference("selected_time");
        if (selectedTimePref != null) {
          selectedTimePref.setEnabled(false);
          selectedTimePref.setSummary("Select desired time above");
          selectedTimePref.setEntries(EMPTY_LIST);
          selectedTimePref.setEntryValues(EMPTY_LIST);
          selectedTimePref.setValue(null);
          selectedTimePref.getEditor().remove("selected_time").apply();

          String serviceName = sharedPreferences.getString("service_name", null);
          controller.requestTimeSlots(serviceName, desiredTime);
          Toast.makeText(this, "Updating time slots...", Toast.LENGTH_SHORT).show();
        }
      }
    } else if (key.equals("selected_time")) {
      ListPreference selectedTimePref = (ListPreference) callbackFragment.findPreference("selected_time");
      if (selectedTimePref == null) {
        return;
      }
      String selectedTime = sharedPreferences.getString("selected_time", null);
      if (selectedTime != null) {
        CharSequence value = selectedTimePref.getEntry();
        selectedTimePref.setSummary(value == null || value.length() == 0 ? "[nothing selected]" : value);
      }
    } else if (key.equals(Globals.PROPERTY_HOST) ||
        key.equals(Globals.PROPERTY_PROTOCOL) ||
        key.equals(Globals.PROPERTY_PORT) ||
        key.equals(Globals.PROPERTY_API_VERSION) ||
        key.equals(Globals.PROPERTY_APP)){
      tryUpdateEndpoint();
    } else if (key.equals("push_notifications_enabled")) {
      Preference pushToggle = settingsFragment.findPreference("push_notifications_enabled");
      Preference senderIdField = settingsFragment.findPreference("new_gcm_sender_id");
      if (pushToggle != null && senderIdField != null) {
        pushToggle.setEnabled(false);
        senderIdField.setEnabled(false);
        boolean bPushEnabled = sharedPreferences.getBoolean("push_notifications_enabled", false);
        if (bPushEnabled) {
          String strGcmSenderId = sharedPreferences.getString("new_gcm_sender_id", null);
          bus.post(new FcmRegisterEvent(strGcmSenderId));
        } else {
          bus.post(new FcmUnregisterEvent(null));
        }
      }
    } else if (key.equals("new_gcm_sender_id")) {
      Preference pushToggle = settingsFragment.findPreference("push_notifications_enabled");
      Preference senderIdField = settingsFragment.findPreference("new_gcm_sender_id");
      if (pushToggle != null && senderIdField != null) {
        boolean bPushEnabled = sharedPreferences.getBoolean("push_notifications_enabled", false);
        if (!bPushEnabled) {
          return;
        }
        pushToggle.setEnabled(false);
        senderIdField.setEnabled(false);
        String strGcmSenderId = sharedPreferences.getString("new_gcm_sender_id", null);
        bus.post(new FcmRegisterEvent(strGcmSenderId));
      }
    }
  }

  @Override
  public void onResume() {
    super.onResume();
    // Receive sticky events (e.g. receive last event published)
    bus.registerSticky(this);
    sharedPreferences.registerOnSharedPreferenceChangeListener(this);
    // NTS: Can't checkDesiredTimeEnabled here because Preference init occurs later
  }

  @Override
  public void onPause() {
    sharedPreferences.unregisterOnSharedPreferenceChangeListener(this);
    bus.unregister(this);
    super.onPause();
  }

  @Override
  protected void onSaveInstanceState(Bundle outState) {
    controller.persistState(outState);
    super.onSaveInstanceState(outState);
  }

  /**
   * Callback which is invoked when child fragment invokes onResume
   * @param fragment
   */
  public void onFragmentResume(PreferenceFragment fragment) {
    // Hack to deal with convoluted lifecycles (until this is reorganized)
    checkDesiredTimeEnabled(fragment);
    sendBroadcast(new Intent("ACTION_UPDATE_FCM_TOKEN"));
  }

  public void onFragmentPause(PreferenceFragment fragment) {
    // Nothing to do here
  }

  /**
   * Maintaining state of elements (e.g. set value, enabled/disabled) between
   * application going to background and back to foreground, as well as between
   * application launches is not done automatically by the system. This is
   * used to check if the desired time field should be enabled when the fragment
   * is resumed.
   * @param callbackFragment
   */
  protected void checkDesiredTimeEnabled(PreferenceFragment callbackFragment) {
    /*PreferenceManager.
    Preference desiredTimePref = callbackFragment.findPreference("desired_time");
    ListPreference selectedTimePref = (ListPreference) callbackFragment.findPreference("selected_time");
    if (desiredTimePref == null || selectedTimePref == null) {
      // Has not yet been created. Avoid crash.
      return;
    }

    if ("VOICE-SCHEDULED-USERTERM".equals(sharedPreferences.getString("scenario", null))) {
      desiredTimePref.setEnabled(true);
      selectedTimePref.setEnabled(true);
    } else {
      desiredTimePref.setEnabled(false);
      desiredTimePref.setSummary("Tap to select");
      selectedTimePref.setEnabled(false);
      selectedTimePref.setSummary("Select desired time above");
      selectedTimePref.setEntries(EMPTY_LIST);
      selectedTimePref.setEntryValues(EMPTY_LIST);
      selectedTimePref.setValue(null);
      SharedPreferences.Editor editor = sharedPreferences.edit();
      editor.remove("desired_time");
      editor.remove("selected_time");
      editor.apply();
    }*/
  }

  @Override
  public boolean onCreateOptionsMenu(Menu menu) {
    boolean result;
    MenuInflater inflater = getMenuInflater();
    inflater.inflate(R.menu.sample_general_actions, menu);
    result = super.onCreateOptionsMenu(menu);
    this.menu = menu;
    return result;
  }

  @Override
  public CharSequence getTabTitle(int which) {
    switch (which) {
      case 0:
        return "Connect";
      case 1:
        return "Settings";
      case 2:
        return "Queue";
      default:
        break;
    }
    return null;
  }

  @Override
  public Fragment createFragment(int which) {
    switch (which) {
      case 0:
        PreferenceWithSummaryFragment callbackFragment = PreferenceWithSummaryFragment.create(R.xml.preferences_callback);
        callbackFragment.getExcludedPreferences().add("selected_time");
        callbackFragment.getExcludedPreferences().add("desired_time");
        return callbackFragment;
      case 1:
        return PreferenceWithSummaryFragment.create(R.xml.preferences_settings);
      case 2:
        return PreferenceWithSummaryFragment.create(R.xml.preferences_queue);
      default:
        break;
    }
    return null;
  }

  @Override
  public int getTabCount() {
    return 3;
  }

  @Override
  public Integer getFragmentMenu(int which) {
    switch (which) {
      case 0:
        return R.menu.callback_actions;
      case 1:
        return null;
      case 2:
        return R.menu.queue_actions;
      default:
        break;
    }
    return null;
  }


    @Override
  public boolean onOptionsItemSelected(MenuItem item) {
    if (item.getItemId() == R.id.connect) {
      if (!gmsEndpoint.isUrlSet()) {
        Toast.makeText(this, "Server settings not configured!", Toast.LENGTH_SHORT).show();
        Timber.w("FmsEndpoint has not been initialized.");
      } else {
        boolean bPushEnabled = sharedPreferences.getBoolean("push_notifications_enabled", false);
        String strGcmRegId = sharedPreferences.getString(GcmManager.PROPERTY_REG_ID, null);
        if (bPushEnabled && strGcmRegId == null) {
          Toast.makeText(this, "FCM is not registered!", Toast.LENGTH_SHORT).show();
          Timber.w("Push Notifications enabled but FCM is not registered.");
        } else if(!bPushEnabled) {
          if(strGcmRegId == null) {
            Toast.makeText(this, "FCM not registered!", Toast.LENGTH_SHORT).show();
            Timber.w("strGcmRegId is null/FCM is not registered.");
          } else {
            Toast.makeText(this, "Push Notifications not enabled", Toast.LENGTH_SHORT).show();
            Timber.w("Push Notifications not enabled/FCM is not registered.");
          }
        } else{
          item.setEnabled(false);
          Toast.makeText(this, "Connecting...", Toast.LENGTH_SHORT).show();
          controller.connect();
        }
      }
      return true;
    } else if (item.getItemId() == R.id.log) {
      startActivity(new Intent(this, LogActivity.class));
      return true;
    } else if (item.getItemId() == R.id.refresh_queue) {
      if (!gmsEndpoint.isUrlSet()) {
        // Repeated code
        Toast.makeText(this, "Server settings not configured!", Toast.LENGTH_SHORT).show();
        Timber.w("GmsEndpoint has not been initialized.");
      } else {
        // TODO: Provide session management, tracking.
        controller.checkQueuePosition();
        item.setEnabled(false);
      }
      return true;
    } else if (item.getItemId() == R.id.about) {
      DialogFragment dialog = new AboutDialogFragment();
      dialog.show(getFragmentManager(), "dialog_about");
      return true;
    } else if (item.getItemId() == R.id.test) {
            /*
            String sampleData = "{\"channel\":\"/_genesys\",\"data\":{\"message\":{\"transcriptPosition\":\"2\",\"startedAt\":\"2015-02-10T22:39:23Z\",\"chatServiceMessage\":\"Chat service is available\",\"transcriptToShow\":[[\"Notice.Joined\",\"chat1\",\"has joined the session\",\"6\",\"AGENT\"]],\"chatSessionId\":\"0000YaADMWXM0013\",\"chatIxnState\":\"TRANSCRIPT\"},\"id\":\"ad41d420b17511e4adf163edd6718665\",\"tag\":\"service.chat.refresh.180-92e0f9e6-8096-4ccb-94f4-c0d03e14fd8d\"}}";
            ChatCometResponse chatCometResponse = gson.fromJson(sampleData, ChatCometResponse.class);
            Log.d("TEST_VALUE", chatCometResponse.toString());

            String dialogData = "{\"error\":\"\",\"_dialogId\":\"\",\"_id\":\"\",\"_action\":\"DialNumber\",\"_tel_url\":\"\",\"_label\":\"\",\"_content\":[{\"_group_name\":\"groupie\",\"_group_content\":[{\"_label\":\"groupLabel1\",\"_user_action_url\":\"url1\"}]}],\"_chat_parameters\":{\"subject\":\"subject\"}}";
            CallbackDialog callbackDialog = gson.fromJson(dialogData, CallbackDialog.class);
            Log.d("TEST_VALUE", callbackDialog.toString());
            */
      Timber.tag("TEST_VALUE");
      Timber.d("Launching GenesysChatActivity");
      Intent intent = new Intent(this, GenesysChatActivity.class);
      intent.setAction(Globals.ACTION_GENESYS_START_CHAT);
      intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_CLEAR_TOP);
      this.startActivity(intent);
      return true;
    } else if (item.getItemId() == R.id.share_screen) {
      CaptureManager.fireScreenCaptureEvent(this);
      // TODO: Send intent to start CaptureService
    }
    return true;
  }

  /**
   * EVENT HANDLERS ARE HERE
   **/

  public void onEventMainThread(FcmRegisterDoneEvent event) {
    // Because the PreferenceFragment is being used, simple things like
    // toggling Enabled is ugly.
    Toast.makeText(this, "FCM Registered!", Toast.LENGTH_SHORT).show();
    PreferenceFragment settingsFragment = (PreferenceFragment) this.getFragment(1);
    Preference pushToggle = settingsFragment.findPreference("push_notifications_enabled");
    Preference senderIdField = settingsFragment.findPreference("new_gcm_sender_id");
    if (pushToggle != null && senderIdField != null) {
      pushToggle.setEnabled(true);
      senderIdField.setEnabled(true);
    }
    updateFcmToken();
  }

  public void onEventMainThread(FcmUnregisterDoneEvent event) {
    if (event.isPendingWork()) {
      // Can use EventBus priorities to cancel this in GcmManager
      return;
    }
    Toast.makeText(this, "FCM Unregistered!", Toast.LENGTH_SHORT).show();
    PreferenceFragment settingsFragment = (PreferenceFragment) this.getFragment(1);
    Preference pushToggle = settingsFragment.findPreference("push_notifications_enabled");
    Preference senderIdField = settingsFragment.findPreference("new_gcm_sender_id");
    if (pushToggle != null && senderIdField != null) {
      pushToggle.setEnabled(true);
      senderIdField.setEnabled(true);
    }
    updateFcmToken();
  }

  private void updateFcmToken() {
      PreferenceFragment settingsFragment = (PreferenceFragment) this.getFragment(1);
      String registrationId = sharedPreferences.getString(GcmManager.PROPERTY_REG_ID, "");
      EditTextPreference fcmTokenField = (EditTextPreference)settingsFragment.findPreference("fcm_token_id");
      if (registrationId == "") {
          registrationId = "[empty]";
      }
      Timber.d("updating FCM Token : " + registrationId);
      fcmTokenField.setSummary(registrationId);
  }

  public void onEventMainThread(FcmErrorEvent event) {
    Toast.makeText(this, "FCM Error!", Toast.LENGTH_SHORT).show();
    Timber.e(event.error, "FCM Error encountered.");
    PreferenceFragment settingsFragment = (PreferenceFragment) this.getFragment(1);
    Preference pushToggle = settingsFragment.findPreference("push_notifications_enabled");
    Preference senderIdField = settingsFragment.findPreference("new_gcm_sender_id");
    if (pushToggle != null && senderIdField != null) {
      pushToggle.setEnabled(true);
      // I'd be able to set this back to "Disabled" if it weren't a SwitchPreference...
      senderIdField.setEnabled(true);
    }
  }

  public void onEventMainThread(CallbackStartDoneEvent event) {
    MenuItem item = menu.findItem(R.id.connect);
    if (item != null) {
      item.setEnabled(true);
    }
    controller.handleDialog(event.callbackDialog);
  }

  public void onEventMainThread(CallbackAvailabilityDoneEvent event) {
    controller.updateTimeSlots(event.availability);
  }

  public void onEventMainThread(CallbackDialogDoneEvent event) {
    if (event.success) {
      controller.handleDialog(event.callbackDialog);
    } else {
      // TODO: Otherwise, show error
      Toast.makeText(this, "Unknown dialog error, check logs.", Toast.LENGTH_SHORT).show();
    }
  }

  public void onEventMainThread(ServiceStartDoneEvent event){
    String msg;
    if ( event.response!=null) {
      if (event.response.getBody() instanceof TypedByteArray) {
        TypedByteArray b = (TypedByteArray) event.response.getBody();
        msg = new String(b.getBytes(), Charset.forName("UTF-8"));
        JsonParser parser = new JsonParser();

        JsonObject json = parser.parse(msg).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = gson.toJson(json);
        Toast.makeText(this, "Service answered:" + prettyJson,Toast.LENGTH_LONG).show();
        return;
      }
      Toast.makeText(this, "Service returned:"+ event.response.getStatus(), Toast.LENGTH_LONG).show();
      return;
    }
    Toast.makeText(this, "Service not anwsered", Toast.LENGTH_SHORT).show();
  }

  public void onEventMainThread(CallbackCheckQueueDoneEvent event) {
    MenuItem item = menu.findItem(R.id.refresh_queue);
    if (item != null) {
      item.setEnabled(true);
    }
    if (event.success) {
      controller.updateQueuePosition(event.callbackQueuePosition);
    } else {
      // TODO: Otherwise, show error
      Toast.makeText(this, "Unable to check queue!", Toast.LENGTH_SHORT).show();
    }
  }

  public void onEventMainThread(CallbackErrorEvent event) {
    Timber.e("CallbackErrorEvent received: %s", event.callbackException);
    MenuItem item = menu.findItem(R.id.connect);
    if (item != null) {
      item.setEnabled(true);
    }
    String exceptionMessage = event.callbackException.getMessage();
    if (exceptionMessage == null || exceptionMessage.isEmpty()) {
      // TODO:
      return;
    }
    Toast.makeText(this, exceptionMessage, Toast.LENGTH_SHORT).show();
  }

  public void onEventMainThread(FcmReceiveEvent event) {

    Timber.d("event received");
    // Processed, remove sticky!
    bus.removeStickyEvent(event);

    if (!gmsEndpoint.isUrlSet()) {
      Toast.makeText(this, "Server settings not configured. Can't process event!", Toast.LENGTH_SHORT).show();
      Timber.d("FcmReceiveEvent dropped: Server settings not configured.");
      return;
    }


    String gcmMessage = event.message.getData().get("message");
    if (gcmMessage == null || gcmMessage.isEmpty()) {
        // TODO: There is no message.
        Timber.d("FcmReceiveEvent dropped: No message found.");
        return;
    }

    Map<String, String> result = null;
    try {
         result = parseJsonString(new JSONObject(gcmMessage));
    }catch(JSONException ex) {
         Timber.e("JSONException " + ex);
    }

    if (result == null) {
        Timber.d("Unable to parse message into FcmSyncMessage: " + gcmMessage );
        return;
    }

    GcmSyncMessage gcmSyncMessage = new GcmSyncMessage(result.get("_id"), result.get("_action"));
    Timber.d("FcmSyncMessage" + gcmSyncMessage.toString());
    if (gcmSyncMessage != null && gcmSyncMessage.getAction() != null) {
      controller.handleGcmMessage(gcmSyncMessage);
    } else {
      // TODO: Handle a Chat notification in foreground
    }
  }

  public void onEventMainThread(UnknownErrorEvent event) {
    Timber.e(event.error, "UnknownErrorEvent received.");
    MenuItem item = menu.findItem(R.id.connect);
    if (item != null) {
      item.setEnabled(true);
    }
    Toast.makeText(this, event.error.getMessage(), Toast.LENGTH_SHORT).show();
  }

  private Map<String, String> parseJsonString(JSONObject jsonMsg) {
      Map<String, String> result = new HashMap<String, String>();
      try {
          JSONObject jsonObject = new JSONObject(jsonMsg.get("message").toString());

          Iterator key = jsonObject.keys();
          while (key.hasNext()) {
              String k = key.next().toString();
              Timber.d("Key : " + k + ", value : " + jsonObject.getString(k));
              if (k.equalsIgnoreCase("_id") || k.equalsIgnoreCase("_action")) {
                  result.put(k, jsonObject.getString(k));
              }
          }
      }catch (JSONException ex) {
          Timber.e("JSONException: " + ex);
      }
      return result;
    }

    private BroadcastReceiver mReceiver = new BroadcastReceiver(){
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.i("Receiver", "Broadcast received: " + action);
            updateFcmToken();
        }
    };


}
