/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy;

import android.app.Application;
import android.content.Context;
import android.media.projection.MediaProjectionManager;
import android.support.v4.app.NotificationManagerCompat;
import android.view.WindowManager;

import com.genesys.gms.mobile.callback.demo.legacy.common.ForApplication;
import com.genesys.gms.mobile.callback.demo.legacy.data.DataModule;
import com.genesys.gms.mobile.callback.demo.legacy.data.push.FcmInstanceIdService;
import com.genesys.gms.mobile.callback.demo.legacy.data.push.FcmMessagingService;
import com.google.firebase.iid.FirebaseInstanceId;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;

/** Top-level Dagger module - see Square's Dagger documentation for details */
@Module(
    injects = {
        App.class,
        FcmInstanceIdService.class,
        FcmMessagingService.class
    },
    includes = {
        DataModule.class
    },
    library = true
)
public class AppModule {
  private final App application;

  public AppModule(App application) {
    this.application = application;
  }

  @Provides
  @Singleton
  FirebaseInstanceId provideFirebaseCloudMessaging(@ForApplication Context context) {
    return FirebaseInstanceId.getInstance();
  }

  @Provides
  @Singleton
  WindowManager provideWindowManager(@ForApplication Context context) {
    return (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
  }

  @Provides
  @Singleton
  NotificationManagerCompat provideNotificationManagerCompat(@ForApplication Context context) {
    return NotificationManagerCompat.from(context);
  }

  @SuppressWarnings("ResourceType")
  @Provides
  @Singleton
  MediaProjectionManager provideMediaProjectionManager(@ForApplication Context context) {
    return (MediaProjectionManager) context.getSystemService(Context.MEDIA_PROJECTION_SERVICE);
  }

  @Provides
  @Singleton
  @ForApplication
  Context provideApplicationContext() {
    return application;
  }

  @Provides
  @Singleton
  Application provideApplication() {
    return application;
  }
}