package com.genesys.gms.mobile.callback.demo.legacy.data.api;

import android.os.AsyncTask;

import com.genesys.gms.mobile.callback.demo.legacy.BuildConfig;
import com.genesys.gms.mobile.callback.demo.legacy.client.CometClient;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo.CallbackV2Dialog;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackStartV2DoneEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.callback.CallbackStartV2Event;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chatv2.ChatV2DisconnectEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chatv2.ChatV2SendEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chatv2.ChatV2StartEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chatv2.ChatV2StartTypingEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chatv2.ChatV2StopTypingEvent;

import javax.inject.Inject;
import javax.inject.Singleton;

import de.greenrobot.event.EventBus;
import timber.log.Timber;

/**
 * Created by pbalakri on 28-11-2017.
 */
@Singleton
public class ChatV2ApiManager {
    private CometClient cometClient;
    private EventBus bus;

    @Inject
    public ChatV2ApiManager() {
        this.bus = EventBus.getDefault();
    }

    public void onEvent(CallbackStartV2Event event){
        String protocol = event.isSecure? "https":"http";
        String cometUrl = protocol + "://" + event.host + ":" + event.port + "/genesys/cometd";

        if (BuildConfig.DEBUG) Timber.d("cometUrl: " + cometUrl);
        CallbackV2Dialog dialog =  new CallbackV2Dialog(cometUrl,null,  event.subject);
        bus.post(new CallbackStartV2DoneEvent(dialog));
    }

    public void onEvent(ChatV2StartTypingEvent event){
        new ExecuteStartTypingEvent().execute(event);
    }

    public void onEvent(ChatV2StopTypingEvent event){
        new ExecuteStopTypingEvent().execute(event);
    }

    public void onEvent(ChatV2StartEvent event){
        new ExecuteStartEvent().execute(event);
    }

    public void onEvent(ChatV2SendEvent event){
        new ExecuteSendEvent().execute(event);
    }

    public void onEvent(ChatV2DisconnectEvent event) {
        new ExecuteDisconnectEvent().execute(event);
    }


    private class ExecuteStartTypingEvent extends AsyncTask<ChatV2StartTypingEvent, Void, Void> {

        @Override
        protected Void doInBackground(ChatV2StartTypingEvent... chatV2StartTypingEvents) {
            cometClient = CometClient.getInstance();
            cometClient.startOpTyping(chatV2StartTypingEvents[0]);
            return null;
        }
    }

    private class ExecuteStopTypingEvent extends AsyncTask<ChatV2StopTypingEvent, Void, Void>{
        @Override
        protected Void doInBackground(ChatV2StopTypingEvent... chatV2StopTypingEvents) {
            cometClient = CometClient.getInstance();
            cometClient.stopOpTyping(chatV2StopTypingEvents[0]);
            return null;
        }
    }

    private class ExecuteStartEvent extends AsyncTask<ChatV2StartEvent, Void, Void> {

        @Override
        protected Void doInBackground(ChatV2StartEvent... chatV2StartEvents) {
            cometClient = CometClient.getInstance();
            cometClient.requestChat(chatV2StartEvents[0]);
            return null;
        }
    }

    private class ExecuteSendEvent extends AsyncTask<ChatV2SendEvent, Void, Void> {

        @Override
        protected Void doInBackground(ChatV2SendEvent... chatV2SendEvents) {
            cometClient = CometClient.getInstance();
            cometClient.sendOpMessage(chatV2SendEvents[0]);
            return null;
        }
    }

    private class ExecuteDisconnectEvent extends AsyncTask<ChatV2DisconnectEvent, Void, Void> {

        @Override
        protected Void doInBackground(ChatV2DisconnectEvent... chatV2DisconnectEvents) {
            cometClient = CometClient.getInstance();
            cometClient.disconnectChatV2(chatV2DisconnectEvents[0]);
            return null;
        }
    }
}
