package com.genesys.gms.mobile.callback.demo.legacy.data.api;

import android.app.DownloadManager;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Environment;
import android.preference.PreferenceActivity;
import android.widget.Toast;

import com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo.ChatException;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo.ChatResponse;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo.FileDownloadResponse;
import com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo.FileUploadResponse;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.UnknownErrorEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chat.ChatErrorEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.chat.ChatResponseEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.filemgmt.FileDownloadRequestEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.filemgmt.FileDownloadedEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.filemgmt.FileUploadEvent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.filemgmt.FileUploadResponseEvent;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

import de.greenrobot.event.EventBus;
import hugo.weaving.DebugLog;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Header;
import retrofit.mime.MultipartTypedOutput;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedString;
import timber.log.Timber;

/**
 * Created by taillan2 on 27/11/2017.
 */
@Singleton
public class FileManagementApiManager {
    private final FileManagmentApi fileManagementApi;
    private final EventBus bus;

    @Inject
    @DebugLog
    public FileManagementApiManager(@Named(ApiModule.V2)FileManagmentApi fileManagementApi) {
        this.fileManagementApi = fileManagementApi;
        this.bus = EventBus.getDefault();
    }

    private TypedFile makeFile(String uri){
        // this will make file which is required by Retrofit.
        File file = new File(uri);
        TypedFile typedFile = new TypedFile("*/*",file);
        return typedFile;
    }

    private MultipartTypedOutput attachFile(String secureKey, String file){
        MultipartTypedOutput multipartTypedOutput = new MultipartTypedOutput();

        // this will add data to body to send via retrofit.
        multipartTypedOutput.addPart("operation",new TypedString("fileUpload"));
        multipartTypedOutput.addPart("secureKey", new TypedString(secureKey));

        // this will make Retrofit file from gallery image
        multipartTypedOutput.addPart("file", makeFile(file));
        return multipartTypedOutput;
    }

    public void onEvent(FileUploadEvent event){
        MultipartTypedOutput multiparts = attachFile(event.getSecureKey(),event.getFile());
        fileManagementApi.uploadFile( multiparts,new Callback<FileUploadResponse>() {


            @Override
            public void success(FileUploadResponse fileUploadResponse, retrofit.client.Response response) {
                bus.post(new FileUploadResponseEvent(
                        fileUploadResponse
                ));
            }

            @Override
            public void failure(RetrofitError error) {
                return;
            }
        });
    }

    public void onEvent(final FileDownloadRequestEvent event){

        fileManagementApi.downloadFile("fileDownload", event.getFileId(), event.getSecureKey(),new Callback<retrofit.client.Response>() {


            private boolean writeResponseBodyToDisk(retrofit.client.Response body) {
                try {
                    String fileName = "";
                    for (Header header : body.getHeaders()) {
                        if (header.getName().equals("Content-Disposition")) {
                            fileName = header.getValue().replaceFirst("(?i)^.*filename=\"?([^\"]+)\"?.*$", "$1");
                            break;
                        }
                    }
                    // this is specific case, it's up to you how you want to save your file
                    // if you are not downloading file from direct link, you might be lucky to obtain file name from header
                    String filePath = Environment.getExternalStorageDirectory()+ File.separator+"Download" + File.separator +fileName;
                    File futureStudioIconFile = new File(filePath);
                    InputStream inputStream = null;
                    OutputStream outputStream = null;

                    try {
                        byte[] fileReader = new byte[4096];

                        long fileSize = body.getBody().length();
                        long fileSizeDownloaded = 0;

                        inputStream = body.getBody().in();
                        outputStream = new FileOutputStream(futureStudioIconFile);

                        while (true) {
                            int read = inputStream.read(fileReader);

                            if (read == -1) {
                                break;
                            }

                            outputStream.write(fileReader, 0, read);

                            fileSizeDownloaded += read;

                            Timber.i("file download: " + fileSizeDownloaded + " of " + fileSize);
                        }

                        outputStream.flush();
                        bus.post( new FileDownloadedEvent(filePath));
                        Timber.i("file download was a success");
                        return true;
                    } catch (IOException e) {
                        return false;
                    } finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }

                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                } catch (IOException e) {
                    return false;
                }
            }



            @Override
            public void success(retrofit.client.Response response, retrofit.client.Response response2) {
                Timber.i("server contacted and has file");
                boolean writtenToDisk = writeResponseBodyToDisk(response);


            }

            @Override
            public void failure(RetrofitError error) {

                return;
            }
        });
    }




}
