/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo;

import org.joda.time.DateTime;

import java.util.Map;

/**
 * Created by stau on 02/11/2014.
 */
public class CallbackRescheduleException {
  private final String message;
  private final String exception;
  private final String error;
  private final Map<DateTime, Integer> availability;

  public CallbackRescheduleException(String message,
                                     String exception,
                                     String error,
                                     Map<DateTime, Integer> availability) {
    this.message = message;
    this.exception = exception;
    this.error = error;
    this.availability = availability;
  }

  public String getMessage() {
    return message;
  }

  public String getException() {
    return exception;
  }

  public String getError() {
    return error;
  }

  public Map<DateTime, Integer> getAvailability() {
    return availability;
  }

  @Override
  public String toString() {
    return getClass().getName() + "@" + hashCode() +
        "[" +
        "message=" + message +
        ",exception=" + exception +
        ",error=" + error +
        ",availability=" + availability +
        "]";
  }
}