/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo;

/**
 * Created by stau on 2/9/2015.
 */
public class ChatCometResponse {
  private final ChatCometData data;
  private final String channel;

  public ChatCometResponse(ChatCometData data, String channel) {
    this.data = data;
    this.channel = channel;
  }

  public ChatCometData getData() {
    return data;
  }

  public String getChannel() {
    return channel;
  }

  @Override
  public String toString() {
    return getClass().getName() + "@" + hashCode() +
        "[" +
        "data=" + data +
        ",channel=" + channel +
        "]";
  }

  public class ChatCometData {
    private final String id;
    private final ChatResponse message;
    private final String tag;

    public ChatCometData(String id, ChatResponse message, String tag) {
      this.id = id;
      this.message = message;
      this.tag = tag;
    }

    public String getId() {
      return id;
    }

    public ChatResponse getMessage() {
      return message;
    }

    public String getTag() {
      return tag;
    }

    @Override
    public String toString() {
      return getClass().getName() + "@" + hashCode() +
          "[" +
          "id=" + id +
          ",message=" + message +
          ",tag=" + tag +
          "]";
    }
  }
}
