/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.api.pojo;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Created by stau on 2/12/2015.
 */
public class GcmChatMessage {
  private final String message;
  private final String serviceId;
  private final List<TranscriptBrief> lastTranscript;

  public GcmChatMessage(String message,
                        String serviceId,
                        List<TranscriptBrief> lastTranscript) {
    this.message = message;
    this.serviceId = serviceId;
    this.lastTranscript = lastTranscript;
  }

  public String getMessage() {
    return message;
  }

  public String getServiceId() {
    return serviceId;
  }

  public List<TranscriptBrief> getLastTranscript() {
    return lastTranscript;
  }

  @Override
  public String toString() {
    return getClass().getName() + "@" + hashCode() +
        "[" +
        "message=" + message +
        ",serviceId=" + serviceId +
        ",lastTranscript=" + lastTranscript +
        "]";
  }

  public static class TranscriptBrief {
    @SerializedName("Message.Text")
    private final String messageText;

    public TranscriptBrief(String messageText) {
      this.messageText = messageText;
    }

    public String getMessageText() {
      return messageText;
    }

    @Override
    public String toString() {
      return getClass().getName() + "@" + hashCode() +
          "[" +
          "messageText=" + messageText +
          "]";
    }
  }
}
