/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.capture;

import android.app.IntentService;
import android.content.Intent;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.capture.StopCaptureEvent;
import de.greenrobot.event.EventBus;
import timber.log.Timber;

/**
 * Created by stau on 5/14/2015.
 */
public class CaptureIntentService extends IntentService {
  private final EventBus bus;

  public CaptureIntentService() {
    super("CaptureIntentService");
    bus = EventBus.getDefault();
  }

  @Override
  protected void onHandleIntent(Intent intent) {
    Timber.d("Handling Notification intent for StopCaptureEvent");
    bus.post(new StopCaptureEvent());
  }
}
