package com.genesys.gms.mobile.callback.demo.legacy.data.retrofit;

import android.util.Log;

import javax.inject.Singleton;

import hugo.weaving.DebugLog;
import retrofit.Endpoint;

/**
 * Created by taillan2 on 27/11/2017.
 */
@Singleton
public class FileManagementEndpoint implements Endpoint {
    private static final String ENDPOINT_HOST = "endpoint_host";
    private static final String ENDPOINT_PORT = "endpoint_port";
    private static final String ENDPOINT_API_VERSION = "endpoint_api_version";
    private String m_strUrl;

    @DebugLog
    public FileManagementEndpoint() {
        super();
    }

    @Override
    public String getName() {
        return "FileManagement";
    }

    @DebugLog
    public void setUrl(String protocol, String p_strHost, Integer p_nPort, String p_strApp, Integer p_nApiVersion) {
        if (protocol == null || p_strHost == null || p_strHost.isEmpty() || p_strApp == null || p_strApp.isEmpty() || p_nPort == null || p_nApiVersion == null) {
            m_strUrl = null;
        } else {
            m_strUrl = String.format(protocol + "://%s:%d/%s/2", p_strHost, p_nPort, p_strApp);
        }
        Log.d("FileManagementEndpoint", "Endpoint URL: " + m_strUrl);
        //Timber.d("Endpoint URL: ", m_strUrl);
    }

    public boolean isUrlSet() {
        return m_strUrl != null;
    }

    @Override
    public String getUrl() {
        if (m_strUrl == null) throw new IllegalStateException("setUrl() has not been called");
        return m_strUrl;
    }
}
