/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.retrofit;

import android.util.Log;

import com.genesys.gms.mobile.callback.demo.legacy.data.api.ApiModule;

import hugo.weaving.DebugLog;
import retrofit.Endpoint;

import javax.inject.Inject;
import javax.inject.Singleton;

/**
 * Custom Retrofit Endpoint for dynamic redefinition of endpoint address
 * without having to perform an expensive rebuild of the RestAdapter
 * See answer from JakeWharton: http://stackoverflow.com/a/23279628
 */
@Singleton
public class GmsEndpoint implements Endpoint {
  private static final String ENDPOINT_HOST = "endpoint_host";
  private static final String ENDPOINT_PORT = "endpoint_port";
  private static final String ENDPOINT_API_VERSION = "endpoint_api_version";
  private String m_strUrl;

  @DebugLog
  @Inject
  public GmsEndpoint() {
    super();
  }

  @Override
  public String getName() {
    return "default";
  }

  @DebugLog
  public void setUrl(String protocol, String p_strHost, Integer p_nPort, String p_strApp, Integer p_nApiVersion ) {
    if (protocol == null || p_strHost == null || p_strHost.isEmpty() || p_strApp == null || p_strApp.isEmpty() || p_nPort == null || p_nApiVersion == null) {
      m_strUrl = null;
    } else {
      m_strUrl = String.format(protocol+"://%s:%d/%s/%d", p_strHost, p_nPort,p_strApp, p_nApiVersion);
    }
    Log.d("GmsEndpoint", "Endpoint URL: " + m_strUrl);
    //Timber.d("Endpoint URL: ", m_strUrl);
  }

  public boolean isUrlSet() {
    return m_strUrl != null;
  }

  @Override
  public String getUrl() {
    if (m_strUrl == null) throw new IllegalStateException("setUrl() has not been called");
    return m_strUrl;
  }
}