/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.retrofit;

import android.util.Log;

import com.genesys.gms.mobile.callback.demo.legacy.util.Globals;

import hugo.weaving.DebugLog;
import retrofit.RequestInterceptor;

import javax.inject.Singleton;

/**
 * Created by stau on 2/6/2015.
 */
@Singleton
public class GmsRequestInterceptor implements RequestInterceptor {

  private String gmsUser;
  private String apiGeeKey;
  private String scenario;
  private String simpleParams;

  @DebugLog
  public GmsRequestInterceptor() {
    super();
  }

  public String getGmsUser() {
    return gmsUser;
  }

  public void setGmsUser(String newUser) {
    Log.d("GmsRequestInterceptor", "Setting gms_user: " + newUser);
    this.gmsUser = newUser;
  }

  public void setScenario(String newScenario) {
    Log.d("GmsRequestInterceptor", "Setting simple service Params: " + scenario);
    this.scenario = newScenario;
  }

  public void setApiGeeKey(String apiGeeKey) {
    Log.d("GmsRequestInterceptor", "Setting apiGeeKey: " + apiGeeKey);
    this.apiGeeKey = apiGeeKey;
  }

  public void setSimpleParams(String simpleParams) {
    Log.d("GmsRequestInterceptor", "Setting simpleParams: " + simpleParams);
    this.simpleParams = simpleParams;
  }

  @Override
  public void intercept(RequestFacade request) {
    Log.d("GmsRequestInterceptor", "Inserting gms_user: " + gmsUser + " header.");
    if (gmsUser != null && !gmsUser.isEmpty()) {
      request.addHeader(Globals.GMS_USER_HEADER, gmsUser);
    }
    Log.d("GmsRequestInterceptor", "Inserting apiGeeKey: " + apiGeeKey + " header.");
    if (apiGeeKey != null && !apiGeeKey.isEmpty()) {
      request.addHeader(Globals.APIGEEKEY, apiGeeKey);
    }
    //if(scenario.equals("SIMPLE-SERVICE")){
    if ( simpleParams != null && !simpleParams.isEmpty()) {
      String[] params = simpleParams.split(",");
      for (int i = 0; i < params.length; i++) {
        String[] kv = params[i].split("=");
        request.addQueryParam(kv[0], kv[1]);
      }
    }
    //}

  }
}
