/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.ui;

import org.slf4j.Logger;

public class LoggingExceptionHandler implements Thread.UncaughtExceptionHandler {
  private final Thread.UncaughtExceptionHandler originalHandler = Thread.getDefaultUncaughtExceptionHandler();
  private final Logger logger;

  public LoggingExceptionHandler(Logger logger) {
    this.logger = logger;
  }

  @Override
  public void uncaughtException(Thread thread, Throwable ex) {
    logger.error("Uncaught exception: ", ex);

    if (originalHandler != null)
      originalHandler.uncaughtException(thread, ex);
    else
      System.exit(0);
  }

  public static void setDefaultUncaughtExceptionHandler(Logger logger) {
    Thread.setDefaultUncaughtExceptionHandler(new LoggingExceptionHandler(logger));
  }
}

