/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.events.callback;

import org.joda.time.DateTime;

/**
 * Created by stau on 2/3/2015.
 */
public class CallbackAvailabilityEvent {
  public final String serviceName;
  public final DateTime start;
  public final Integer numberOfDays;
  public final DateTime end;
  public final Integer maxTimeSlots;

  public CallbackAvailabilityEvent(String serviceName,
                                   DateTime start,
                                   Integer numberOfDays,
                                   DateTime end,
                                   Integer maxTimeSlots) {
    this.serviceName = serviceName;
    this.start = start;
    this.numberOfDays = numberOfDays;
    this.end = end;
    this.maxTimeSlots = maxTimeSlots;
  }

  @Override
  public String toString() {
    return getClass().getName() + "@" + hashCode() +
        "[" +
        "serviceName=" + serviceName +
        ",start=" + start +
        ",numberOfDays=" + numberOfDays +
        ",end=" + end +
        ",maxTimeSlots=" + maxTimeSlots +
        "]";
  }
}
