/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.events.callback;

/**
 * Created by Stan on 2/8/2015.
 */
public class CallbackDialogEvent {
  public final String url;
  public final boolean isFragment;
  public final String method;

  public CallbackDialogEvent(String url, boolean isFragment) {
    this.url = url;
    this.isFragment = isFragment;
    this.method = "GET";
  }

  public CallbackDialogEvent(String url, boolean isFragment, String method) {
    this.url = url;
    this.isFragment = isFragment;
    this.method = method;
  }

  @Override
  public String toString() {
    return getClass().getName() + "@" + hashCode() +
        "[" +
            "method=" + method +
        ",url=" + url +
        ",isFragment=" + isFragment +
        "]";
  }
}
