/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.data.gson;

import com.genesys.gms.mobile.callback.demo.legacy.util.TimeHelper;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import org.joda.time.DateTime;

import java.io.IOException;

/**
 * Created by stau on 02/11/2014.
 */
public class DateTimeTypeAdapter extends TypeAdapter<DateTime> {
  @Override
  public void write(JsonWriter out, DateTime value) throws IOException {
    if (value == null) {
      out.nullValue();
      return;
    }
    out.value(TimeHelper.serializeUTCTime(value));
  }

  @Override
  public DateTime read(JsonReader in) throws IOException {
    if (in.peek() == JsonToken.NULL) {
      in.nextNull();
      return null;
    }
    return TimeHelper.parseISO8601DateTime(in.nextString());
  }
}