package com.genesys.gms.mobile.callback.demo.legacy.data.push;

import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.util.Log;

import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

/**
 * Created by pbalakri on 01-11-2017.
 */

public class FcmInstanceIdService extends FirebaseInstanceIdService {
    private static final String LOG_TAG = "FcmInstanceIdService";

    public static final String PROPERTY_REG_ID = "registration_id";
    private static final String PROPERTY_APP_VERSION = "app_version";

    @Override
    public void onTokenRefresh() {
         /* Getting registration token */
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();

        /* Displaying token on logcat */
        Log.d(LOG_TAG, "Refreshed token: " + refreshedToken);
        processRegistration(refreshedToken);

        /* Post using the Event Bus */
    }

    // TODO: Move into utility class
    private int getAppVersion() {
        try {
            PackageInfo packageInfo = this.getApplicationContext().getPackageManager()
                    .getPackageInfo(this.getApplicationContext().getPackageName(), 0);
            return packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            //Timber.e(e, "Failed to obtain application version code.");
            throw new RuntimeException("Could not get package name: " + e);
        }
    }
    private void processRegistration(String regId) {

        int appVersion = getAppVersion();
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this).edit();
        if (regId == null || regId.isEmpty()) {
            editor.remove(PROPERTY_REG_ID);
            editor.remove(PROPERTY_APP_VERSION);
        } else {
            editor.putString(PROPERTY_REG_ID, regId);
            editor.putInt(PROPERTY_APP_VERSION, appVersion);
        }
        editor.apply();
    }
}
