package com.genesys.gms.mobile.callback.demo.legacy.data.push;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.media.RingtoneManager;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;

import com.genesys.gms.mobile.callback.demo.legacy.App;
import com.genesys.gms.mobile.callback.demo.legacy.R;
import com.genesys.gms.mobile.callback.demo.legacy.data.events.fcm.FcmReceiveEvent;
import com.genesys.gms.mobile.callback.demo.legacy.ui.GenesysSampleActivity;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;

import javax.inject.Inject;

import de.greenrobot.event.EventBus;
import timber.log.Timber;

/**
 * Created by pbalakri on 01-11-2017.
 */

public class FcmMessagingService extends FirebaseMessagingService {
    private static final String LOG_TAG = "FcmMessagingService";

    private final EventBus bus;

    @Inject
    FirebaseInstanceId fcm;

    @Inject
    Gson gson;

    @Inject
    SharedPreferences sharedPreferences;

    @Inject
    NotificationManagerCompat mNotificationManager;


    public FcmMessagingService() {
        this.bus = EventBus.getDefault();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        App application = (App) getApplication();
        application.getApplicationGraph().inject(this);
    }

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        Timber.d("remoteMessage: " + remoteMessage);

        // Check if message contains a data payload.
        if (remoteMessage.getData().size() > 0) {
            FcmReceiveEvent event = new FcmReceiveEvent(remoteMessage, false);
            bus.postSticky(event);
        }

    }

    @Override
    public void handleIntent(Intent intent) {
        try
        {
            if (intent.getExtras() != null) {
                RemoteMessage.Builder remoteMsg = new RemoteMessage.Builder("FcmMessagingService");
                for (String key : intent.getExtras().keySet()) {
                    remoteMsg.addData(key, intent.getExtras().get(key).toString());
                }

                bus.postSticky(new FcmReceiveEvent(remoteMsg.build(), false));

            } else {
                super.handleIntent(intent);
            }
        } catch (Exception e) {
            super.handleIntent(intent);
        }
    }

    /* This method is only generating push notification */
    private void sendNotification(String messageBody) {
        Intent intent = new Intent(this, GenesysSampleActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, intent,
                PendingIntent.FLAG_ONE_SHOT);

        Uri defaultSoundUri= RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this)
                .setSmallIcon(R.mipmap.ic_launcher_genesys)
                .setContentTitle("Firebase Push Notification")
                .setContentText(messageBody)
                .setAutoCancel(true)
                .setSound(defaultSoundUri)
                .setContentIntent(pendingIntent);

        NotificationManager notificationManager =
                (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

        notificationManager.notify(0, notificationBuilder.build());
    }
}
