/*
 * Copyright (C) 2015 Genesys
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.genesys.gms.mobile.callback.demo.legacy.ui;

import android.content.Context;
import com.genesys.gms.mobile.callback.demo.legacy.AppModule;
import com.genesys.gms.mobile.callback.demo.legacy.common.BaseActivity;
import com.genesys.gms.mobile.callback.demo.legacy.common.ForActivity;
import dagger.Module;
import dagger.Provides;

import javax.inject.Singleton;

@Module(
    injects = {
        GenesysSampleActivity.class,
        GenesysChatActivity.class,
        LogActivity.class,
        LogFragment.class,
        PreferenceWithSummaryFragment.class
    },
    addsTo = AppModule.class,
    library = true
)
public class UiModule {
  private final BaseActivity activity;

  public UiModule(BaseActivity activity) {
    this.activity = activity;
  }

  @Provides
  @Singleton
  @ForActivity
  Context provideActivityContext() {
    return activity;
  }
}