<%
	String tenant = request.getParameter("tenant");
	if (tenant == null || tenant == "") {
		tenant = "Resources";	
	}
	String chatServerHost = null;
	int chatWebApiPort = -1;
	String diagnosticMessage = null;
	String chatServerLoadBalancerAlias = request.getParameter("chatServerLoadBalancerAlias");
	ServiceInfo si = null;
	Boolean isTLSrequired = null;
	String checkChatServiceLoadBalancerPath = request.getRequestURI();
	
	try {
	    if (chatServerLoadBalancerAlias != null && !chatServerLoadBalancerAlias.equals("")) {
            si = LoadBalancer.GetServiceInfoEx(chatServerLoadBalancerAlias);
	    } else {
			si = LoadBalancer.GetServiceInfo(CfgAppType.CFGChatServer, tenant);
	    }
	} catch (Exception e) {
		diagnosticMessage = "Unable to get chat server information at this point: " + e.getMessage();
    }

    if( si != null ) {
    	chatServerHost = si.getHost();
    	chatWebApiPort = si.getWebApiPort();
		isTLSrequired = si.getIsWebApiPortSecured();
	
		if(chatServerHost == null || chatServerHost.equalsIgnoreCase("") || chatWebApiPort == -1) {
			diagnosticMessage = "Chat service is unavailable at this time. Please try again later.";
		} else {
		    // we have a chat server at this point
		    chatServerLoadBalancerAlias  =   si.getAlias();
		    // add chat server alias to the URL path so that cleint can use it for consequitive requests
		    checkChatServiceLoadBalancerPath = checkChatServiceLoadBalancerPath + "?chatServerLoadBalancerAlias=" + chatServerLoadBalancerAlias;
		    diagnosticMessage = "Chat service is available";
		}
    }

    response.setContentType("application/json; charset=ISO-8859-1");
    
    
    out.write("{\r\n\"checkChatServiceLoadBalancerPath\" : \"" + checkChatServiceLoadBalancerPath + "\","
    + "\r\n\"chatServerLoadBalancerAlias\" : \"" + chatServerLoadBalancerAlias + "\","
    + "\r\n\"chatServerHost\" : \"" + chatServerHost + "\","
    + "\r\n\"chatWebApiPort\" : \"" + chatWebApiPort + "\","
    + "\r\n\"isTLSrequired\" : \"" + isTLSrequired + "\","    
	+ "\r\n\"diagnosticMessage\" : \"" + diagnosticMessage + "\"" 
	+ "\r\n}");
%>
<%@ page import="java.net.URI" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.*" %>
<%@ page import="com.genesyslab.webapi.core.ServiceInfo" %>
<%@ page import="com.genesyslab.webapi.core.LoadBalancer" %>
<%@ page import="com.genesyslab.webapi.utils.i18n.*" %>
<%@ page import="com.genesyslab.platform.configuration.protocol.types.CfgAppType" %>
<%@ page import="com.genesyslab.platform.commons.protocol.Endpoint" %>
<%@ page import="com.genesyslab.platform.commons.collections.KeyValueCollection" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestLogin" %>
<%@ page import="com.genesyslab.platform.commons.protocol.Message" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.flexchat.events.EventStatus" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestJoin" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestRefresh" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.flexchat.requests.RequestLogout" %>
<%@ page import="com.genesyslab.platform.webmedia.protocol.flexchat.*" %>
<%@ page import="com.genesyslab.platform.openmedia.protocol.interactionserver.PartyInfo" %>
<%@ page import="com.genesyslab.webapi.utils.i18n.i18nsupport" %>
<%@ page import="com.genesyslab.platform.commons.connection.configuration.KeyValueConfiguration" %>
<%@ page import="com.genesyslab.platform.commons.connection.Connection" %>
<%-- include file="../constants.jsp" --%>
<%-- include file="../Security.jsp" --%>
<%@ page contentType = "application/json; charset=ISO-8859-1" %>