/*
  GMSAPIUtil.m
  GMS Sample

 Disclaimer: IMPORTANT:  This software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2013 Genesys Inc. All Rights Reserved.
 */

#import <Foundation/Foundation.h>
#import "GMSUtil.h"

static NSDateFormatter *dateFormatter;
static NSDateFormatter *localDateFormatter;

@implementation GMSUtil

+ (NSString*) addParamsFromDictionary:(NSDictionary*)dict toString:(NSString*)base;
{
    __block NSString *paramStr = base;
    __block BOOL first = YES;
    [dict enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
        if (first)
            paramStr = [paramStr stringByAppendingFormat:@"%@=%@", key, value];
        else
            paramStr = [paramStr stringByAppendingFormat:@"&%@=%@", key, value];
        first = NO;
    }];
    return paramStr;
}

// Note, this must be called at startup
+(void) initialize
{
    dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd'T'HH:mm:ss.000'Z'"];
    [dateFormatter setTimeZone:[NSTimeZone timeZoneWithAbbreviation:@"GMT"]];
    
    localDateFormatter = [[NSDateFormatter alloc] init];
    [localDateFormatter setDateFormat:@"EEE LLL dd hh:mm a"];
    [localDateFormatter setTimeZone:[NSTimeZone localTimeZone]];
}

+ (NSDate*) dateFromApiString:(NSString*)dateString
{
    return [dateFormatter dateFromString:dateString];
}

+ (NSString*) apiStringFromDate:(NSDate*)date
{
    return [dateFormatter stringFromDate:date];
}

+ (NSString*) localStringFromDate:(NSDate*)date
{
    return [localDateFormatter stringFromDate:date];
}

+ (NSString*) urlParamsFromDictionary:(NSDictionary*)dict
{
    return [self addParamsFromDictionary:dict toString:@"?"];
}

+ (NSString*) bodyParamsFromDictionary:(NSDictionary*)dict
{
    return [self addParamsFromDictionary:dict toString:@""];
}

+ (NSString*) stringFromNumericValue:(NSObject*)value
{
    if ([value respondsToSelector:@selector(stringValue)])
        return [value performSelector:@selector(stringValue)];
    
    return @"";
}



@end
