(function(angular) {
  /* jshint unused:false */
  'use strict';

  angular.module('ark.calendar.template', ['ark.calendar'])
    .controller('TemplateCtrl', ['$scope', 'arkCalendarConfig',
      function($scope, arkCalendarConfig) {

        // Initialized empty event sources
        $scope.eventSources = [];

        //define event ids
        var type1EventId = 0;
        var type2EventId = 1;
        var type3EventId = 2;

        //define colours and icons for each event type
        var blue = '#2E69DB';
        var yellow = '#F8A740';
        var grey = '#98A7B8';

        var openIcon = 'fonticon icon-phone-rec-resume';
        var stopIcon = 'fonticon icon-phone-rec-stop';
        var disabledIcon = 'fonticon icon-phone-disabled';

        //blockConfig - defines global/default event properties
        var globalEventConfig = [{
          'id': type1EventId,
          'label': 'Event 1',
          'leftBorderColor': blue,
          'icon': openIcon
        }, {
          'id': type2EventId,
          'label': 'Event 2',
          'leftBorderColor': grey,
          'icon': disabledIcon,
          'allDay': true
        }, {
          'id': type3EventId,
          'label': 'Event 3',
          'leftBorderColor': yellow,
          'icon': stopIcon
        }];

        //callback functions
        $scope.onBlockCreate = function(events) {

        };

        $scope.onBlockUpdate = function(event, oldEvent) {

        };

        $scope.onBlockDelete = function(event) {

        };

        $scope.eventResize = function(event, delta, position, revertFunc) {

        };

        $scope.eventDrop = function(event, oldEvent, delta, revertFunc) {

        };

        //define config options for the calendar
        $scope.calendarConfig = {
          calendar: {
            blockConfig: globalEventConfig, //recommended
            calendarNavigator: true, //optional
            defaultView: 'agendaWeek', //optional
            dynamicScrollTime: 1, //optional
            editable: true, //optional
            firstDay: 0, //optional
            header: { //optional
              left: 'checkbox navigator settings',
              center: '',
              right: 'agendaDay,agendaWeek,month timezone'
            },
            generic: false, //optional
            genericCheckbox: true, //optional
            highlightSimilarId: true, //optional
            lazyFetching: false, //optional
            resizeNextDay: false, //optional
            scrollTime: '00:00:00', //optional
            selectable: true, //optional
            slotDuration: '00:30:00', //optional
            switchOnDateClick: true, //optional
            switchOnMonthDayClick: true, //optional
            timezone: false, //optional
            tooltips: true, //optional
            hiddenDays: [], //optional
            onBlockCreate: $scope.onBlockCreate, //required callback function
            onBlockUpdate: $scope.onBlockUpdate, //required callback function
            onBlockDelete: $scope.onBlockDelete, //required callback function
            eventResize: $scope.eventResize, //required callback function
            eventDrop: $scope.eventDrop, //required callback function
            allDayText: 'All Day', //required
            buttonText: { //required
              today: 'Today',
              month: 'Month',
              week: 'Week',
              day: 'Day'
            },
            checkboxName: 'Regular Office Hours', //required
            settingsBtnName: 'Settings', //required
            topLeftAxisLabel: 'Time', //required
            blockModalConfig: { //required
              allDayEventLabel: 'This is an All Day Event',
              blockTimeSlot: 'Block Time Slot',
              blockType: 'Block Type',
              cancelButtonLabel: 'Cancel',
              createButtonLabel: 'Add',
              deleteButtonLabel: 'Delete',
              displayBlockTitleCreate: 'New Office Hours',
              displayBlockTitleModify: 'Modify Office Hours',
              displayDescription: false, //optional - defaults to true
              displayTitle: false, //optional - defaults to true
              errorMessage: 'Error: "From" time must be strictly before "To" time.',
              fromLabel: 'From',
              toLabel: 'To',
              updateButtonLabel: 'Update',
              weeksSelectedLabel: 'Weeks Selected',
              radios: [1, 2]
            },
            genericBlockModalConfig: { //optional
              radios: [0]
            },
            settingsModalConfig: { //required
              allDayLabel: 'Show All Day Row',
              checkboxLabel: 'Checkbox',
              closeButtonLabel: 'Close',
              daysToHideLabel: 'Days to Hide',
              errorLabel: 'Error',
              errorMessage: 'At least one day must be visible',
              firstDayLabel: 'First Day of the Week',
              modalTitle: 'Settings',
              noneOption: 'None',
              onLabel: 'On',
              offLabel: 'Off',
              popoversLabel: 'Popovers',
              saveButtonLabel: 'Save',
              timeIntervalLabel: 'Time Interval per Block',
            }
          }
        };

        //function that feeds ng-model, gets called on every view change
        //start and end are the times in the current view (ex in week view,
        // the first day of the week and the last day of that week)
        $scope.eventsF = function(start, end, timezone, callback) {
          var events = [];

          //fetch events from the server
          //parse the events

          callback(events); // Return callback
        };

        $scope.eventSources.push($scope.eventsF);
      }
    ]);
})(angular);
