'use strict';

angular.module('cs.timelineLink', []).controller('CSTimelineController', function($scope, csUtils){
	
	if ($scope.parentData.node && $scope.parentData.node.type === 'Service'){
		$scope.timelineServiceId = $scope.parentData.node.service_id;
	}
	
	$scope.selectService = function(serviceInfo){
		$scope.timelineServiceId = serviceInfo.text;
		if ($scope.parentData.data.hideChildren){
			for (var i = 0; i < $scope.parentData.data.hideChildren.length; i++){
				if ($scope.parentData.data.hideChildren[i].service_id === $scope.timelineServiceId){
					csUtils.updateNode($scope.parentData.data.hideChildren[i], $scope.parentData);
					return;
				}
			}
		}
		if ($scope.parentData.data.children){
			for (var i = 0; i < $scope.parentData.data.children.length; i++){
				$scope.parentData.data.hideChildren[i].isSelected = false;
				if ($scope.parentData.data.children[i].service_id === $scope.timelineServiceId){
					csUtils.updateNode($scope.parentData.data.children[i], $scope.parentData);
					return;
				}
			}
		}
	}
})