'use strict';

angular.module('timelineFilter',[]).controller('filterCtrl', ['$scope', '$location',  'localizationService', 'journeyFilter',
	function($scope, $location, localizationService, journeyFilter) {
	
	$scope.dateFilter = journeyFilter.dateFilter;
	$scope.enabledFilter = journeyFilter.statusFilters;
	$scope.serviceTypeModel = journeyFilter.serviceTypeFilter;
	$scope.stateTypeModel = journeyFilter.stateTypeFilter;
	$scope.dateObj = {};
	$scope.dateObj.fromDate = journeyFilter.fromDate
	$scope.dateObj.toDate = journeyFilter.toDate
	$scope.dateObj.dateFilterType = journeyFilter.dateFilterType;
	$scope.serviceTypes = journeyFilter.existingServiceTypes ;
	$scope.stateTypes = journeyFilter.existingStateTypes ;
	$scope.search = journeyFilter.search; 

	$scope.quickFilterCategories = ['Show All', 'This Month', 'Last Month', 'Last 90 Days', 'This Year', 'Last Year', 'Custom Range']
	$scope.timelineCategories = ['Select All','Active','Completed'];
	$scope.filterByDateCategories = ['Starting', 'Ending', 'Starting and Ending', 'Starting or Ending']; 
	$scope.errorMsg = {};
		
	$scope.cancel = function(){
	   $scope.$close();
	 };

	$scope.addFilter = function(){		
		journeyFilter.dateFilter = $scope.dateFilter;
		journeyFilter.statusFilters = $scope.statusFilters ;
		journeyFilter.serviceTypeFilter = $scope.serviceTypeFilter;
		journeyFilter.stateTypeFilter = $scope.stateTypeFilter;
		journeyFilter.search = $scope.search
        
		journeyFilter.fromDate = $scope.dateObj.fromDate ;
        journeyFilter.toDate = 	$scope.dateObj.toDate ;
		journeyFilter.dateFilterType = $scope.dateObj.dateFilterType;
		
		
		
		journeyFilter.filterString = $scope.createFilterString();
		journeyFilter.updateTimeline()
		$scope.$close();
	};
	
	$scope.createFilterString = function () {
		// creates a string with filter information that shows up below the customerID. 
		var stringArray = [];
		var i = 0;
		
		// Append date filter if any. 
		if (journeyFilter.dateFilter === 'Custom Range' && (journeyFilter.toDate !== null || journeyFilter.fromDate !== null)){
			var dateString; 
	
			if (journeyFilter.fromDate !== null){
				var dateStartString = moment(journeyFilter.fromDate).format("DD.MM.YYYY");
			}
			
			if (journeyFilter.toDate !== null){
				var dateEndString = moment(journeyFilter.toDate).format("DD.MM.YYYY");
			}
			
			if (dateStartString && dateEndString)
				dateString = dateStartString + " - " + dateEndString;
			else if (dateStartString)
				dateString = dateStartString + " and after";
			else 
				dateString = "Up to " + dateEndString; 
			
			if (dateString){
				stringArray[i] = dateString
				i++;
			}
		}
		
		if (journeyFilter.dateFilter !== 'Show All' && journeyFilter.dateFilter !== 'Custom Range'){
			stringArray[i] = journeyFilter.dateFilterType + " " + journeyFilter.dateFilter;
			i++; 
		}
		
		if (journeyFilter.statusFilters[0] !== "Select All" && journeyFilter.statusFilters.length === 1){
			stringArray[i] = journeyFilter.statusFilters[0]
			i++
		}
		
		if (journeyFilter.serviceTypeFilter[0] !== "Select All" && journeyFilter.serviceTypeFilter.length > 0 ){
			var serviceString = ""; 
			for (var j = 0; j < journeyFilter.serviceTypeFilter.length; j++ ){
				
				if (j < 3)
					serviceString += journeyFilter.serviceTypeFilter[j];
				
				if (journeyFilter.serviceTypeFilter[j+1] !== undefined && j < 3)
					serviceString += ", "
						
				if (j === 3 && journeyFilter.serviceTypeFilter[j] !== undefined){
					serviceString += "and more "
						break;
				}
			}
			
			stringArray[i] = serviceString; 
			i++; 
		}
		
		
		if (journeyFilter.stateTypeFilter[0] !== "Select All" && journeyFilter.stateTypeFilter.length > 0 ){
			var stateString = ""; 
			for (var j = 0; j < journeyFilter.stateTypeFilter.length; j++ ){
				
				if (j < 3)
					stateString += journeyFilter.stateTypeFilter[j];
				
				if (journeyFilter.stateTypeFilter[j+1] !== undefined && j < 3)
					stateString += ", "
				if (j === 3 && journeyFilter.stateTypeFilter[j] !== undefined){
					stateString += "and more "
						break;
				}
			}
			
			stringArray[i] = stateString; 
			i++; 
		}
		
		if (journeyFilter.search !== undefined && journeyFilter.search.length > 0){
			stringArray[i] = "Containing '" + journeyFilter.search + "'";
			i++;
		}
		
		if (stringArray.length > 0 ) {
			var filterString = "";
			
			for (var i = 0; i < stringArray.length ; i++){
				filterString += stringArray[i];
				if (stringArray[i+1])
					filterString += "   |   "
			}
		}
		
		return filterString;
		
	};
	
	$scope.resetFilters = function() {
		journeyFilter.statusFilters = ['Select All'];
		journeyFilter.serviceTypeFilter = ['Select All'];
		journeyFilter.stateTypeFilter = ['Select All'];
		journeyFilter.search = "";
		
		journeyFilter.dateFilter = 'Show All';
		journeyFilter.dateFilterType = "Starting";

        journeyFilter.fromDate = null ;
        journeyFilter.toDate = null	;
        
		journeyFilter.updateTimeline()
		$scope.$close();
		
	};

    $scope.$watch('dateObj.fromDate', function () {
        if ($scope.dateObj.fromDate && $scope.dateObj.toDate && ($scope.dateObj.fromDate > $scope.dateObj.toDate)) {
          $scope.errorMsg.date = "Please select valid date durations" 
        }
        else {
            $scope.errorMsg.date = "";
        }
    }, true);

    
    $scope.$watch('dateObj.toDate', function () {
        if ($scope.dateObj.fromDate && $scope.dateObj.toDate && ($scope.dateObj.fromDate > $scope.dateObj.toDate)) {
          $scope.errorMsg.date = "Please select valid date durations" 
        }
        else {
            $scope.errorMsg.date = "";
        }
    }, true);
    
    $scope.$watch('dateFilter', function (newValue, oldValue) {
        if (newValue !== "Custom Range")
            $scope.errorMsg.date = "";
        else if ($scope.dateObj.fromDate && $scope.dateObj.toDate && ($scope.dateObj.fromDate > $scope.dateObj.toDate))
        	$scope.errorMsg.date = "Please select valid date durations" 
       
    }, true);
    
    $scope.$watch('enabledFilter', function(newValue, oldValue) {
    	// used to watch the filter select menu . If select all is clicked,
		// uncheck everything else.
    	
    	if (newValue.indexOf('Select All') !== -1 && newValue.length > 1) { // if 'Select All' is enabled

            if (oldValue.indexOf('Select All') !== -1) { 
            // if something was enabled after 'Select All' has been enabled
            
            	var index = newValue.indexOf('Select All');
              $scope.enabledFilter.splice(index, 1); // deselect 'Select All'
										
              $scope.statusFilters = $scope.enabledFilter;
            }
            else { // if 'Select All' is the most recent thing to be enabled
					
              $scope.enabledFilter = ['Select All']; // deselect everything else
															
              $scope.statusFilters = ['Select All']; // show everything

            }
          }
          if (newValue.indexOf('Select All') !== -1) { // length <= 1
            $scope.statusFilters = ['Select All']
          }
          else {
            $scope.statusFilters = $scope.enabledFilter;
          }
          
          if ($scope.statusFilters.length === 0){
            $scope.errorMsg.statusFilter = "Status filter cannot be blank"  
          }
          
          else {
                $scope.errorMsg.statusFilter = ""   
          }
          	          
        }, true);
    
    $scope.$watch('serviceTypeModel', function(newValue, oldValue) {
    	// used to watch the filter select menu . If select all is clicked,
		// uncheck everything else.
    	
    	if (newValue.indexOf('Select All') !== -1 && newValue.length > 1) { // if 'Select All' is enabled

            if (oldValue.indexOf('Select All') !== -1) { 
            // if something was enabled after 'Select All' has been enabled
            
            	var index = newValue.indexOf('Select All');
              $scope.serviceTypeModel.splice(index, 1); // deselect 'Select All'
			  $scope.serviceTypeFilter = $scope.serviceTypeModel				
            }
            else { // if 'Select All' is the most recent thing to be enabled
					
              $scope.serviceTypeModel = ['Select All']; // deselect everything else
															
              $scope.serviceTypeFilter = ['Select All']; // show everything

            }
          }
          if (newValue.indexOf('Select All') !== -1) { // length <= 1
            $scope.serviceTypeFilter = ['Select All'];
          }
          else {
            $scope.serviceTypeFilter = $scope.serviceTypeModel;
          }
          
          if ($scope.serviceTypeFilter.length === 0){
            $scope.errorMsg.serviceFilter = "Service type filter cannot be blank"  
          }
          
          else {
                $scope.errorMsg.serviceFilter = ""   
          }
          	          
        }, true);
    
    $scope.$watch('stateTypeModel', function(newValue, oldValue) {
    	// used to watch the filter select menu . If select all is clicked,
		// uncheck everything else.
    	
    	if (newValue.indexOf('Select All') !== -1 && newValue.length > 1) { // if 'Select All' is enabled

            if (oldValue.indexOf('Select All') !== -1) { 
            // if something was enabled after 'Select All' has been enabled
            
            	var index = newValue.indexOf('Select All');
              $scope.stateTypeModel.splice(index, 1); // deselect 'Select All'
			  $scope.stateTypeFilter = $scope.stateTypeModel				
            }
            else { // if 'Select All' is the most recent thing to be enabled
					
              $scope.stateTypeModel = ['Select All']; // deselect everything else
															
              $scope.stateTypeFilter = ['Select All']; // show everything

            }
          }
          if (newValue.indexOf('Select All') !== -1) { // length <= 1
            $scope.stateTypeFilter = ['Select All'];
          }
          else {
            $scope.stateTypeFilter = $scope.stateTypeModel;
          }
          
          if ($scope.stateTypeFilter.length === 0){
            $scope.errorMsg.stateFilter = "State type filter cannot be blank"  
          }
          
          else {
                $scope.errorMsg.stateFilter = ""   
          }
          	          
        }, true);
    
    $scope.errorsExist = function () {
    	for (var error in $scope.errorMsg) {
    		if ($scope.errorMsg[error] !== ""){
    			return true; 
    		}
    	}
    	
    };

	}
]);
