'use strict';

angular.module('devel-hub', ['wu.masonry', 'ark-components'])
	.controller('HubController', ['$scope', '$http', '$location', 'toaster', 'localizationService', 'preferencesService', 'loggerService', '$window',
		function($scope, $http, $location, toaster, localizationService, preferencesService, loggerService, $window) {

		localizationService.getLocaleJSON(function(locale){
			$scope.homeLocale = locale.HOMEVIEW;
			$scope.elementWidth = {
					'width': 0
				};
				$scope.roles = [];

				$scope.hideBrickInfo = [{
					'href': '../develop/index.html#/monitor',
					'img': './app/images/administration.png',
					'caption': $scope.homeLocale.ADMIN_UI
				}, {
					'href': '../develop/index.html#/callback',
					'img': './app/images/Callback.png',
					'caption': $scope.homeLocale.CALLBACKENGAGEMENT
				}, {
					'href': '../develop/index.html#/cs',
					'img': './app/images/service-status.png',
					'caption': $scope.homeLocale.CONTEXT_SERVICES
				}, {
					'href': '../develop/index.html#/journey-timeline',
					'img': './app/images/service-status.png',
					'caption': $scope.homeLocale.JOURNEY_TIMELINE
				}];

			$scope.addHttpRequestHistory = function(httpResponse, action){
				// angularjs now tries to automatically parse responses as json
				// don't log if the response has a type error for now
				if (httpResponse.config){
					// log to console
					loggerService.logHttpRequest(
											action,
											httpResponse.config.url,
											httpResponse.data,
											httpResponse.config.method,
											httpResponse.status + (httpResponse.statusText !== undefined ? ' (' + httpResponse.statusText + ')' : '' ),
											Date()
									);
				}
			};

			$http.get('/genesys/1/admin/me').then(function(res) {
				var data = res.data;
				$scope.addHttpRequestHistory(res, 'Get User');
				var roles = data.user.roles;
				$scope.roles = roles;
				$scope.brickInfo = [];

				if (roles.indexOf("ROLE_ADMINISTRATOR") != -1) {
					$scope.brickInfo.push($scope.hideBrickInfo[0])
					$scope.brickInfo.push($scope.hideBrickInfo[1]);
					//Make sure CS business attributes work before showing CS in Hub
					$http.get('../1/cs/metadata/business-attributes').then(function(httpResponse) {
						$scope.addHttpRequestHistory(httpResponse, 'Get Business Attributes');
						if (Object.keys(httpResponse.data).length != 0){
							$scope.brickInfo.push($scope.hideBrickInfo[2]);
							$http.get('../1/cs/metadata/profiles/extensions').then(function(httpResponse) {
								$scope.addHttpRequestHistory(httpResponse, 'Get Profile Extensions');
								$scope.brickInfo.push($scope.hideBrickInfo[3]);
							}, function(err){
								$scope.addHttpRequestHistory(err, 'Get Profile Extensions');
								$http.get('../1/cs/profiles/extensions').then(function(httpResponse) {
									$scope.addHttpRequestHistory(httpResponse, 'Get Fallback Profile Extensions');
									$scope.brickInfo.push($scope.hideBrickInfo[3]);
								}, function(err){
									$scope.addHttpRequestHistory(err, 'Get Fallback Profile Extensions');
								});
							});
						}
					}, function(err){
						$scope.addHttpRequestHistory(err, 'Get Business Attributes');
					});

					preferencesService.getFlag('enable-new-monitor', function(data){
						if (data === true){
						  $scope.hideBrickInfo[0]['href'] = '../develop/index.html#/monitor';
						}
				  	}, function(){});

				} else if (roles.indexOf("ROLE_SUPERVISOR") != -1) {

					//When role is Supervisor, only the Callback UI should be available.
				    $scope.hideBrickInfo[1]['href'] = '../develop/index.html#/callback';
					$scope.brickInfo.push($scope.hideBrickInfo[1]);

					$http.get('../1/cs/metadata/business-attributes').then(function(httpResponse) {
						$scope.addHttpRequestHistory(httpResponse, 'Get Business Attributes');
						if (Object.keys(httpResponse.data).length != 0){
							$http.get('../1/cs/metadata/profiles/extensions').then(function(httpResponse) {
								$scope.addHttpRequestHistory(httpResponse, 'Get Profile Extensions');
								$scope.brickInfo.push($scope.hideBrickInfo[3]);
							}, function(err){
								$scope.addHttpRequestHistory(err, 'Get Profile Extensions');
								$http.get('../1/cs/profiles/extensions').then(function(httpResponse) {
									$scope.addHttpRequestHistory(httpResponse, 'Get Fallback Profile Extensions');
									$scope.brickInfo.push($scope.hideBrickInfo[3]);
								}, function(err){
									$scope.addHttpRequestHistory(err, 'Get Fallback Profile Extensions');
								});
							});
						}
					}, function(err){
						$scope.addHttpRequestHistory(err, 'Get Business Attributes');
					});
				} else if (roles.indexOf("ROLE_MONITOR") != -1){
					$scope.hideBrickInfo[1]['href'] = '../develop/index.html#/callback';
					$scope.brickInfo.push($scope.hideBrickInfo[1]);
				}
				if (!$scope.brickInfo.length){
					console.log("Devel-Hub->User Redirected to Login due to No Roles (200 with Anonymous User)");
					$window.location.href = '../admin/login.jsp#/';
				}
			}, function(err) {
				console.log("Devel-Hub->User Redirected to Login due to Invalid Login(401)");
				$window.location.href = '../admin/login.jsp#/';
			});
		})}])
	.directive('hubWidth', function() {
		return {
			link: function(scope, ele) {
				scope.elementWidth.width += (ele.width() + 6);
				ele.on('$destroy', function() {
					scope.elementWidth.width -= (ele.width() + 6);
				});
			}
		}
	});
