angular.module('cs.services', [])
.factory('csApi', function($q, $http){
	var cs = function(){
		this.getBusinessAttributesRaw = function(url){
			return $http.get(url + '/metadata/business-attributes');		
		}

		this.queryCustomerProfiles = function(url, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			return $http.get(url + '/profiles', {'params' : jsonService});	
		}

		this.queryCustomerProfileById = function(url, id, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			return $http.get(url + '/profiles/' + id, {'params' : jsonService});	
		}

		this.getProfileExtensions = function(url){
			return $http.get(url + '/metadata/profiles/extensions');
		}

		this.getProfileExtensionsFallback = function(url){
			return $http.get(url + '/profiles/extensions');
		}

		this.getBusinessAttributes = function(url){
			return $http.get(url + '/metadata/business-attributes').then(function(response){

				var businessProperties = response.data;
				var mediaAttributes = {'service' : {}, 'state' : {}, 'task' : {}};
				var attributes = {'service' : {}, 'state' : {}, 'task' : {}, 'media' : mediaAttributes, 'property' : {}};

				var getObject = function(i, j){
					var object = {
						'name': businessProperties[i].values[j].name,
						'display_name': businessProperties[i].values[j].display_name
					};
					return object;
				};

				for (var i = 0; i < businessProperties.length; i++){
					if (businessProperties[i].cv_attributes.indexOf('Service.type') + 1){
						for (var j = 0; j < businessProperties[i].values.length; j++){
							if (businessProperties[i].map_name){
								attributes.service[businessProperties[i].values[j].name] = getObject(i, j);
							} else {
								attributes.service[businessProperties[i].values[j].dbid] = getObject(i, j);
							}
						}
					} else if (businessProperties[i].cv_attributes.indexOf('Task.type') + 1){
						for (var j = 0; j < businessProperties[i].values.length; j++){
							if (businessProperties[i].map_name){
								attributes.task[businessProperties[i].values[j].name] = getObject(i, j);
							} else {
								attributes.task[businessProperties[i].values[j].dbid] = getObject(i, j);
							}
						}
					} else if (businessProperties[i].cv_attributes.indexOf('State.type') + 1){
						for (var j = 0; j < businessProperties[i].values.length; j++){
							if (businessProperties[i].map_name){
								attributes.state[businessProperties[i].values[j].name] = getObject(i, j);
							} else {
								attributes.state[businessProperties[i].values[j].dbid] = getObject(i, j);
							}
						}
					} else {
						for (var j = 0; j < businessProperties[i].cv_attributes.length; j++){
							attributes.property[businessProperties[i].cv_attributes[j]] = {};
							for (var k = 0; k < businessProperties[i].values.length; k++){
								if (businessProperties[i].map_name){
									attributes.property[businessProperties[i].cv_attributes[j]]
										[businessProperties[i].values[k].name] = getObject(i, k);
								} else {
									attributes.property[businessProperties[i].cv_attributes[j]]
										[businessProperties[i].values[k].dbid] = getObject(i, k);
								}
							}
						}
					}
					if (businessProperties[i].cv_attributes.indexOf('Service.media_type') + 1){
						for (var j = 0; j < businessProperties[i].values.length; j++){
							if (businessProperties[i].map_name){
								attributes.media['service'][businessProperties[i].values[j].name] = getObject(i, j);
							} else {
								attributes.media['service'][businessProperties[i].values[j].dbid] = getObject(i, j);
							}
						}
					}
					if (businessProperties[i].cv_attributes.indexOf('Task.media_type') + 1){
						for (var j = 0; j < businessProperties[i].values.length; j++){
							if (businessProperties[i].map_name){
								attributes.media['task'][businessProperties[i].values[j].name] = getObject(i, j);
							} else {
								attributes.media['task'][businessProperties[i].values[j].dbid] = getObject(i, j);
							}
						}
					}
					if (businessProperties[i].cv_attributes.indexOf('State.media_type') + 1){
						for (var j = 0; j < businessProperties[i].values.length; j++){
							if (businessProperties[i].map_name){
								attributes.media['state'][businessProperties[i].values[j].name] = getObject(i, j);
							} else {
								attributes.media['state'][businessProperties[i].values[j].dbid] = getObject(i, j);
							}
						}
					}
				}
				return attributes;
			});
		}

		this.queryCustomerServices = function(url, customerId, isAnon, jsonService){
			
			if(jsonService==null){
				jsonService={};
			}
			if(jsonService.hasOwnProperty('active_tasks')===false){
				jsonService.active_tasks= false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_tasks')===false){
				jsonService.completed_tasks= false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('active_states')===false){
				jsonService.active_states= false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_states')===false){
				jsonService.completed_states= false;//if user did not specify a value set it to false
			}
			if (isAnon){
				return $http.get(url + '/services/anonymous/' + customerId, {'params' : jsonService});
			}
			return $http.get(url + '/customers/' + customerId + '/services', {'params' : jsonService});
		}

		this.queryServiceById = function(url, serviceId, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			if(jsonService.hasOwnProperty('active_tasks') === false){
				jsonService.active_tasks = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_tasks') === false){
				jsonService.completed_tasks = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('active_states') === false){
				jsonService.active_states = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_states') === false){
				jsonService.completed_states = false;//if user did not specify a value set it to false
			}
			if(jsonService['active_tasks'] == false && jsonService['active_tasks'] == jsonService['completed_tasks']){
				jsonService['active_tasks'] = true;
				jsonService['completed_tasks'] = true;
			}
			if(jsonService['active_states'] == false && jsonService['active_states'] == jsonService['completed_states']){
				jsonService['active_states'] = true;
				jsonService['completed_states'] = true;
			}
			return $http.get(url + '/services/' + serviceId, {'params' : jsonService});
		}
		
		this.queryStates = function(url, serviceId, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			if(jsonService.hasOwnProperty('active_tasks') === false){
				jsonService.active_tasks = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_tasks') === false){
				jsonService.completed_tasks = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('active_states') === false){
				jsonService.active_states = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_states') === false){
				jsonService.completed_states = false;//if user did not specify a value set it to false
			}
			if(jsonService['active_tasks'] == false && jsonService['active_tasks'] == jsonService['completed_tasks']){
				jsonService['active_tasks'] = true;
				jsonService['completed_tasks'] = true;
			}
			if(jsonService['active_states'] == false && jsonService['active_states'] == jsonService['completed_states']){
				jsonService['active_states'] = true;
				jsonService['completed_states'] = true;
			}
			return $http.get(url + '/services/' + serviceId + '/states', {'params' : jsonService});
		}

		this.queryStateById = function(url, serviceId, stateId, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			if(jsonService.hasOwnProperty('active_tasks') === false){
				jsonService.active_tasks = false;//if user did not specify a value set it to false
			}
			if(jsonService.hasOwnProperty('completed_tasks') === false){
				jsonService.completed_tasks = false;//if user did not specify a value set it to false
			}
			if(jsonService.active_tasks == jsonService.completed_tasks){
					jsonService.active_tasks=true;
					jsonService.completed_tasks=true;
			}
			return $http.get(url + '/services/' + serviceId + '/states/' + stateId, {'params' : jsonService});
		}

		this.queryTaskById = function(url, serviceId, taskId, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			return $http.get(url + '/services/' + serviceId + '/tasks/' + taskId, {'params' : jsonService});
		}

		this.startService = function(url, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			return $http.post(url + '/services/start', jsonService);
		}

		this.startCustomerService = function(url, customer_id, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			jsonService['customer_id'] = customer_id;
			return this.startService(url, jsonService);
		}

		this.startAnonymousService = function(url, contact_key, jsonService){
			if(jsonService==null){
				jsonService={};
			}
			jsonService['contact_key'] = contact_key;
			return this.startService(url, jsonService);

		}

		this.startState = function (url, service_id, jsonService){
			if(jsonService==null){
				jsonService={};
			}
            //starts a new state given service id and the state type
            return $http.post(url + "/services/" + service_id + "/states/start", jsonService);
        }

        this.startTask = function (url, service_id, jsonService){
        	if(jsonService==null){
				jsonService={};
			}
            return $http.post(url + '/services/' + service_id + '/tasks/start', jsonService);
        }

        this.completeService = function(url, service_id, jsonService) {
        	if(!jsonService){
            	jsonService={};
            }
            return $http.post(url + "/services/" + service_id + "/end", jsonService);
        }

        this.completeState = function(url, service_id, state_id, jsonService) {
        	if(!jsonService){
            	jsonService={};
            }
            return $http.post(url + "/services/" + service_id + "/states/" + state_id + "/end", jsonService);
        }

        this.completeTask = function(url, service_id, task_id, jsonService) {
        	if(!jsonService){
            	jsonService={};
            }
            return $http.post(url + "/services/" + service_id + "/tasks/" + task_id + "/end", jsonService);
        }


		this.deleteService = function(url, serviceId){
			return $http({url: url + '/services/' + serviceId,
				dataType: "json",
			    method: "DELETE",
			    headers: {
			        "Content-Type": "application/json"
			    },
			    data: ''
			});
		}
	}
	return new cs();
});
