/*
    The application uses the requirejs i18n plugin. Follow the following steps to support a new language:

    This is the default folder containing the localization strings used
    throughout the application. In order to support other languages,
    1. Create a new folder and name it according to the language it is for (eg. fr-fr).
    2. In the new folder, create a locale.js file and in it, call the define() function
       passing as a parameter, an object containing all the localization strings
       as found in the root object of this default file.
    3. create a boolean value for new language and set it to true in this file. (refer to the bottom of this file)

    YOU CAN USE THE DEBUG FOLDER AS A STARTING POINT FOR AN EXAMPLE.
 */
define({
  "root": {
    SYSTEM: "ROGER",
    Common: {
      REMOVE: "Remove",
      DUPLICATE: "Duplicate",
      CANCEL: "Cancel",
      CONTINUE: "Continue",
      SETKEY: "Click here to set the key",
      SETVALUE: "Click here to set the value",
      AREYOUSURE: "Are you sure?",
      KEY: "Name",
      VALUE: "Value",
      MAKESELECTION: "Please make your selection...",
      HELP: "Help",
      CLOSE: "Close",
      MINUTES: "Minutes",
      RELOAD: "Reload",
      OKAY:"OK",
      WARNING: "Warning",
      SAVE: "Save",
      NEW: "New",
      DELETE: "Delete",
      ERROR: "Error",
      BACK: "Back",
      CLEAR: "Clear",
      TODAY: "Today",
      LOADING: "Loading...",
      GMS: "Genesys Mobile Services",
      GES:"Genesys Engagement Services",
      INVALID_INPUT: "Invalid Input",
      AUTHENTICATION_ERROR_RELOAD: "Your session has expired. Please, reload the window.",
      PENDING_REQUEST: "Changes that you made may not be saved",
      PREVIOUS: "Previous",
      NEXT: "Next",
      ADD: "Add",
      APP_NAME_GMS: "Context Services",
      APP_NAME_GES: "GES Management UI",
      APP_NAME_GSG_Admin : "GSG Admin",
      APP_NAME_GES_Admin : "GES Admin",
    },

    AccountView: {
      WELCOME: "Welcome",
      LANGUAGE: "Language",
      LOGOUT: "Log Out",
      CLOSE: "Close",
      HOME: "Home",
      LOGOUTMESSAGE: "Please close your browser to log out.",
      ENGLISH: "English",
      FRENCH: "French",
      RUSSIAN: "Russian"
    },

    // System monitors the Cassandra nodes on which GMS resides. The following strings are Cassandra related keywords.
    System: {
      SYSTEM: "System",
      IP: "IP",
      TOKEN: "Token",
      STATUS: "Status",
      LOAD: "Load",
      DATACENTER: "Data Center",
      URL: "URL",
      STATUSALIVE: "Status Alive",
      EXTERNALCONFIGURATION: "External Cassandra Configuration",
      RACK: "Rack",
      OWN: "Own",
      RUNNINGTIME: "Running Since",
      TIMESTAMPLABEL: "Last Updated",
      NODEERROR: "Failed to retrieve the nodes."
    },

    // Reporting contains all the strings used for the GMS reporting section (i.e for the charts, its options, its error messages, etc.).
    Reporting: {
      REPORTING: "Reporting",
      REPORTTYPE: "Report Type",
      ALLOCATED: "Allocated",
      RELEASED: "Released",
      RELEASEFAILED: "Release-Failed",
      ALLOCATIONTIME: "Allocation Time",
      RESOURCETOTAL: "Resource Total",
      RESOURCEAVAILABLE: "Resource Available",
      RESOURCEAVAILABILITY: "Resource Availability",
      ADDITIONALOPTIONS: "Additional Report Options",
      RESOURCES: "Resources", //GMS Resources
      SERVICES: "Services",   //GMS Services
      CALLBACK: "Callback",   //Callback service used to to call back a customer
      REPORTNAME: "Report Parameters",
      MEDIATYPE: "Media Type",
      METRICTYPE: "Metric Type",
      HOLDTIME: "Holdtime", //Holdtime is a counter within the callback service
      WATERMARK: "Watermark", //Watermark is a counter within the callback service
      NOOPTIONS: "No Options",
      GROUPDATABY: "Group data by",
      MINUTES: "minutes",
      ANHOUR: "An hour",
      ADAY: "A day",
      REPORTRANGE: "Report Range",
      TODAY: "Today",
      YESTERDAY: "Yesterday",
      LASTWEEK: "Last Week",
      WEEKTODATE: "Week To Date",
      LASTMONTH: "Last Month",
      MONTHTODATE: "Month To Date",
      SPECIFYDATERANGE: "Specify Date Range",
      FROM: "From",
      AM: "AM",
      TO: "To",
      PM: "PM",
      DOWNLOAD: "Download",
      REFRESH: "Refresh",
      NODATA: "No Data available for the selected time period.",
      CALLBACKTYPE:"Callback Type",
      ALL: "All",
      IMMEDIATE: "Immediate",
      SCHEDULED: "Scheduled",
      MINMAXSECTION:"MIN/MAX Wait Time",
      FETCHINGDATA: "Fetching Data...",
      TOTAL: "Total",
      TOTALACCEPTED: "Total Accepted",
      TOTALREJECTED: "Total Rejected",

      //Wait time for different types of queues
      PQWAITTIME:"Persistent Queue Wait Time",
      DQWAITTIME:"Distribution Queue Wait Time",

      TARGET: "Target",
      AGENTGROUP: "Agent Group",
      AGENT: "Agent",
      AGGREGATESWARNING: "WARNING: No Data is Available",
      MEDIAWARNING: "WARNING: No Media Types Were Found",
      SERVICESWARNING: "WARNING: No Services Were Found",
      RESOURCESWARNING: "WARNING: No Resources Were Found",
      ZERODATA: "NOTE: Every data point in the graph has a value of 0",
      MIN: "MIN",
      MAX: "MAX",
      SUM: "SUM",
      AVG: "AVG",
      DISPLAY_METRICS: "Display Advanced Metrics",
      CSV: "CSV",
      PDF: "PDF",
      EXCEL: "EXCEL",
      URL: "URL",
      PARAMETERS: "Parameters",
    },

    Error: {
      KEY: "Please Enter a Key!",
      EMPTY_FORM: "Fill out the form!",
      COMPLETEALL: "You must complete all required fields",
      UNIQUENAME: "You must pick a unique name",
      ILLEGAL: "You must not include illegal characters",
      LENGTH: "The input specified exceeds the maximum number of characters allowed",
      AUTHENTICATION: "Authentication failed",
      INVALID: "Invalid or missing value: The specified information is not within the allowable range.",
    },

     LoginView: {
       LOGIN: "LOGIN",
       USERNAME: "Username",
       PASSWORD: "Password",
       INCORRECT: "Your login or password is incorrect.",
       LOGINLOWERCASE: "Log In",
     },

    // View that contains all the items in the navigation menu.
    NavigationView: {
      HOME: "HOME",
      SYSTEM: "SYSTEM",
      PROVISIONING: "PROVISIONING",
      REPORTING: "REPORTING",
      SERVICES: "SERVICES",
      SWAGGER: "SWAGGER", //Alias for SwaggerJS
      TOOLS:"TOOLS",
      LAB:"LAB",
      RESOURCES: "Resources",
      MONITOR: "Monitor",
      CONFIGURED_SERVICES :"Configured Services",
      SERVICE_TEMPLATES : "Service Templates",
      CALENDAR: "Manage Calendars",
      PATTERNS: "Patterns", //GMS Patterns
      STATISTICS: "Statistics",
      SAMPLE: "Sample",
      API_SHOWCASE:"API",
      CALLBACK_TITLE: "CALLBACK",
      CALLBACK: "Callback Management",
      STATISTICSV2: "Statistics V2",
      MONITOR: "MONITOR",
      DATADEPOTCENTER: "DataDepot Center",
      DOWNLOAD_DFM: "Download Dfm", //Download DFM files
      CONFIG: "Config",
      CONTEXTSERVICES: "Context Services",
      LOGVIEWER: "LogViewer",
    },

    Provisioning: {
      SERVICES: "SERVICES",
      MOBILESERVICE: "MOBILE SERVICE",
      RESOURCES: "RESOURCES",
      PATTERNS: "PATTERNS",
      SERVICETEMPLATES: "SERVICE TEMPLATES",
      STATISTICS: "STATISTICS",
      QUEUEMANAGEMENT: "QUEUE MANAGEMENT"
    },

    MobileService: {
      SESSIONID: "Session ID",
      SERVICENAME: "Service Name",
      STARTTIME: "Start Time",
      ENDTIME: "End Time",
      DURATION: "Duration",
      RESULT: "Result",
      SESSION: "Session",
      SERVICE: "Service",
      MINUTE: "minute",
      MINUTES: "minutes",
      SUCCESS: "Success",
      FAIL: "Fail",
      OTHERS: "Others"
    },

    //Prompt for adding a new GMS Service
    NewService: {
      ADDNEWSERVICE: "Add New Service",
      NEWSERVICENAME: "New Service Name",
      SERVICENAME: "Service Name",
      MUSTFILL: "Please complete the entire form",
      RIGHTOPTION: "Please choose an option",
      UNIQUENAME: "Please pick a unique name",
      DEFAULTCONFIG: "Please choose a common default configuration option",
      ILLEGALCHARS: "Some of the characters are not allowed within a service name",
      CONFIGURESERVICE: "Configure Service",
      SELECTOPTION: "Select an Option...",
      SAVE: "Save",
      PROFILES: "Common Default Configurations",
      NAMEEXCEEDSLENGTH: "Please enter a service name that does not exceed 56 characters", 
    },



    //Prompt for removing a GMS Service Setting
    RemoveSetting: {
        REMOVESETTING: "Remove Setting",
        AREYOUSURE: "Are you sure?",
        REMOVE: "Remove",
        CANCEL: "Cancel",
     },

     //Prompt for removing a GMS Service
    RemoveService: {
      REMOVESERVICE: "Remove Service",
      AREYOUSURE: "Are you sure?",
      REMOVE: "Remove",
      CANCEL: "Cancel",
    },

    //Container that contains all of the GMS Services
    ServicesView: {
      CONFIGURE: "Configured Services",
      ADDSERVICE: "Add Service",
      NOSERVICES: "The selected Service Template has no configured services.",
      SHOWADVANCED: "Advanced Parameters",
      EXPANDALL: "Expand All",
      COLLAPSEALL: "Collapse All",
      ALLSERVICETEMPLATES: "All Service Templates",
      SERVICESPERPAGE: "Services Per Page",
      NEXT: "Next",
      PREVIOUS: "Prev",
      COMMUNICATIONPROBLEM: "Communication problem has occurred. Please refresh your browser to retry.",
      ERRORMESSAGE: "An error has occurred. Please try refreshing the browser.",
      RESOURCESERROR: "Resources Error",
      AUTHENTICATIONERROR: "Please log in to add a new service",
    },

    //Container for a GMS Service
    ServiceView: {
      REMOVE: "Remove Service",
      NAME: "Name",
      VALUE: "Value",
      DESCRIPTION: "Description",
      ADD: "Add Setting",
      SETKEY: "click to set the key",
      SETVALUE: "click to set the value",
      INVALID_OR_MISSING_VALUE: "Invalid or missing value: The specified information exceeds the allowable range.",
      UNIQUENESS_VIOLATION: "Uniqueness Violation: Please wait at least one second inbetween duplicating settings",
    },

    //Container for GMS Service Setting
    SettingView: {
      MONDAY: "Monday",
      TUESDAY: "Tuesday",
      WEDNESDAY: "Wednesday",
      THURSDAY: "Thursday",
      FRIDAY: "Friday",
      SATURDAY: "Saturday",
      SUNDAY: "Sunday",
      SETTINGINFOTOOLTIP: "This is a request parameter. Setting it here will override this parameter provided in the request.",
      REQUIREDPARAMETER: "This parameter is required and its name cannot be changed.",
      VALUECANNOTCHANGE: "This value cannot be changed.",
      NOTSPECIFIED: "Not Specified",
      SELECTOPTION:"Please select one option",
      SETVALUEDATE:"Click here to set the date",
      SETVALUEDAY: "click here to set the start day",
      LENGTHEXCEEDED: "The specified value exceeds the maximum length of 64 characters",
    },

    //Prompt for adding a new GMS Pattern
    NewPatternGroupDialog: {
      ADD: "Add New Pattern Group",
      COMPLETE: "You must complete all required fields",
      UNIQUENAME: "You must pick a unique name",
      ILLEGAL: "You must not include illegal characters",
      UNIQUEPATTERN: "Provide a unique Pattern group name:",
      CONTINUE: "Continue",
      NEWPATTERNGROUPNAME: "New Pattern Group Name",
      ADD_LABEL: "Add",
      CANCEL_LABEL: "Cancel",
    },

    //View that keeps track of GMS Statistics
    StatisticsView: {
      STATISTICS: "Statistics",
      STATISTIC: "Statistic",
      VALUE: "Value",
      SELECTION: "Please make your selection...",
      METRIC: "Metric",
      OBJECTTYPE: "Object Type",
      NOSTATSMESSAGE: "The selected Metric and Object Type contains no statistics.",
      REFRESH_EVERY: "Refresh every(secs)",
      ZOOMINONTABLE: "Zoom In on Tables",
      PLEASE_SELECT_STATISTIC: "Please Select a Statistic to Display",
      DROP_STATISTIC: "Drop Statistic to Focus",
      TOGGLE_CONFIGURE_WATCHED_STATISTICS: "Toggle to configure watched statistics",
      AGENT: "Agent",
      ROUTEPOINT: "RoutePoint",
      ADDMETRIC: "Add Metric",
      ADDSTATISTIC: "Add Statistic",
      CLEAR: "Clear",
      LOAD_PREFERENCES: "Load Preferences",
      //Thresholds are MAX/MIN limits for any GMS statistic
      SET_THRESHOLD: "Set Threshold Values",
      HIGH_THRESHOLD: "High Threshold",
      LOW_THRESHOLD: "Low Threshold",
      FIRST: "1st",
      SECOND: "2nd",
      NOT_INTEGER_ERROR: "Invalid Input: Please enter an integer for the selected field/s",
      THRESHOLD_ERROR: "Invalid Input: Please set a higher threshold",
      EMPTY_ERROR: "ERROR: Statistics are empty.",
   },

   //View to upload a new Service Template into GMS
    ServiceTemplatesView: {
      SERVICETEMPLATES: "Service Templates",
      ADD: "Add Service Template",
      NOTEMPLATE: "There are no Service Templates uploaded into the system. To add a new Service Template, upload a template ZIP file, using \"Add Service Template\" button.",
      TEMPLATEUPLOAD: "ERROR: There was a problem uploading XXX.zip template.",
      ZIPFILE: "Please Select a ZIP File!",
    },

    ServiceTemplateView: {
      NAME: "Name",
      DEFAULT: "Default Value",
      DESCRIPTION: "Description",
      REMOVETEMPLATE: "Remove Service Template",
    },

    ReloadServiceTemplate: {
      RELOADSERVICETEMPLATE: "A template with this name is already uploaded into the system.",
      AREYOUSURE: "Do you wish to reload it?"
    },

    RemovePatternGroup: {
      REMOVEPATTERN: "Remove Pattern Group",
      AREYOUSURE: "Are you sure?",
    },

    NewResourceGroup: {
      ADDGROUP: "Add New Resources Group",
      NEWNAME: "Provide a unique Resource group name:",
      NEWGROUPNAME: "New Resource Group Name",
    },

    RemoveResourceGroup: {
      REMOVEGROUP: "Remove Resource Group",
    },

    ResourcesView: {
      RESOURCES: "Resources",
      NEWGROUP: "New Resource Group",
      ADDRESOURCE: "Add Resource",
      REMOVEGROUP: "Delete Resource Group",
      NORESOURCESSELECTED: "No Resource Group is selected. Please select a Resource Group on the left.",
      NORESOURCESDEFINED: "No Resource Groups are defined.",
      REFRESH: "Refresh Metrics",
      AVAILABLE_RESOURCES: "Available Resources:",
      TOTAL_RESOURCES: "Total Resources:",
      ADD_NEW_RESOURCE_GROUP: "Add New Resource Group",
      NEW_GROUP_NAME: "Resource Group Name",
      ADD_LABEL: "Add",
      DELETE_LABEL: "Delete",
      CANCEL_LABEL: "Cancel",
      CONFIRM_LABEL: "Confirm",
      SEARCH_PLACEHOLDER: "Search Items",
      NEW_GROUP_PLACEHOLDER: "New Resource Group Name",
      RESOURCE_GROUPS: "Resource Groups",
      
      //delete group modal 
      REMOVE_GROUP: "Delete Resource Group",
      //delete 
      DELETE_RESOURCE: "Delete Resource",
      REMOVE_CONFIRMATION: "Are you sure you want to remove",
      DELETE_SUCCESS: "Delete Successful",
      ROW_NOT_SELECTED_FOR_DELETE: "Row not selected for deletion.",

      //page
      NAME_LABEL: "Name",
      VALUE_LABEL: "Value",
      REFRESH_BUTTON: "Refresh",
      ADD_NEW_BUTTON: "Add New",
      DELETE_BUTTON: "Delete",
      TABLE_SEARCH_PLACEHOLDER: "Search Table",
      NO_RESOURCE_GROUPS: "No resource groups are defined",
      CLICK_TO_SET_KEY: "Click here to set the key",
      CLICK_TO_SET_VALUE: "Click here to set the value",

      //toasts
      ERROR: "Error",
      AUTHENTICATION_ERROR_RELOAD: "Authentication Error",
      KEY_EMPTY: "Name field cannot be left empty",
      KEY_ALREADY_EXISTS: "This key already exists",
      FETCHING_ERROR: "Error fetching resource groups",

      SUCCESS: "Success",
      //sidebar messages/errors
      NEW_NAME: "Please enter a new resource group name",
      TOO_LONG: "Resource group name is too long",
      NOT_UNIQUE: "Resource group name must be unique",
      ILLEGAL_CHARS: "You must not include any illegal characters",
      CREATED: "Created resource group",
      FAILED_CREATE: "Failed to create resource group",
    },
    ICalenderView:{
      NOEVENTS: "There are no events in this period",
      SPECIFIC_EVENTS_AFTER: "events:",
      NEXT: "next",
      PREV: "prev",
      NEXTEVENTS: "Next events:",
      GO_TO_EVENT_URL: "See the event",
      //values for the template
      TITLE: "Title",
      DESCRIPTION: "Description",
      DATE: "Date",
      STARTTIME:"Start Time",
      ADDEVENT:"Add Event",
      CALENDARS:"Calendars",
      NOFILE: "please select a file",
      },

    PatternGroupView: {
      PATTERNS: "Patterns",
      NEWGROUP: "New Pattern Group",
      REMOVEGROUP: "Remove Pattern Group",
      ADDPATTERN: "Add Pattern",
      TEST: "Test Pattern Value",
      NOPATTERNSSELECTED: "No Pattern Group is selected. Please select a Pattern Group on the left.",
      NOPATTERNSDEFINED: "No Pattern Groups are defined.",
      CLOSE: "Close",
      ADD_NEW: "Add New",
      DELETE: "Delete",
      REFRESH: "Refresh",
      NAME: "Name",
      VALUE: "Value",
      CONFIRM: "Confirm",
      DELETE_PATTERN: "Delete Pattern Group",
      REMOVE_CONFIRMATION: "Are you sure you want to remove",

      //toasts
      REFRESHED: "Refreshed",
      INVALID_FIRST_CHAR: "Value cannot begin with ",
      FETCHING_ERROR: "Error Fetching Patterns",
      KEY_EMPTY: "Name field cannot be left empty",
      KEY_ALREADY_EXISTS: "This key already exists",
      AUTHENTICATION_ERROR_RELOAD: "Authentication Error",
      DELETE_SUCCESS: "Delete Successful",
      SUCCESS: "Success",
      CANNOT_DELETE_PARAMETER: "Cannot delete required parameter.",
      ROW_NOT_SELECTED_FOR_DELETE: "Row not selected for deletion.",
      //Help
      HELP: "Help",
      REGULAREXPRESSIONTITLE: "A regular expression",
      REGULAREXPRESSIONDEF: " defines a search pattern for strings. Regular expressions can be used to search, edit and manipulate text.",
      REGULAREXPRESSION: "Regular Expression",
      DESCRIPTION: "Description",
      MATCH: "Matches any character",
      BEGIN: "Regex must match at the beginning of the line",
      END: "Regex must match at the end of the line",
      OR: "Set definition, can match the letter a or b or c",
      ORFOLLOW: "Set definition, can match a or b or c followed by either v or z",
      BEGINEXCEPT: "When a \"^\" appears as the first character inside [] then it negates the pattern. This can match any character except a or b or c",
      RANGE: "Ranges, letter between a and d and figures from 1 to 7, will not match d1",
      XORZ: "Finds X or Z",
      TELEPHONE: "Telephone Number in the format of (XXX)XXX-XXXX",
      EMAIL: "Simple Email Format: X@X.X where X can be any number or letters",
      POSTAL: "Canada postal code: A0A 0A0",
      DETAIL: "For more details please refer to ",
      ORACLE: "Java Regular Expression Lesson by Oracle",
      URL: "URL",
      POST: "Post",

      SEARCH_PLACEHOLDER: "Search Items",
      TEST_PATTERN: "Test Pattern Value",
      SEARCH_TABLE: "Search Table",
      //sidebar messages/errors
      NEW_NAME: "Please enter a new pattern group name",
      TOO_LONG: "Pattern group name is too long",
      NOT_UNIQUE: "Pattern group name must be unique",
      ILLEGAL_CHARS: "You must not include any illegal characters",
      CREATED: "Created pattern group",
      FAILED_CREATE: "Failed to create pattern group",
    },
  
  DownloadDfmTemplate: {
        FILENAME: "File Name:",
        DOWNLOADLINK: "Download Link:",
        CALLBACK: "Callback.jsp",
        NOTIFICATION: "Notification.jsp",
        SERVICES: "Services.jsp",
        STORAGE: "Storage.jsp",
    STATISTIC: "Statistic.jsp",
        DOWNLOADCALLBACK: "Download Callback.jsp",
        DOWNLOADNOTIFICATION: "Download Notification.jsp",
        DOWNLOADSERVICES: "Download Services.jsp",
        DOWNLOADSTORAGE: "Download Storage.jsp",
    DOWNLOADSTATISTIC: "Download Statistic.jsp"
    },

    TemplateChangeDialog: {
      CHANGESERVICETEMPLATETITLE: "Change Service Template",
      CHANGETEMPLATEHEADER: "Some parameters might lose their template constraints.",
      CHANGETEMPLATEBODY: "Do you still want to change the service template?",
      CANCEL: "Cancel",
      CHANGE: "Change",
    },

    RemoveNodeDialog: {
      REMOVENODETITLE: "Remove Node",
      REMOVENODEBODY: "This operation will remove the selected node from the ring, do you wish to proceed?",
      REMOVE: "Remove",
      CANCEL: "Cancel",
    },

    ModelManagement: {
      MODELMANAGER: "MODEL MANAGER",
      TENANTID: "Tenant ID",
      MODELNAME: "Model Name",
      SEARCH: "Search",
      UPLOAD: "Upload",
      DELETE: "Delete",
      BROWSE: "Browse",
      CANCEL: "Cancel",
      BACK: "Back",
      UPDATE_MODEL: "Update Model",
      ERROR_MODEL_NOT_FOUND: "Error: Model not found!",
      ERROR_UPLOAD_MODEL: "Error: Model upload failed!",
      ERROR_DELETE_MODEL: "Error: Model delete failed!",
      ERROR_EMPTY_FIELD: "Error: The fields must not be empty!",
      ERROR_EMPTY_MODEL: "Error: The model can not be empty!",
      ERROR_INVALID_TENANTID: "Error: You entered an invalid tenant ID!",
      ERROR_INVALID_MODELNAME: "Error: You entered an invalid model name!",
      SUCCESS_MODEL_UPDATE: "The model has been updated.",
      SUCCESS_MODEL_UPLOAD: "The model has been uploaded.",
      SUCCESS_MODEL_DELETE: "The model has been deleted.",
      BASIC_EDIT: "Basic Edit",
      ADVANCED_EDIT: "Advanced Edit",
      DISCARD_CHANGES: "Discard Changes",
      AGGREGATES: "AGGREGATES",
      ACTIVITYNAME: "Activity Name",
      GROUPBY: "GroupBy",
      SETPROPERTIESFILTERS: "Please set the properties' filters",
      RUNQUERY: "Run Query",
      AGGREGATEGROUPS: "AGGREGATE GROUPS",
      COMBINED_LOOKUPS: "COMBINED LOOKUPS",

    },

    DataDepotCenter: {
      MODEL_MANAGEMENT: "Model Management",
      MODEL_BUILDER: "Model Builder",
      RUN_QUERY: "Run Query",
      ERROR_MODEL_NOT_FOUND: "No models were found!",
      ERROR_EMPTY_FIELD: "Error: The fields must not be empty!",
      ERROR_INVALID_TENANTID: "Error: You entered an invalid tenant ID!",
      ERROR_INVALID_MODELNAME: "Error: You entered an invalid model name!",
      FINISH_EDITING: "Finish Editing",
      HOME: "Home",
      DATA_DEPOT_CENTER: "Data Depot Center",
      WORK_WITH_NEW_OR_EXSISTING_MODEL: "Would you like to work with a new model or an existing model?",
      NEW: "New",
      EXISTING: "Existing",
      BUILD_OR_UPLOAD_MODEL: "Would you like to build or upload a model?",
      BUILD: "Build",
      UPLOAD: "Upload",
      MODELNAME: "Model Name",
      TENANTID: "Tenanat ID",
      FILTER: "Filter",
      CLEAR: "Clear"
    },

    RunQuery: {
      TENANTID: "Tenant ID",
      MODELNAME: "Model Name",
      SEARCH: "Search",
      ERROR_QUERY_FAILED: "No results were found!",
      ERROR_EMPTY_FIELD: "Error: Please fill out all the required fields!",
      ERROR_INVALID_MAX_EVENTS: "Error: max-events must be an integer! " +
              "The default value 10 would be used if you leave it empty.",
      uRUNQUERY: "RUN QUERY",
      PROPERTIES: "Properties",
      lAGGREGATES: "Aggregates",
      REQUEST_PARAMETERS: "REQUEST PARAMETERS",
      FEILDS_WITH: "Fields with",
      ARE_MANDATORY:"are mandatory except for primary key query",
      START_TIME: "start-time",
      END_TIME: "end-time",
      TRUE: "True",
      FALSE: "False",
      RETURN_EVENTS: "return-events",
      MAX_EVENTS: "max-events",
      ROLLUP_PERIOD: "rollup-period",
      QUARTER_HOUR: "QUARTER-HOUR",
      HALF_HOUR: "HALF_HOUR",
      HOUR: "HOUR",
      DAY: "DAY",
      WEEK: "WEEK",
      MONTH:"MONTH",
      QUARTER_YEAR:"QUARTER-YEAR",
      YEAR:"YEAR",
      TIME_ZONE: "time-zone",
      QUERY_UNIQUE_VALUES: "Query Unique Values",
      QUERY_RESULTS: "QUERY RESULTS",
      URL_NA: "Url: N/A"
    },
    ContextServices:{
      TASKS:"Tasks",
      TASK:"Task",
      TASKID:"Task_ID",
      STATES:"States",
      STATE:"State",
      NAME:"Name",
      VALUE:"Value",
      COMPLETE:"Complete"
    },

    KPIInfo: {
      NO_INFO: "Info not available ",
      ONLY_ACTIVE_JOURNEYS: "Cannot calculate, only active Journeys exist.",
      ONLY_ACTIVE_STATES: "Cannot calculate, only active states exist.",
      NO_JOURNEYS: "Cannot calculate, no journeys exist." ,
      ABOUT: "About",
      SERVICE_NOT_DONE: "Service not yet completed",
      IN_PROGRESS: "and in progress",
      HOURS: "hours",
      DAYS: "days",
      MINUTES: "minutes",
      CANNOT_CALCULATE: "Cannot calculate",
      NO_STATES : "Cannot calculate, no states exist.",
      ALL_SERVICES: "All Services"
    },

    TimelineGeneral: {
     MULTIPLE_CUSTOMERS: "Which of these Customers are you referring to?",
     CANCEL: "Cancel",
     ANON_ID : "Anonymous ID:",
     SELECT_SERVICE : "Please select a service to see it's info.",
     NO_SERVICE: "No Services exist.",
     NO_STATES: "No states exist.",
     CURR_SELECTED: "Currently Selected"
    },

    FormControl: {
      CONNECT_FAILED: "Couldn't connect to Context Services.",
      EMAIL_FIND_FAILED: "Couldn't find any services associated with the customer with this email.",
      PHONE_FIND_FAILED: "Couldn't find any services associated with the customer with this phone number.",
      FIND_FAILED: "Couldn't find any services associated with the"
    },

    DownloadDfmTemplate: {
        FILENAME: "File Name:",
        DOWNLOADLINK: "Download Link:",
        CALLBACK: "Callback.jsp",
        NOTIFICATION: "Notification.jsp",
        SERVICES: "Services.jsp",
        STORAGE: "Storage.jsp",
    STATISTIC: "Statistic.jsp",
        DOWNLOADCALLBACK: "Download Callback.jsp",
        DOWNLOADNOTIFICATION: "Download Notification.jsp",
        DOWNLOADSERVICES: "Download Services.jsp",
        DOWNLOADSTORAGE: "Download Storage.jsp",
    DOWNLOADSTATISTIC: "Download Statistic.jsp"
    },
  
  MonitorView: {
    STATE_TYPES: {
      ACTIVE: "Active",
      INACTIVE: "Inactive"
    },
    MAIN: {
      DATA_CENTERS: "Data Centers",
      ANALYTICS: "Analytics",
      OPTIONS: "Options",
      API_USAGE: "API Usage",
      MONITOR: "Monitor",
      NODES: "Nodes",
    },
    //Nodes page
    FILTER_STATUS: "Filter by status",
    FILTER_DATA_CENTER: "Search for Data Center",
    FILTER_DISPLAY: "Display",
    FILTER_EXTERNAL: "External",
    FILTER_INTERNAL: "Internal",
    LAST_UPDATED: "Last Updated",
    EXTERNAL_CASSANDRA: "External Cassandra Configuration",
    INFO_IP: "IP",
    INFO_TOKEN: "Token",
    INFO_NAME: "Name",
    INFO_STATUS: "Status",
    INFO_LOAD: "Load",
    INFO_DATA_CENTER: "Data Center",
    INFO_RACK: "Rack",
    INFO_OWN: "Own",
    RUNNING_SINCE: "Running Since",
    REMOVE_NODE: "Remove Node",
    REMOVE_NODE_INFO: "This operation will remove the selected node. Do you wish to proceed?",
    BUTTON_REMOVE: "Remove",
    BUTTON_CANCEL: "Cancel",
    GET_NODES_ERROR: "Error retrieving nodes information",
    REMOVE_NODE_SUCCESS: "Remove node successful",
    REMOVE_NODE_ERROR: "Remove node error",
    NO_DATA_CENTER: "No data center information",
    NO_NODES_FOUND: "No nodes found.",
    HOST_IP: "Host IP Address",
    EXTERNAL_URL: "External URL",
    NODE_HOST_NAME: "Host Name",
    URI: "URI",
    SERVERS: "Servers",

    //monitor-options page
    SET_CONFIGURATION: "Set Configuration",
    SEARCH_WIDGET: "Search for Widget",
    NAME: "Name",
    FETCH_DATA_INTERVAL: "Fetch Data Interval (Milliseconds)",
    VISUAL_ADJUSTMENTS: "Visual Adjustments",
    ENTER_PERCENTAGE: "Enter Percentage",
    SET_ANALYTICS_THRESHOLD: "Set Nodes Warning Threshold",
    CHOOSE_POSITIVE_INTEGER: "Please enter a positive Integer",
    
    //API Usage Page
    START: "Start",
    END: "End",
    INTERVAL : "Interval",
    QUERY_TYPE: "Query Type",
    CALL_NAME: "Call Name",
    HOST_NAME: "Host Name",
    CONTACT_CENTER_ID: "Contact Center ID:",
    SELECT_SERVICE: "Select Service",
    SELECT_ALL: "Select All",
    QUARTER_HOUR: "15 Min",
    HALF_HOUR: "30 Min",
    HOUR: "Hour",
    DAY: "Day",
    WEEK: "Week",
    MONTH: "Month",
    COUNT: "Count",
    AVERAGE_DURATION : "Average Duration",
    START_NOT_BEFORE_END_DATE: "Start date must be before the end date!",
    DATE_RANGE_TOO_LARGE: "Date Range Too Large for Selected Interval!",
    PLEASE_SPECIFY: "Please Specify",
    HOSTNAME_WARNING: "No hostname is selected!",
    NO_DATA_AVAILABLE: "No Data Available",
    Y_AXIS_LABEL_AVG: "Average API Response Time (milliseconds)",
    Y_AXIS_LABEL_COUNT: "Number of API Calls",
    CHOOSE_FROM_FOLLOWING: "Choose among the following...",
    
    
  },

  //SAMPLES page

  SampleView: {
    FIRST_NAME: "First Name",
    LAST_NAME: "Last Name",
    PASSWORD: "Password",
    SCENARIO: "Scenario",
    PROBLEM: "Problem",
    URL: "URL",
    SERVICE: "Service",
    PROVIDE_CODE: "Provide Code",
    CONTACT_NUMBER: "Contact #",
    COMET_NOTIFICATIONS: "Comet Notifications",
    SETTINGS:"Settings",
    CHAT: "Chat",
    QUEUE: "Queue",
    LAST_KNOWN_POSITION_IN_QUEUE: "Last known position in queue",
    LAST_KNOWN_ESTIMATED_TIME_TO_ANSWER: "Last known estimated time to answer (URS):",
    AGENT_READY_THRESHOLD_PASSED: " 'Agent ready' threshold passed:",
    TOTAL_NUMBER_OF_INTERACTIONS_WAITING_FOR_THE_SAME_TARGET: "Total number of interactions waiting for the same target:",
    RESET: "Reset",
    CONNECT: "Connect",
    NOT_APPLICABLE: "n/a",
    ON: "On",
    OFF: "Off",
    CLEAR: "Clear",
    END_CHAT: "End Chat",
    SEND: "Send",
    NUMBER_TO_CALL: "Number to Call",
    ACCESS_CODE: "Access Code",
    CLOSE: "Close",
    DIAL_PHONE: "Dial Phone",
    DIAL_NUMBER: "Dial Number",
    REFRESH_QUEUE_INFO: "Refresh Queue Info",
    VIEW_LOGS: "View Logs",
    CONFIRMATION: "Confirmation",
    OK: "Ok",
    RESPONSE_FROM_GMS: "<--- Response from GMS: ",
    RESPONSE_FROM_GES: "<--- Response from GES: ",
    RESPONSE_FROM_GMS_VIA_COMET: "<--- Response from GMS via (Comet): ",
    RESPONSE_FROM_GES_VIA_COMET: "<--- Response from GES via (Comet): ",
    REQUEST_TO_GMS: "---> Request to GMS: ",
    REQUEST_TO_GES: "---> Request to GES: ",

  },

    ModelBuilder: {
        AGGREGATES: "Aggregates",
        SAVEAGGREGATES: "Save Aggregates",
        NAME: "Name",
        ENTER_AGGREGATE_NAME: "Enter aggregate name",
        DUPLICATE_AGGREGATE_NAME: "Duplicate aggregate name",
        CALCULATION: "Calculation",
        COUNT: "COUNT",
        SUM: "SUM",
        AVG: "AVG",
        UNIQUE: "UNIQUE",
        UNIQUE_TEXT: "UNIQUE_TEXT",
        TRIGGEREVENT: "Trigger Event",
        GLOBAL: "Global",
        GROUPBY: "Group By",
        PROPERTY: "Property",
        MUST_SELECT_PROPERTY: "Must select a property forcalculation.",
        TRUE: "True",
        COMBINEDLOOKSUPS: "Combined LookUps",
        SAVEDCOMBINEDLOOKSUPS: "Save Combined LookUps",
        LOOKUPNAME: "LookUp Name",
        ENTER_LOOKUP_NAME: "Enter LookUp Name",
        DUPLICATE_LOOKUP_NAME: "Duplicate lookup name",
        MUST_BE_AT_LEAST_ONE_PROPERTY_SELECTED: "There must be at least one property selected",
        INDEXINGEVENTS: "Indexing Events",
        MUST_BE_AT_LEAST_ONE_EVENT_SELECTED: "There must be at least one event selected",
        MIN: "MIN",
        HOUR: "HOUR",
        DAY: "DAY",
        NUMBER: "Number?",

        EVENT_NAME: "Event Name",
        EVENT_DESCRIPTION: "Event Description",
        PROPERTY_SAVE_EVENT: "Property Save Event",
        TIME_TRACKED_EVENT: "Time Tracked Event",
        P_S_E_GOES_HERE: "Property Save Events help goes here.",
        T_T_E_GOES_HERE: "Time Track Events help goes here.",

        SAVEEVENTS: "Save Events",
        EVENTS: "Events",

        DATADEPOT_MODEL: "DataDepot Model",
        EXPORT: "Export",
        RELOAD: "Reload",
        IMPORT: "Import",
        MODELNAME: "Model Name",
        ENTER_YOUR_MODEL_NAME: "Enter your model name",
        ACTIVITY_NAME: "Activity Name",
        ENTER_YOUR_ACTIVITY_NAME: "Enter your activity name",
        ADD_ACTIVITY: "Add Activity",
        DELETE_ACTIVITY: "Delete Activity",
        PASTE_JSO_FILE_HERE: "Please paste your JSON file here",
        FAILEDTOLOAD: "Failed to load file",

        WARNING_EDITING_JSON_DIRECTLY: "Warning: editing the JSON directly does not guarantee the validity of the model.",
        PLEASE_USE_TOOL_ON_THE_LEFT: "Please use the tool on the left side if possible.",
        CLICKING_WILL_DISCARD_INVALID_CHANGES: "Clicking save or export will discard all invalid changes.",
        MODEL_HAS_BEEB_UPDATED: "The model has been updated.",
        MODEL_NOT_GUARANTEED_TO_BE_VALID: "However, the model is not guaranteed to be valid.",

        PROPERTY_NOT_USED: "Property not used in aggregates or combined lookup",
        PROPERTY_NAME: "Property Name,",
        DEFAULT_VALUE: "Default Value",
        PRIMARY: "Primary",
        P_K_I_GOES_HERE:"Primary key input help goes here.",
        L_U_K_GOES_HERE: "Lookup key input help goes here.",
        ENTER_PROPERTY_NAME: "Enter property name",
        DUPLICATE_PROPERTY_NAME: "Duplicate name",

        PROPERTIES: "Properties",
        SAVEPROPERTIES: "Save Properties",

        SEARCH_SETTINGS: "Search Settings",
        ROOLLUP_RANGE: "Time Tracked Events RollUp Range",
        POSITIVE_NUMBER_PLEASE: "Please enter a positive number.",
        PROPERTIES_TTL_SETTINGS: "Properties TTL Seconds",
        EVENTS_TTL_SETTINGS: "Events TTL Seconds",
        SAVE_SEARCH_SETTINGS: "Save Search Settings"
    },

    CallbackView_ANGULAR: {
        //Callback View with common Strings
        NEWCALLBACK: "Add New Callback",
        COMPLETESCHEDULED: "You must enter a desired callback time for a 'scheduled' callback",
        CALLBACKTYPE: "Callback Type",
        SERVICENAME: "Service Name",
        IMMEDIATE: "Immediate",
        SCHEDULED: "Scheduled",
        CALLBACKPARAMETERS: "Callback Parameters",
        ADDITIONALPARAMETERS: "Additional Properties",
        URSVIRTUALQUEUE: "Urs Virtual Queue",
        REQUESTQUEUETIMESTAT: "Request Queue Time Stat",
        CANCEL: "Cancel",
        CONTINUE: "Continue",
        SUBMIT: "Submit",
        STATE: "State",
        DESIREDCALLBACKTIME: "Desired Callback Time",
        PHONENUMBER: "Phone Number",
        REFRESH: "Refresh",
        CREATECALLBACK: "Create Callback",
        ADVACEDOPTIONS: "Advanced Options",
        CALLBACKSFOUND: "Callback(s) Found",
        CUSTOM_DATE_RANGE: "Custom Date Range",
        INCLUDE_SERVICE_ID_COLUMN: "Include Service ID Column",
        INCLUDE_SERVICE_NAME_COLUMN: "Include Service Name Column",
        DISPLAY_CALLBACK_FOR: "Display Callbacks For",
        CUSTOMFIELDS: "Custom Fields",
        NO_CALLBACKS_FOUND: "No Callbacks Found.",
        NOT_SPECIFIED: "Not Specified",
        last_day: "Last 24 Hours",
        last_week: "Last 7 Days",
        last_month: "Last 30 Days",
        day: "Next 24 Hours",
        week: "Next 7 Days",
        month: "Next 30 Days",
        current: "Today",
        _customer_number: "Phone Number",
        _service_name: "Service Name",
        _desired_time_formatted: "Desired Callback Time",
        _callback_state: "State",
        _id: "Service ID",
        _day: "day",
    DISPLAYING: "Displaying",
    OF: "of",
    LIMIT_REACHED: "Max number of callbacks loaded. There may be more.",
    EWT: "Estimated wait time",
    POSITION_IN_QUEUE: "Position in queue",
    ETA_MINS: "minute(s)",
    ETA_SECS: "second(s)",
    LEGEND_USERTERMINATED: "USERTERMINATED callback",
    LEGEND_USERORIGINATED: "USERORIGINATED callback",
    LEGEND_FILTER: "Filtered column",
    BACK_TO_TOP: "Back to top",	
        EXPORT_CANCELLED_REPORTS: "Export Cancelled Reports",	  

        //Callback Diagnostics
        EWT: "Estimated wait time",
        POSITION_IN_QUEUE: "Position in queue",
        ETA_HOURS: "hour(s)",
        ETA_MINS: "minute(s)",
        ETA_SECS: "second(s)",
        PRIORITY: "Current priority",
        AGENTSLOGGEDIN: "Agents Logged in",
        ORSURL: "ORS URL",
        ORSSESSIONID: "ORS session ID",
        EWTATOFFER: "EWT at callback offer",
        POSATOFFER: "Position at callback offer",
        CALLBACKTYPE: "Callback type",
        CALLBACKTIMEACCEPTED: "Time callback was accepted",
        CHANNEL: "Channel",
        SKILLEXPRESSION: "Routing target",
        EWTATFIRSTDIAL: "EWT at first outbound call",
        POSATFIRSTDIAL: "Position at first outbound call",
        TIMEATFIRSTDIAL: "Time of first outbound call",
        DIALATTEMPT: "Dial attempt number",
        TIMENEXTDIALATTEMPT: "Time of next outbound call",
        ISSNOOZED: "Is snoozed",
        DIALRESULT: "Dial Result",
        TIMECUSTOMERCONNECTED: "Time customer was connected",
        REFRESH_ERROR: "Error loading this callback. Try refreshing the table",
        APPVERSION: "Callback version",
        //Advanced Callback View
        ADD_COLUMN_FIELD: "Add Column Field",
        FILTER_TABLE_S_A_S: "Filter Table by States and Service",
        CONFIGURE_COLUMNS: "Configure Columns",
        ADD_A_COLUMN_FIELD: "Add Column Field",
        STATES: "States",
        SCHEDULED: "SCHEDULED",
        QUEUED: "QUEUED",
        ROUTING:"ROUTING",
        PROCESSING: "PROCESSING",
        COMPLETED: "COMPLETED",
        PAUSED: "PAUSED",
        SERVICES: "Services",
        ANYSERVICE: "Any service",
        MAX_NUMBER_OF_CALLBACKS_PER_QUERY: "Max # of Callbacks per Query",
        CONFIGURE_DISPLAY: "Configure Display",
    CONFIGURE_RANGES: "Configure Custom Date Range",
    ADD_RANGES: "Add Custom Date Range",
    DAYS_PREVIOUS: "Days ago",
        DAYS_AHEAD: "Days ahead",

        //Edit Callback View
        EDIT_CALLBACK: "Edit Callback",
        CHANGE_DESIRED_DATE: "Change Desired Time",
        DESIRED_DATE: "Desired Date",
        DESIRED_TIME: "Desired Time",
        CHECK_AVAILABILITY: "Check Availability",
        AVAILABLE_TIMESLOT: "Available Time Slot",
        EDIT_CUSTOMER_LOOKUP_KEYS: "Edit Customer Lookup Keys",
        CLICK_THE_BUTTON_AGAIN:"Click the button again to confirm.",
        CONFIRM_CANCELLATION: "Confirm cancellation",
        CANCEL_CALLBACK: "Cancel Callback",
        ORS_FAILURE_CANCEL_TOAST: "Cancellation of callback completed despite ORS failure",
        CURRENT_CALLBACK_INFO: "Current Callback Information",
        CALLBACK_TIME:"Callback Time",
        CALLBACK_NUMBER: "Callback Number",

        //Reschedule Completed Callback View
        RESCHEDULE_COMPLETED_CALLBACK: "Reschedule Completed Callback",
        LAST_CALLBACK_INFO: "Last Callback Information",
        LAST_CALLBACK_TIME: "Last Callback Time",
        DESIRED_CALLBACK_TIME: "Desired Callback Time",
        RESCHEDULE: "Reschedule",

        //New Callback View
        IMMEDIATE: "Immediate",
        _SCHEDULED: "Scheduled",
        CUSTOMER_NUMBER: "Customer Number",
        ADD_NEW_PROPERTY: "Add New Property",
        SELECT_PLACEHOLDER: "Choose among the following",
        DEFINED_NUMBER: "This callback service has _customer_number defined",
        DEFINED_TIME: "This callback service has _desired_time defined",

        //Cancel Callback View
        CANCEL_CALLBACK_BUTTON_LABEL: "Cancel Callbacks",
        CANCEL_CALLBACK_MODAL_TITLE: "Cancel Callbacks Confirmation",
        CANCEL_CALLBACK_CONFIRMATION: "Confirm and Cancel Callbacks",
        NUMBER_OF_CALLBACKS_TO_CANCEL: "Callbacks to Cancel in Current Page: ",
        ERROR_IN_CANCELLING_CALLBACKS: "Failed",
        CANCEL_CALLBACKS_FROM_ALL_PAGES: "Cancel All Callbacks in Current Time Range",
        CANCELLATION_REASON: "Cancellation Reason",
        ERROR_IN_CANCELLING_CALLBACKS_LABEL: "Error in cancelling: ",

        //Cancellations Report View
        DOWNLOAD_REPORT_CANCEL_CSV: "Export Cancelled Callbacks",
        CANCELLATION_REPORT: "Cancellation Summary Report",

        //Placeholders
        SEARCH: "Search",
        ALLFIELDS: "All Fields",
        SELECT_START_DATE: "Select your start date",
        SELECT_END_DATE: "Select your end date",
        COLUMN_NAME: "Column Name",
        ALIAS: "Alias (Optional)",
        SELECT_YOUR_DATE: "Select Your Date",
        HOUR: "Hour",
        MINUTE: "Min",
        LOOK_UP_VALUE: "Look Up Value",
        OPTIONAL: "Optional",
        PARAMETER_NAME: "Parameter Name",
        PARAMETER_VALUE: "Parameter Value",
        YOUR_CALLBACK_NUMBER: "Your Callback Number",
    RANGE_NAME: "Range Name",
    OFFSET: "Offset",

        //ERROR MESSAGES
        ERROR: "Error",
        AUTHENTICATION_ERROR_RELOAD: "Your session has expired. Please, reload the window.",
        PLEASE_CHOOSE_A_DATE: "Please choose a date!",
        MAX_RANGE_ONE_MONTH: "Maximum range is one month!",
        START_DATE_NOT_BEFORE_END_DATE: "Start date is not before the end date!",
        MUST_BE_NUMBER: "Maximum callbacks must be a number",
    MUST_BE_NUMBER_RANGE: "Offset must be a number",
        MUST_BE_UNIQUE: "Column names must be unique",
    MUST_BE_UNIQUE_RANGE: "Range names must be unique",
    NUM_CALLBACKS_MUST_BE_IN_RANGE: 'Max callbacks per query must be between 100 and 1000',
    MUST_ENTER_OFFSET: "You must enter an offset",
    MUST_ENTER_RANGE_NAME: "You must enter an name for the custom date range",
    RANGE_NAME_INVALID: "The range name should only consist of Letters and Numbers",
    OFFSET_MUST_BE_AFTER: "Custom range end date can't be before start date",
        INVALID_TIME_INPUT: "Your time input is invalid.",
        MUST_SELECT_TIMESLOT: "You have to select a timeslot.",
        NEW_DATE_TIME_SELECTED: "You have to select a new datetime to reschedule.",
        OFFICE_IS_CLOSED: "Office is closed right now.",
        TIME_PASSED_ALREADY: "The time you entered has passed already.",
        BUSINESS_HOURS_SERVICE_OPTION_IS_INVALID: "The _business_hours_service option for this service is invalid.",
        CAPACITY_SERVICE_NOT_CONFIGURED: "You must configure _capacity and/or _capacity_add in capacity service",
        SERVICE_USERORIGINATED: "Cannot create a service of type USERORIGINATED from Admin UI.",
        INVALID_CUSTOMER_NUMBER: "Please enter a valid customer number.",
        SELECT_DESIRED_DATE: "You have to select a desired date.",
        NO_TIMESLOTS: "No timeslots available for this date. Please select a new date.",
        SELECT_DESIRED_TIME: "You have to select a desire time.",
        CREATE: "Create",
        NAME_TOO_LONG : "Please limit the name to 64 characters",
        SEARCH_PLACEHOLDER: "Search Table",
    NO_SERVICE_SELECTED: "No service selected",
	
	//Exceptions
	//TODO: add exceptions
	//NUMBER_ALREADY_BOOKED(40001)
	NUMBER_ALREADY_BOOKED: "There is already {max_queued} or more Callbacks QUEUED for this number, please refer to {queue_checking} for detail.",
	
	//THROTTLE_SERVICE_LIMIT(40002)	
    THROTTLE_SERVICE_LIMIT: "Limit of queued callbacks for {service} is reached.",
	//THROTTLE_SERVICE_INTERVAL_LIMIT(40003)	
    THROTTLE_SERVICE_INTERVAL_LIMIT: "Limit of queued callbacks for {service} is reached for interval {interval}s.",
	//THROTTLE_SERVICE_PARAMETER_LIMIT(40004)
    THROTTLE_SERVICE_PARAMETER_LIMIT: "Limit of queued callbacks for {service} is reached for parameter {parameter}. Reached {attempts} times today.",
	
    // BAD_PARAMETER(40010)
	MISSING_CALLBACK_OPTION: "Cannot create service, missing mandatory callback option {option}",
    EMPTY_CALLBACK_OPTION: "Cannot create service, empty mandatory callback option {option}",	
    NO_TIME_SLOTS: "No time slots available. The requested time period is in the past.",
    DAY_PARAM_RANGE: "day parameter must be between 1 and 7, inclusively. Actual value is: {day}",
    CALLBACK_TIME_IN_PAST: "Callback request contains _desired_time property in the past (-{rejectTimePastLimit}s < {rawdiff}s < {rejectTimeFutureLimit}s) - epoch {epoch}s",
    CALLBACK_TIME_IN_FUTURE: "Callback request contains _desired_time property too far in future (-{rejectTimePastLimit}s < {rawdiff}s < {rejectTimeFutureLimit}s) - epoch {epoch}s",
    CALLBACK_NO_LOOKUP_KEYS: "Callback {id} does not contain the mandatory customer lookup keys [{keys}]",
    CALLBACK_NO_TIME_PROP: "Callback {id} does not contain _desired_time property.",
    NO_PROPERTIES: "No lookup possible. No properties to look for.",
    NO_PARAMETERS: "No lookup possible. Try parameters {lookup_key_string}",
    MISSING_CALLBACK_PARAM: "Cannot create service, missing mandatory callback parameter {customer_number}",
	
    //INVALID_OPERATION(40020)	
	REQUEST_CALLBACK_CHECK_PARAM: "Request cannot be processed because callback {id} to copy is not COMPLETED. Check parameter _copy_from_id",
    CHECK_REQUEST_OR_SERVICE: "Tenant ID '{ccid}' is not managed by this application, check request parameter or service option ",
    ADJUST_QUERY_PARAM_OPTIONS: "Query range spans too much rows ({expectedRows}) while limit is {maxRows} rows. Adjust query parameters or options (storage_rows).",
    CALLBACK_LOST_SERVICE_NAME: "Callback {id} cannot be processed. Lost service name.",
    CALLBACK_NO_ORS_FOUND: "Callback {id} cannot be cancelled - No ORS session found. (_callback_state=QUEUED while _ors_session_id=null?)",
    UNABLE_PROCESS_ORS_CANCEL_REQ: "Callback {id} cannot be cancelled - unable to process ORS cancel request : {message}",
    CALLBACK_ORS_RESP_NULL: "Callback {id} cannot be cancelled - ORS response is null.",
    INVALID_SERVICE_CALLBACK: "Invalid service stored for callback {id}.",
    REJECTING_UPDATE: "Rejecting update : {service}=[{id} @ {time}] - reached state COMPLETED",
    CALLBACK_NO_DESIRED_TIME_PROP: "Callback {id} does not contain _desired_time property.",
    CALLBACK_CANCELLED_OR_COMPLETED: "Callback {id} cannot be cancelled or completed - _callback_state={state}",
    CALLBACK_CANNOT_DELETE: "Callback {id} cannot be deleted - _callback_state={state}",
    CALLBACK_NOT_SCHEDULED: "Callback {id} is no longer scheduled. State={state}",
    CALLBACK_INVALID_TIME_STORED: "Callback {id} has invalid desired time stored.",
    CANNOT_PROCESS_FILTER_PARAM: "Cannot process 'filter' parameter correctly : {filter}",
    SERVICE_NOT_SPECIFIED: "Service name not specified", 

	//CALLBACK_NOT_FOUND(40030)
    CALLBACK_NOT_FOUND: "Callback {id} to copy from cannot be found",
	NO_SUCH_REQUEST: "No such request : {serviceId}",
	CALLBACK_ID_CANNOT_BE_FOUND: "Callback {id} cannot be found",
	NO_SUCH_REQ_TO_UPDATE: "No such request to update : {service_name}=[{serviceId} @ {desiredTimeStr}]",
	CALLBACK_ID_CANNOT_BE_FOUND_1: "Callback {id} cannot be found - {service}=[{id} @ {time}]",
	CALLBACK_ID_NOT_FOUND_PING: "Callback {id} cannot be found (ping process)",
	
	//NUMBER_REJECTED(40040)
    INVALID_CHECK_OPTION: "Customer Number is not allowed, because it is invalid. Check option {impossible_phone_nos} ",
    PREMIUM_CHECK_OPTION: "Customer Number is not allowed, because it's a premium number. Check option {premium_phone_nos} ",
    FAILED_VALIDATING: "Customer Number is not allowed, because it failed validating. Check option {impossible_phone_nos} ",
    OPTION_EXCEPTIONS: "Customer Number is not allowed. Check option {exceptions} ",
  
    //SLOT_UNAVAILABLE(40050)
    PROPOSING_TIME_SLOTS: "{reason}. Proposing time slots.",
	
	//SLOT_UNAVAILABLE_PROPOSAL(40051)
    NO_TIME_SLOTS_1: "No time slots available.",
	
    //CAPACITY_ERROR(50004)    
    CAPACITY_ERROR: "{error}",
	
	//CALENDAR_ERROR(50005)
    CALENDAR_ERROR: "{message}",
	
	//ORS_MAX_SUBMIT_RETRIES(50006)
    ORS_MAX_SUBMIT_RETRIES: "Callback {id} reached maximum attempts to submit to ORS reached ({max-attempts})",
	
	//CALLBACK_LOCKED(50007)
    CALLBACK_LOCKED: "Error processing callback {id} - unable to lock callback in {interval}ms",
	
	//BAD_CONFIGURATION(50020)
    SERVICE_NOT_CONFIGURED: "Option service.{service} / {business_hours} not configured.",
	MISSING_CHAT_ENDPOINT: "Missing default_chat_endpoint option in chat section because this service has parameter _media_type=chat",
	MISSING_CLIENT_TIMEOUT: "Missing default _client_timeout option in chat section because this service has parameter _media_type=chat",
	SERVICE_CONFIGURED_INCORRECTLY: "Option service.{service} / {option} configured incorrectly.",
	OPTION_INVALID: "Option {business_hours} is invalid: {error}",
	VALIDATE_COUNTRY_PHONE_NO: "Service option {service} / {default_country} is not configured. But option {impossible_phone_nos} is set. We cannot validate phone numbers without knowing the country.",						
    VALIDATE_COUNTRY_PHONE_NOS_PREMIUM: "Service option {service} / {default_country} is not configured. But option {premium_phone_nos} is set. We cannot validate phone numbers without knowing the country.",
	SERVICE_UNDEFINED: "Service undefined: {service}",
	SERVICE_UNKNOWN_VALUE: "Service {service} has unknown value for option {option_type}",
	SERVICE_HAS_OPTION: "Service {service} has option {option_type} != {option_ors}",
	SERVICE_OPTION_DEFAULT: "Service {service} has option {option_service} != {option_service_default}",
	UNABLE_TO_PARSE_OPTION: "Unable to parse option: {wait_time} ={statistic}",
	
    //ORS_ERROR(50030)
	UNABLE_TO_CREATE_ORS_SESSION: "Unable to create ORS session.",
    ORS_SERVICE_CREATE_ERROR: "Unable to create service using ORS. Check ORS logs for errors.",
    CALLBACK_ORS_RESPONSE: "{response}",
    INVALID_ORS_SESSION: "Invalid ORS response",

	//SERVICE_REDIRECT_FAILED(50040)
    SERVICE_REDIRECT_FAILED: "{message}",
	
    //UNKNOWN_ERROR(50050)
	ERROR_PROCESSING_CALLBACK: "Error processing callback {serviceId}",
    FAILED_TO_SUBMIT_ORS: "Failed to submit to ORS",
    ERROR_DELETING_CALLBACK: "Error deleting callback {uuid}", 

    //STORAGE_ERROR(50060)
	FAILURE_QUEUE_CALLBACK: "Failure queuing callback : ",
    REGISTER_QUEUE: "Register Queue - {queueName} - Failure : ", 
    UNREGISTER_QUEUE: "Failure Unregister Queue - {queueName}",
    FAILURE_DELETING_CALLBACK: "Failure deleting callback : ",
	
	
        CANCELLATION_REASONS : {
          AM_CONNECTED : "AM_CONNECTED",
          RESCHEDULED : "RESCHEDULED",
          REDIAL_LIMIT_REACHED : "REDIAL_LIMIT_REACHED",
          FAILED : "FAILED",
          ABANDONED_IN_QUEUE : "ABANDONED_IN_QUEUE",
          AGENT : "AGENT",
          FAIL_LOAD_MESSAGE_FILE : "FAIL_LOAD_MESSAGE_FILE",
          CANCELLED : "CANCELLED",
          NOT_AVAILABLE : "NOT_AVAILABLE",
          FAIL_INTERACTION_DELETED : "FAIL_INTERACTION_DELETED",
          AGENT_CONNECTED : "AGENT_CONNECTED",
          FAIL_TARGET_NOT_FOUND : "FAIL_TARGET_NOT_FOUND",
          FAIL_ERROR : "FAIL_ERROR",
          FAIL_TIMEOUT_TTL : "FAIL_TIMEOUT_TTL",
          FAIL_IXN_UNKNOWN_MEDIA_TYPE : "FAIL_IXN_UNKNOWN_MEDIA_TYPE",
          FAIL_NO_CUSTOMER_NUMBER : "FAIL_NO_CUSTOMER_NUMBER",
          FAIL_USER_NO_CONFIRM : "FAIL_USER_NO_CONFIRM",
          FAIL_QUEUEING : "FAIL_QUEUEING",
          FAIL_AGENT_CONNECT : "FAIL_AGENT_CONNECT",
          FAIL_CALL_TO_CUSTOMER : "FAIL_CALL_TO_CUSTOMER",
          FAIL_INCORRECT_CONFIG_MEDIA_TYPE : "FAIL_INCORRECT_CONFIG_MEDIA_TYPE",
          FAIL_FAX_REACHED : "FAIL_FAX_REACHED",
		  FAIL_INBOUND_TIMEOUT: "FAIL_INBOUND_TIMEOUT",
          SUBMIT_ERROR : "SUBMIT_ERROR",
          SUBMIT_FAILED: "SUBMIT_FAILED",
          FAIL_USER_UNREACHABLE : "FAIL_USER_UNREACHABLE",
          CANCELLED_BY_ADMIN : "CANCELLED_BY_ADMIN",
          AGENT_PREVIEW_CANCEL_AFTER_n_REJECTS : "AGENT_PREVIEW_CANCEL_AFTER_<n>_REJECTS", //leave <n> in translated version. <n> will be replaced by number returned from API,
          NO_AGENT_DISPOSITION : "NO_AGENT_DISPOSITION",
          SUCCESS : "SUCCESS",
          BUSY : "BUSY",
          NO_ANSWER : "NO_ANSWER",
          SIT_TONE : "SIT_TONE",
          ANSWERING_MACHINE : "ANSWERING_MACHINE",
          CUSTOMER_NOT_KNOWN : "CUSTOMER_NOT_KNOWN",
          CUSTOMER_NOT_PRESENT : "CUSTOMER_NOT_PRESENT",
          WRONG_CUSTOMER_NUMBER : "WRONG_CUSTOMER_NUMBER"
        },
    },
  
  CapacityView: {
  CANCEL: "Cancel",
  SAVE: "Save",
  RESET: "Reset",
  GROUP_EDIT_ROW_LABEL: "Set Slot",
  GROUP_EDIT_COL_LABEL: "Set Day",
  TIMESTAMP: "Timestamp",
  CAPACITY: "Capacity",
  CAPACITY_ADD_LIST_LABEL: "Capacity Exceptions",
  CAPACITY_ADD_INPUT_LABEL: "Add Capacity Exception",
      CAPACITY_EMPTY: "Click to edit",
  FIRST_DAY_INDEX: "6",
  CAPACITY_MAX_ERROR: "Capacity entered is out of range. Please enter a valid value.",
  SHORTDAY: [
    "Mon",
    "Tue",
    "Wed",
    "Thu",
    "Fri",
    "Sat",
    "Sun"
      ],
  TOASTER:{
    UPDATE_SUCCESS: "Successfully updated data",
    UPDATE_ERROR: "Error updating data",
    CONNECTION_ERROR: "Error connecting to server",
    PERCENTAGE_ERROR: "Please enter a number between 0 and 100",
  }
  },

    OfficeHourView:{
      SEARCH_ITEMS: "Search Items",
      SEARCH: "Search",
      SEARCH_FOR:"Search for",
      NOT_FOUND: "not found",
      CONFIGURED_SERVICES: "Configured Services",
      OFFICE_HOURS: "Office Hours",
      CAPACITY: "Capacity",
      TODAY: "Today",
      DAY: "Day",
      WEEK: "Week",
      MONTH: "Month",
      HOURS: "hours",
      SETTINGS: "Settings",
      CHECKBOX_LABEL: "Regular Office Hours",
      BH_REGULAR_EVENT_LABEL: "Regular Office Hours",
      BH_ADD_EVENT_LABEL: "Special Office Hours",
      HOLIDAY_EVENT_LABEL: "Holiday",
      ALL_DAY: "All Day",
      TIME: "Time",
      NEW_OFFICE_HOURS: "New Office Hours",
      MODIFY_OFFICE_HOURS: "Modify Office Hours",
      BLOCK_TYPE: "Block Type",
      WEEKS_SELECTED: "Weeks Selected:",
      FOR_DAYS: "For Days:",
      BLOCK_ERROR: "Error: 'From' time must be strictly before 'To' time.",
  NO_DATE_ERROR: "Error: No date selected.",
  DELETE_ERROR_PREFIX: "Delete button disabled:",
  ALLOCATE_ERROR_PREFIX: "Create/Update button disabled",
  CUSTOM_ERROR: "There was an Error",
      BH_REGULAR_TYPE: "Regular Office Hours (bh_regular)",
      BH_ADD_TYPE: "Exception (bh_add)",
      HOLIDAY_TYPE: "Holiday (holiday)",
      THIS_IS_AN_ALL_DAY_EVENT: "This is an All Day Event",
      IS_ANNUAL_EVENT:"This is an Annual Event",
      BLOCK_TIME_SLOT: "Block Time Slot",
      FROM: "From",
      TO: "To",
      CANCEL: "Cancel",
      DELETE: "Delete",
      UPDATE: "Update",
      CREATE: "Create",
      CONFIRM: "Confirm",
      MOVE: "Move",
      RESIZE: "Resize",
      TOASTER_SUCCESS: "Creating/Updating Office Hour Succeeded.",
      TOASTER_UPDATE_FAIL: "Creating/Updating Office Hour Failed.",
      TOASTER_DELETE_SUCCESS: "Delete Office Hour Succeeded.",
      TOASTER_CANCELLED: "Creating/Updating Office Hour Cancelled.",
      BH_REGULAR: "BH Regular",
      BH_ADD: "BH Add",
      HOLIDAY: "Holiday",
      OLD_TIME: "Old Time",
      NEW_TIME: "New Time",
      MODAL_TITLE: "Settings",
      ALL_DAY_ROW: "Show All Day Row",
      POPOVERS: "Popovers",
      CHECKBOX: "Checkbox",
      ON: "On",
      OFF: "Off",
      TIME_INTERVAL: "Time Interval per Block",
      FIRST_DAY: "First Day of the Week",
      DAYS_TO_HIDE: "Days to Hide",
      DISPLAYED_CALENDARS: "Displayed Calendars",
      OFFICE_TIMEZONE: "Office Timezone",
      DISPLAY_TIMEZONE: "Display Timezone",
      TIMEZONE_ERROR: "The specified timezone is invalid",
      CLOSE: "Close",
      SAVE: "Save changes",
      NONE: "None",
      ERROR: "Error",
      SETTINGS_ERROR: "At least one day must not be hidden",
      AUTHENTICATION_ERROR_RELOAD: "Your session has expired. Please, reload the window.",
      DURATION_ERROR: "The office hour cannot be longer than",
      START_NOT_BEFORE_END: "The start time must be before the end time",
      ALL_PARAMETERS: "All Parameters",
  CUSTOM_ERROR_MESSAGE: "There is an error",
  NO_DATE_ERROR_MESSAGE: "No date selected",
  DELETE_ERROR_PREFIX: "Error, can not delete event: ",
  ALLOCATE_ERROR_PREFIX: "Error, can not update event: ",
  TIMEZONE_NOT_EQUAL: "The calendar is in read-only mode because the office timezone is not equal to the displayed timezone",
      NO_OFFICE_HOURS_TEMPLATE_FOUND: "No Office Hours Template Found"
    },

    ConfiguredServicesView:{
      SERVICES: "Services",
      EXPAND: "Expand All",
      COLLAPSE: "Collapse All",
      ADVANCED_PARAMETERS: "Advanced Parameters",
      ADD_NEW: "Add New",
      CLONE: "Clone",
      DELETE: "Delete",
      REFRESH: "Refresh",
      NAME: "Name",
      VALUE: "Value",
      DESCRIPTION: "Description",
      REQUEST_PARAMETER: "Request Parameter",
      CREATE: "Create",
      DELETE_SETTING: "Delete Setting",
      REMOVE_CONFIRMATION: "Are you sure you want to remove",
      DELETE_SERVICE: "Delete Service",
      DELETE_CONFIRMATION: "Are you sure you want to delete",
      CANCEL: "Cancel",
      DELETE: "Delete",
      CONFIRM: "Confirm",
      ERROR: "Error",
      ADD_NEW_SERVICE: "Add New Service",
      ADD_NEW_OFFICE_HOURS: "Add New Office Hours",
      SERVICE_TEMPLATE: "Service Template",
      SERVICE_NAME: "Service Name",
      COMMON_DEFAULT_CONFIGURATIONS: "Common Default Configuration",
      ADD: "Add",
      SETTING_PLACEHOLDER: "click here to set the key",
      REQUIRED_PARAMETER_TOOLTIP: "This parameter is required and cannot be changed.",
      REQUEST_PARAMETER_TOOLTIP: "This is a request parameter.  Setting it here will override the parameter provided in the request.",
      REVERT_PARAMETER_TOOLTIP: "Revert back to default/global value",
      SUCCESS: "Success",
      RENAME_ERROR: "Rename Delete Error",
      NOT_VALID: "Not Valid",
      NO_CATEGORIES_TO_CHOOSE_FROM: "No categories available",
      CHOOSE_FROM_FOLLOWING: "Choose among the following...",
      SELECT_CATEGORIES_TO_SHOW: "Select categories",
      SEARCH_PLACEHOLDER: "Search Table",
      SELECT_ALL: "Select All",
      MAX_LENGTH_PLACEHOLDER: "Selected",
      PARAMETER_EXISTS: "Parameter already exists",
      DUPLICATE_SUCCESS: "Duplicate Success",
      DUPLICATE_ERROR: "Duplicate Error",
      CANNOT_BE_DUPLICATED: "This cannot be duplicated.",
      REFRESHED: "Refreshed",
      SERVICE_DELETED: "Service Deleted",
      SERVICE_DELETE_FAILED: "Service Deletion Failed",
      ROW_NOT_SELECTED_FOR_DELETE: "Row not selected for deletion.",
      CANNOT_DELETE_PARAMETER: "Cannot delete required parameter.",
      DELETE_SUCCESS: "Delete Success!",
      CHOOSE_A_TEMPLATE: "Please choose a template.",
      CHOOSE_A_NAME: "Please choose a name.",
      NAME_TOO_LONG: "Please limit the name to 64 characters",
      NAME_EXISTS: "Name already exists, Please choose another name.",
      SERVICE_CREATED: "Service Created",
      SERVICE_CREATE_FAILED: "Service Creation Failed",
      NEW_SERVICE_NAME: "New Service Name",
      CLICK_TO_SET_KEY: "click here to set the key",
      CLICK_TO_SET_VALUE: "click here to set the value",
      AUTHENTICATION_ERROR_RELOAD: "Your session has expired. Please, reload the window.",
      INSUFFICIENT_PERMISSIONS: "User does not have valid permissions to complete this operation.",
      TABLE: "Table",
      CALENDAR: "Calendar",
  REQUIRED_PARAMETER_POP: "Please specify a value for ",
      NO_SERVICES_FOUND: "No services found",
      DUPLICATE_IMPORT: "This Office Hour is already imported",
      MUST_BE_GREATER_ZERO: "Must be greater or equal to 0",
      MUST_BE_GREATER_THAN_URS_VQ_MIN : "_urs_vq_priority_max cannot be less than _urs_vq_priority_min",
      RESULTS: "Results",
      OF: "of",
      CALLBACK: "Callback",
      OFFICE_HOURS: "Office Hours",
      CAPACITY: "Capacity",
      GET: "Get",
      MATCH_INTERACTION : "Match Interaction",
      REQUEST_ACCESS: "Request Access",
      REQUEST_CHAT: "Request Chat",
      URS_STAT: "URS Stat",
      REQUEST_INTERACTION: "Request Interaction",
      MISCELLANEOUS: "Miscellaneous",
	  PARAMETER_NOT_SAVED: "Parameter not saved",

      ServiceTemplateProfiles: {
        USER_ORIGINATED_IMMEDIATE: "User Originated Immediate",
        USER_ORIGINATED_DELAYED: "User Originated Delayed",
        USER_TERMINATED_IMMEDIATE: "User Terminated Immediate",
        USER_TERMINATED_DELAYED: "User Terminated Delayed",
        USER_TERMINATED_AGENT_PREVIEW: "User Terminated Preview",
        CHAT_IMMEDIATE: "Chat Immediate",
        CHAT_DELAYED: "Chat Delayed",
        SAMPLES: "Samples"
      },
    },
  
  ServiceTemplatesViewNew:{
  SERVICE_TEMPLATES_LABEL: "Service Templates",
  ID_LABEL: "Id",
  DEFAULT_VALUE_LABEL: "Default Value",
  DESCRIPTION_LABEL : "Description",
  TABLE_SEARCH_PLACEHOLDER: "Search from table",
  SELECT_CATEGORIES_TO_SHOW: "Select categories",
  NO_CATEGORIES_TO_CHOOSE_FROM: "No categories available",
  SELECT_ALL: "Select All",
  MAX_LENGTH_PLACEHOLDER: "Selected",
  UPLOAD_LABEL: "Upload",
  DELETE_LABEL: "Delete",
  TEMPLATE_SEARCH_PLACEHOLDER: "Search Service Templates",
  NO_SERVICE_TEMPLATES: "No service templates found",
  UPLOAD_SUCCESS: "Upload Successful",
  UPLOAD_ERROR: "Error Uploading",
  FETCHING_ERROR: "Error Fetching Templates",
  FILETYPE_ERROR: "Invalid File Type",
  DELETE_TEMPLATE_LABEL: "Delete",
  CANCEL_LABEL: "Cancel",
  CONFIRM_LABEL: "Confirm",
  DELETE_SUCCESS: "Delete Successful",
  DELETE_ERROR: "Error Deleting Template",
  REFRESH_TEMPLATE_LABEL: "Refresh",
  REFRESH_SUCCESS: "Refresh Success",
  REFRESH_ERROR: "Refresh Failed"
    },

    HOMEVIEW: {
      ADMIN_UI: "Services and Tools",
      SERVICES: "Services",
  CALLBACKENGAGEMENT: "Callback",
      CONTEXT_SERVICES: "Context Services",
      JOURNEY_TIMELINE: "Journey Timeline",
  MESSAGE_INFO: "There are no options available for your role.",
  MESSAGE_ERROR: "Couldn't find role for current user. Ensure that roles are set up correctly and log in again."
    },

    ErrorModal: {
      CLOSE: "Close",
      RELOAD: "Reload"
    },

    NavBar: {
        nav_header:                       "Mobile Services",
        nav_dashboards:                   "Dashboards",
    nav_monitor:						"Monitor",
        nav_callback:                     "Callback",
        nav_configured_services:          "Services",
    nav_tools:						"Tools",
    nav_tools_resources:				"Resources",
    nav_tools_patterns:				"Patterns",
    nav_tools_service_templates:		"Service Templates",
    nav_tools_download_dfm:			"Download Dfm",
    nav_tools_config:           "Config",
        nav_cs:                           "Context Services",
        nav_dashboards_handletime:        "Handle Time",
        nav_reports:                      "Reports",
        nav_account:                      "Username",
        nav_account_manageaccount:        "Manage Account...",
        nav_account_settings:             "Settings...",
        nav_logout:                       "Log out",
        nav_search:                       "Search",
        nav_help:                         "Help",
        nav_tools_reporting:              "Reporting",
        nav_tools_metrics:                "Metrics", //will replace above
        nav_tools_sample:                 "Sample",
        nav_office_hours:                 "Office Hours",
        nav_journey_timeline:             "Journey Timeline"
        
    },

    Main_Login: {
      title: "English",
      APP_NAME_GMS_LOGIN: "GMS Management UI - Login",
      APP_NAME_GES_LOGIN: "GES Management UI - Login",
      loginFormTitle: {
          username:"Username",
          password:"Password",
          language:"Language",
          button: "Log In",
          forgotPassword:"Forgot your password?",
          page:"Welcome",
          copyright:"2023 Genesys Telecommunications Laboratories",
          version:"1.0.0",
          termOfUse:"Terms of Use",
          privacyPolicy:"Privacy Policy"
      },
      errorMessages: {
          incorrectLogin: "Incorrect username and/or password.",
          frameWorkConnectionError: "Connection to the Configuration Server lost.",
          emptyField: "Please fill all required fields",
          connectionError: "Server Connection Error",
          maxSessions: "Exceeded max number of concurrent connections for this user"
      }
    },

    DATETIME_FORMATS: {
      DAY: [
        "Sunday",
        "Monday",
        "Tuesday",
        "Wednesday",
        "Thursday",
        "Friday",
        "Saturday"
      ],
      MONTH: [
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December"
      ],
      SHORTDAY: [
        "Sun",
        "Mon",
        "Tue",
        "Wed",
        "Thu",
        "Fri",
        "Sat"
      ],
      MINDAY: [
        "Su",
        "Mo",
        "Tu",
        "We",
        "Th",
        "Fr",
        "Sa"
      ],
      SHORTMONTH: [
        "Jan",
        "Feb",
        "Mar",
        "Apr",
        "May",
        "Jun",
        "Jul",
        "Aug",
        "Sep",
        "Oct",
        "Nov",
        "Dec"
      ],
      AMPMS: ["AM", "PM"]
    },
    NUMBER_FORMATS: {
      CURRENCY_SYM: "$",
      DECIMAL_SEP: ".",
      GROUP_SEP: ",",
      PATTERNS: [
        {
          gSize: 3,
          lgSize: 3,
          maxFrac: 3,
          minFrac: 0,
          minInt: 1,
          negPre: "-",
          negSuf: "",
          posPre: "",
          posSuf: ""
        },
        {
          gSize: 3,
          lgSize: 3,
          maxFrac: 2,
          minFrac: 2,
          minInt: 1,
          negPre: "-\u00a4",
          negSuf: "",
          posPre: "\u00a4",
          posSuf: ""
        }
      ]
    },
    //:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


    //You do not need to translate root language. It
    //is just to check what the default language it is.
    root_language: "en-US",
  },

  //This is set to false because we do not want to make this language usable
  //in the application. For any language that you want to support, ensure that
  //the boolean variable is set to true. Ensure that the boolean variable's
  //name is the same as the folder name for the language.
  "debug" : false,
  "fr-CA" : true,
  "ja-JP" : true
});
