
// This is a global name space within the session. All Metrics are stored as properties of the METRICS object allowing METRIC.<metricname> to be used

// Examples
// METRICS.create("Activity") - Would create a counter called Activity and populate it with a start time, zero counter and would be open
// METRICS.Activity.close() - Would result in the counter being closed, the end time and duration would be calculated. No more counters can be accepted until its openned
// METRICS.create(counter) - Would add a counter to the METRICS that may have been created individually
// var counter = new METRICS.COUNTER("Activity2"); Would create an individual counter not stored in METRICS

// TO DO's
// 1) Need to think about naming when multiple activities are xi:included.
var METRICS = {

 // Counter objects can be created explicitly using this object or implicitly using the metric API's
 COUNTER : function(counter, report,counterType, stateFrom, stateTo){
	this.name = counter;
	this.start = new Date().getTime();
	this.end   = -1;
    this.duration  = -1;
    this.activeduration = -1;   // The time we spent doing things and not in a paused state
	this.value = 0;
	this.initial = 0;
    this.isopen = true;
    this.reportable = false; // Default Counters are never reportable
    this.state_from = stateFrom;
    this.state_to = stateTo;
    
    // Vars used for handling pause and resume of a counter
    this.pausestart = 0; // Used to track when a counter is paused
    this.accumulatedpausedtime = 0; // Used to track the accumulated pause time
    this.pausecounter = 0;
    this.resumecounter = 0;
    this.ispaused = false;
    
    // Standard details from the activity, which is name and session id.
    // [DWS] GMS-7272 Remove ActivityName from globals
    // this.ActivityName = _data.ActivityName;
    this.ActivityName = 'callback';
    this.ActivityType = _data.ActivityType;    
    this.ActivityVersion = _data.ActivityVersion;    
    
    this.SessionID    = _sessionid;
    this.ParentSessionID = "NULL";
    
    this.media_type = _data._media_type;
    
    // Model Data Items - These can be added or removed at will from the counter
    this.ModelData = new Object();
    
    // Indicate if the data is dirty. Reset to false on reporting.
    this.dirty = true;
    
    __Log("Create COUNTER name = "+ counter+ " Reportable="+ report)
    if(typeof report != 'undefined'){
    	this.reportable = Boolean(report);
    }
    
    // Counters can have a type. Default is Normal but we can also support ONESHOT too.
    if(typeof counterType == 'undefined'){
    	this.counterType = 'NORMAL';
    }else{
    	this.counterType = counterType;
    	
    	if(this.counterType == "ONESHOT"){
    		this.dirty = true;
    		this.end = this.start;
    		this.duration = 0;
    		this.activeduration = 0;
    		this.isopen = false;
    	}
    }
    	
    
	this.inc= function(inc){
        if(this.isopen){
        	this.dirty = true;
        	this.value += typeof inc == 'number' ? inc :1;
        }
	}
	
	this.dec = function(dec){
            if(this.isopen){
            	this.dirty = true;
            	this.value -= typeof dec == 'number' ? dec :1;
            }
	}

	// This will set the value back. It will also record this as the initial value.
	this.set= function(val){
        if(this.isopen){
       	  this.dirty = true;
       	  this.value += typeof inc == 'number' ? val : this.value;
	      this.initial =typeof inc == 'number' ? val : 0;
        }
    }


	this.close = function(){
		if(this.isopen){			    
        		this.dirty = true;
        		this.isopen = false;
                this.end = new Date().getTime();
                this.duration = this.end - this.start;
                
                // This may happen 
                if(this.duration < 0)
                	this.duration = 0;
                
                // If we are paused then update the duration. But dont count this as an actual resume
                if(this.ispaused){
                	this.resume();
                	this.resumecounter--;
                }
                
                // Calculate active duration
                this.activeduration = this.duration - this.accumulatedpausedtime;
		}        
	}


	this.open = function(){
		if(!this.isopen){
        	this.dirty = true;
            this.isopen = true;
            this.resume();
		}
	}

        this.getName = function(){
           return this.name;
        }

    // Set the counter into paused mode. During this time we do not allow any counters to be updated they are ignored.
    this.pause = function(){
        if(!this.ispaused){
        	this.dirty = true;
        	this.ispaused = true;
        	this.pausecounter++;
        	this.pausestart = new Date().getTime();  
        }
    }
    
    // This will resume the counter from Pause and updated the accumulated pause time. 
    this.resume = function(){
        if(this.ispaused){
        	this.dirty = true;        	
        	this.ispaused = false;
        	this.resumecounter++;
        	var now = new Date().getTime();
        	this.accumulatedpausedtime +=   now - this.pausestart;
        	this.pausestart = 0;
        }
    }
    
    // This will just reset the counter and duration. it will not effect open or paused state info.
    // WB TODO - May have to revisit this function
    this.reset = function(){
    	this.dirty = true;    	
    	this.start = new Date().getTime();
    	this.end   = -1;
        this.duration  = -1;    
        this.value = 0;

        this.pausestart = 0; // Used to track when a counter is paused
        this.accumulatedpausedtime = 0; // Used to track the accumulated pause time
        this.pausecounter = 0;
        this.resumecounter = 0;

    }

    // This will just reset the start period. It will not reset the accumulated pause time
    // This allows a counter to be declared ahead of time and then 
    // have the start time modified. Such a counter may be reused multiple times and we will
    // accumulate the various counters.
    this.resetStartOnly = function(){
    	this.dirty = true;    	
    	this.start = new Date().getTime();
    	this.end   = -1;
        this.duration  = -1;    
        
        // We do not touch this either
        // this.value = 0;

        // We do not touch any of these...
        //this.pausestart = 0; // Used to track when a counter is paused
        //this.accumulatedpausedtime = 0; // Used to track the accumulated pause time
        //this.pausecounter = 0;
        //this.resumecounter = 0;

    }
    
    // Used to indicate we have reported on the event.
    this.reported = function(){
    	this.dirty = false;
    }
    
    this.setReportable = function(){
    	this.reportable = true;
    }
  
    // This will add the data model variable name to this counter so that its value can be reported 
    // up with the counter
    this.attachActivityData = function(dataName, value){    	
   		this.ModelData [dataName] = value;
    }
    
    // WB TO-DO Add the detachActivityData function here.. Not added for the prototype
},


// Metric API's
	
total : 0,
	
    // Creating from a list allows counters to be reportable or not.
    createFromList: function(listName,section){
	  var metrics
	  if(listName.indexOf(listName,'ACTIVITY') == -1){
	   metrics = _genesys.session.getListItemValue(listName, section);
	  }else{
		  metrics = _genesys.session.getListItemValue('ACTIVITY_'+listName, section);		  
	  }var metric;
	  
	  // We create all of the metrics from the list if they are active.
	  // The metric name is followed by a 1 or 0. 0 Indicates that it is not reportable.
      for (metric in metrics){
    	  __Log("Creating Metric="+metric+" Value ="+metrics[metric])
    	  var m = this.create(metric,0);
    	  if(m !== null){
    		  // Explicitly set the reporting flag
    		  if(metrics[metric].toUpperCase() == "TRUE" || metrics[metric] == "1" || metrics[metric].toUpperCase() == "YES" || metrics[metric].toUpperCase() == "Y")
    			  m.reportable = true;
    	  }	  
      }	  
	 
    },
    
    
    // This is used to create a one shot metric that is opened and closed immeditely. Such ones are used for event reporting only.
    // One Shot counters are always RECREATED ! Allowing the developer to create it and send it and then loop again !
    createOneShot: function (name,initial){
    	
    	// Remove if it exisits
    	this.remove(name);
    	
    	var newcnt = this.create(name,initial,"ONESHOT")
    	return newcnt;
    },
    
	// This will create a net new metric if it does not exist. 
    // NEw metrics by default are not reportable. It requires
    // an explict Counter to be created and added to the METRIC
    // we dont expose any way to adjust the reportable aspect 
    // of a counter.
	create: function(name, stateFrom, stateTo, initial, counterType){
                
                if(name instanceof METRICS.COUNTER){
                  
                  // Obviously dont allow duplicates ;-)
                  if(this.hasOwnProperty(name.getName())){
                      return this[name.getName()];
                  } 
                  else{
                     this[name] = name;
                     if(typeof initial == "undefined"){
                         this[name].set(0);            
                     }else{
                         this[name].set(initial);            
                     }
                     this.total++;
                  }
                }else{
                  if(this.hasOwnProperty(name) ){
                     return this[name];
                  }
                  this.total++;
                  
		          this[name] = new METRICS.COUNTER(name, false, counterType, stateFrom, stateTo);		          
                  if(typeof initial == "undefined"){
                      this[name].set(0);            
                  }else{
                      this[name].set(initial);            
                  }
                  return this[name];
                }
	},
	
        get: function(name){

             if(this.hasOwnProperty(name)){
                return this[name];
             }
             else{
                return this.create(name);
             }
          
        },
        
   
        // This will remove the metric regardless of if it is reportable or not
        // TODO May be we need to relook at this and add ability to not remove ACTIVITY related counetrs!
        remove: function(name){
           var delname = null;
           if(name instanceof METRICS.COUNTER){
              delname = name.getName();
           }else{
              delname = name;
           }

           if(this.hasOwnProperty(delname)){
               this.total--;
	           delete this[delname];
           }
        },

        isMetric: function(name){
          if(this.hasOwnProperty(name)){
             return true;
          }else{
             return false;
          }
        },	

        closeAll: function (){
           var metric;
           for (metric in this){
             if(this[metric] instanceof METRICS.COUNTER){
                this[metric].close();
             }
           }
        },

        openAll: function(){
            var metric;
            for (metric in this){
              if(this[metric] instanceof METRICS.COUNTER){
                 this[metric].open();
              }
            }
        },
        
        // This will obtain all reportable events or if provided a name will only send a single Metric
        getReportable: function(metricName){
            var metric;
            var reports = new Array();
            var reportTime = new Date().getTime();
            
            if(typeof metricName == "undefined"){
                for (metric in this){
                    if(this[metric] instanceof METRICS.COUNTER){
                  	  if(this[metric].dirty && this[metric].reportable){
                  		  reports.push(formatCounter(this[metric],reportTime,this.glbActivityData));
                  		  this[metric].reported();
                  	  }
                    }
                  }      
            }else{            	
            	if(this.hasOwnProperty(metricName)){
        		  reports.push(formatCounter(this[metricName],reportTime,this.glbActivityData));
         		  this[metricName].reported();
                }
            }
            
            return reports;
        },
        
        // This will format an existing counter and return it. It will be ready to send.
        // This should be used when any associated data could change between raising the 
        // event and it being handled in the Event Handler.
        // We indicate that we have reported this so that we dont send duplicates
        snapshotMetric : function(metric){
        	var reports = new Array();
            var reportTime = new Date().getTime();
            if(metric instanceof METRICS.COUNTER){
            	reports.push(formatCounter(metric,reportTime,this.glbActivityData)); 
            	metric.reported();
        	}
            
            // Yes its an array of 1 or 0 !
            return reports;
        },
     
        glbActivityData : new Object(),
        
        // This will attach data to all events for this activity. Such data will be defined within the data model
        attachGlobalActivityData : function(dataName, value){
    		this.glbActivityData [dataName] = value;
        }
      
};



	
