if (!Date.prototype.toISOString) {
    Date.prototype.toISOString = function() {
        function pad(n) { return n < 10 ? '0' + n : n }
		function pad100(n) { return n < 10 ? '00' + n : (n < 100 ? '0'+n : n) }
        return this.getUTCFullYear() + '-'
            + pad(this.getUTCMonth() + 1) + '-'
            + pad(this.getUTCDate()) + 'T'
            + pad(this.getUTCHours()) + ':'
            + pad(this.getUTCMinutes()) + ':'
            + pad(this.getUTCSeconds()) + '.'
            + pad100(this.getUTCMilliseconds()) + 'Z';
    };
}

function fromISOString(q) {
	var reg=new RegExp("^[0-9]{4}-(1[0-2]|0[1-9])-(3[0-1]|0[1-9]|[1-2][0-9])T(2[0-3]|[0-1][0-9]):[0-5][0-9]:[0-5][0-9].[0-9]{3}Z$","g");
	if (!reg.test(q)) {
		throw ("Invalid format for UTC timestamp : " + q);
	}
	
    return new Date(
            Date.UTC(
                    Number(q.substring(0,4)),
                    Number(q.substring(5,7))-1,
                    Number(q.substring(8,10)),
                    Number(q.substring(11,13)),
                    Number(q.substring(14,16)),
                    Number(q.substring(17,19)))
            );                                             
}

function reportSpecificMetric (metricName) {
	var params = {'metric': metricName};
	if (_data._use_reporting_aggregator) {
		__Raise ("report.specific",params);
	}
}

function flagPersist() {
	__Raise ("method.persist.queue");
}


function getRandomInt() {
	// 5 digit number
	var min = 10000;
	var max = 100000;
	return Math.floor(Math.random() * (max - min)) + min;
}

function deactivateSubTimeouts (activeTimeouts, timeouts, targetTimeout, parentTimeout) {
	// if parent not specified use root
	if (parentTimeout == undefined) {
		parentTimeout = timeouts;
	}
	for (var key in parentTimeout) {
		// check for match
//		__Log ("currentTimeout: " + key + ":: targetTimeout: " + targetTimeout);
		// if targetTimeout is not specified then match all
		if (targetTimeout == undefined || key == targetTimeout) {
			// deactivate a timeout
			activeTimeouts [key] = 0;
			__Log ("Deactivate subtimer: " + key);
			// deactivate (reset) children timeouts
			deactivateSubTimeouts (activeTimeouts, timeouts, undefined, parentTimeout[key]);
			break;
		} else {
			// find target
			deactivateSubTimeouts (activeTimeouts, timeouts, targetTimeout, parentTimeout[key]);
		}
	}
}

function activateTimeout (activeTimeouts, timeouts, targetTimeout, params, duration) {
	var timeoutId = getRandomInt();
	// reset timeout and subtimeouts
	deactivateSubTimeouts (activeTimeouts, timeouts, targetTimeout, undefined);
	// activate a timeout
	activeTimeouts [targetTimeout] = timeoutId;
	__Log ("Activate timer: " + targetTimeout);
	// raise delayed event
	var paramsObj = JSON.parse(JSON.stringify(params));
	paramsObj.timeoutId = timeoutId
	__Raise ("method.timer.done." + targetTimeout, paramsObj, duration);
}

function deactivateTimeout (activeTimeouts, timeouts, targetTimeout) {
	// reset timeout and subtimeouts
	deactivateSubTimeouts (activeTimeouts, timeouts, targetTimeout, undefined);
}

function isActiveTimeout (activeTimeouts, targetTimeout, timeoutId) {
	if (activeTimeouts [targetTimeout] == timeoutId) {
		return true;
	} else {
		return false;
	}
}

function logMsg (location, msg) {
	__Log("GMSCallback@" + location + " => " + msg);
}

function isPausedServicesListDefined() {
    if (_data._paused_services_list != undefined && _data._paused_services_list != "") {
        return true;
    } else {
        return false;
    }
}

function isServicePaused() {
    var paused = false;
    if (isPausedServicesListDefined()) {
        try {
            var services = _genesys.session.getListItemValue(_data._paused_services_list, "services");
            __Log("Paused services: " + JSON.stringify(services));
            if (_data._paused_services_id != undefined && _data._paused_services_id != "" && services[_data._paused_services_id] == "true") {
                paused = true;
            }
            else if (services["all"] == "true" || services[_data._service_name] == "true") {
                paused = true;
            }
        }
        catch (e) {
            __Log("Paused services list: " + _data._paused_services_list + ", section services not found");
        }
    }
    
    return paused;
}

//If v1 >= v2, return true, otherwise return false
function versionCompare(v1,v2) {
    if (typeof v1 == "number") {
        v1 = "0" + v1;
        v1 = v1.substr(1,v1.length-1);
    }
    if (typeof v2 == "number") {
        v2 = "0" + v2;
        v2 = v2.substr(1,v2.length-1);
    }

    if(v1 == v2){
        return true;
    }
    var v1Arry = v1.split(".");
    var v2Arry = v2.split(".");

    for (var i = 0; i < v1Arry.length; i++) {
        if (i > v2Arry.length) {
            return true;
        } else{
            if (parseInt(v1Arry[i]) > parseInt(v2Arry[i])) {
                return true;
            } else if (parseInt(v1Arry[i]) < parseInt(v2Arry[i])) {
                return false;
            }
        }
    }

    return false;
}

