﻿using System;
using System.Windows.Controls;
using Genesyslab.Desktop.Infrastructure;
using Microsoft.Practices.Composite.Regions;
using System.Collections.Generic;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;

namespace Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ContentView
{
	/// <summary>
	/// Interaction logic for CustomWorkItemView.xaml
	/// </summary>
	public partial class CustomWorkItemView : UserControl, ICustomWorkItemView
	{
		public CustomWorkItemView(ICustomWorkItemViewModel customWorkItemViewModel)
		{
			Model = customWorkItemViewModel;
			InitializeComponent();

			Width = Double.NaN;
			Height = Double.NaN;
		}

		#region IView Members

		public IRegionManager RegionManager { get; set; }

		public object Context { get; set; }

		public void Create()
		{
			IDictionary<string, object> contextDictionary = Context as IDictionary<string, object>;
			Model.Interaction = contextDictionary.TryGetValue("Interaction") as IInteractionOpenMedia;
		}

		public void Destroy()
		{
		}

		#endregion

		#region ICustomWorkItemView Members

		public ICustomWorkItemViewModel Model
		{
			get { return this.DataContext as ICustomWorkItemViewModel; }
			set { this.DataContext = value; }
		}

		#endregion
	}
}
