﻿using System;
using System.Windows.Controls;

namespace Genesyslab.Desktop.Modules.InteractionExtensionSample.MySample
{
	/// <summary>
	/// Interaction logic for MySampleView.xaml
	/// </summary>
	public partial class MySampleView : UserControl, IMySampleView
	{
		public MySampleView(IMySampleViewModel mySampleViewModel)
		{
			this.Model = mySampleViewModel;

			InitializeComponent();

			Width = Double.NaN;
			Height = Double.NaN;
		}

		#region IMySampleView Members

		/// <summary>
		/// Gets or sets the model.
		/// </summary>
		/// <value>The model.</value>
		public IMySampleViewModel Model
		{
			get { return this.DataContext as IMySampleViewModel; }
			set { this.DataContext = value; }
		}

		#endregion

		#region IView Members

		/// <summary>
		/// Gets or sets the context.
		/// </summary>
		/// <value>The context.</value>
		public object Context { get; set; }

		/// <summary>
		/// Creates this instance.
		/// </summary>
		public void Create()
		{
		}

		/// <summary>
		/// Destroys this instance.
		/// </summary>
		public void Destroy()
		{
		}

		#endregion

		private void Button_Click(object sender, System.Windows.RoutedEventArgs e)
		{
			Model.ResetCounter();
		}
	}
}
