﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Genesyslab.Desktop.Infrastructure;
using Microsoft.Practices.Unity;
using Genesyslab.Platform.Commons.Logging;
using Genesyslab.Desktop.Infrastructure.ViewManager;
using Genesyslab.Desktop.Infrastructure.Commands;
using Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ToolBarView;
using Genesyslab.Desktop.Modules.Core.Model.Interactions;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;
using Genesyslab.Desktop.Modules.CustomWorkItemSample.Windows.ContentView;
using Genesyslab.Desktop.Modules.Windows.Views.Interactions.BundleView;
using Genesyslab.Desktop.Modules.Windows.Interactions;

namespace Genesyslab.Desktop.Modules.CustomWorkItemSample
{
	class CustomWorkItemSampleModule : IModule
	{
		public static string MediaTypeModuleMedia="customworkitem";

		private readonly IUnityContainer container;
		private readonly ILogger log;
		IViewManager viewManager;

		public CustomWorkItemSampleModule(IUnityContainer container, ILogger log)
		{
			this.container = container;

			this.log = log.CreateChildLogger("CustomWorkItemSampleModule");

			this.log.Debug("CustomWorkItemSampleModule()");
		}

		public void Initialize()
		{
			log.Debug("Initialize()");

			try
			{
				viewManager = container.Resolve<IViewManager>();
				RegisterViewsAndServices();
				RegisterViewsWithRegions();
				RegisterCommands();
			}
			catch (Exception ex)
			{
				log.FatalError("Error during the module initialization: ",ex);
				throw (ex);
			}
		}

		protected void RegisterViewsAndServices()
		{
			log.Debug("RegisterViewsAndServices()");

			container.RegisterType<ICustomWorkItemToolBarViewModel, CustomWorkItemToolBarViewModel>();
			container.RegisterType<ICustomWorkItemToolBarView, CustomWorkItemToolBarView>();

			container.RegisterType<ICustomWorkItemViewModel, CustomWorkItemViewModel>();
			container.RegisterType<ICustomWorkItemView, CustomWorkItemView>();
		}

		void RegisterViewsWithRegions()
		{

			log.Debug("RegisterViewsWithRegions()");

			viewManager.AddViewsToRegion("CustomWorkItemToolBarRegion",new List<ViewActivator>()
				{	
					new ViewActivator() 
					{
						ViewType = typeof(ICustomWorkItemToolBarView), ActivateView = true, ViewName = "MyCustomWorkItemToolBarView", DynamicOnly = false, CreateNewRegionManager = true,
						Condition = delegate(ref object context)
						{
							IDictionary<string, object> contextDictionary = context as IDictionary<string, object>;
							if(contextDictionary.ContainsKey("Interaction"))
							{
								IInteractionOpenMedia interaction =  contextDictionary["Interaction"] as IInteractionOpenMedia;
								//IBundleView bundleView = contextDictionary.TryGetValue("BundleView") as IBundleView;


								if(interaction!=null)
								{
									if(interaction.MediaType== CustomWorkItemSampleModule.MediaTypeModuleMedia)
									{
										
									/*	//Remove View 
										viewManager.RemoveViewInRegion(bundleView,"InteractionsBundleRegion",interaction.InteractionId);

										//New View 
										object createdToolbarView = viewManager.InstantiateDynamicViewInRegion(bundleView, "InteractionsBundleRegion", "CustomWorkItemView", string.Format("{0}{1}",CustomWorkItemModule.MediaTypeModuleMedia,interaction.InteractionId),
										new Dictionary<string, object>(bundleView.Context as IDictionary<string, object>)
										{ 
											{ "Interaction", interaction }
										}).View;
									 */

										return true;
									}
								}
							}

							return false;
						}
					}
				}
			);


			viewManager.AddViewsToRegion("InteractionsBundleRegion", new List<ViewActivator>()
			{
				new	ViewActivator()
				{
					ViewType = typeof(ICustomWorkItemView), ActivateView = true, ViewName = "CustomWorkItemView", DynamicOnly = true, CreateNewRegionManager = true
				}
			});

			container.Resolve<IInteractionsWindowController>().InteractionViewCreated += new EventHandler<InteractionViewEventArgs>(CustomWorkItemModule_InteractionViewCreated);
		}

		void CustomWorkItemModule_InteractionViewCreated(object sender, InteractionViewEventArgs e)
		{

			if (e.Interaction != null)
			{
				IInteractionOpenMedia interactionOpenMedia = e.Interaction as IInteractionOpenMedia;

				if (interactionOpenMedia != null)
				{

					if (interactionOpenMedia.MediaType == CustomWorkItemSampleModule.MediaTypeModuleMedia)
					{

						//Remove View 
						viewManager.RemoveViewInRegion(e.BundleView, "InteractionsBundleRegion", interactionOpenMedia.InteractionId);

						//New View 
						object createdView = viewManager.InstantiateDynamicViewInRegion(e.BundleView, "InteractionsBundleRegion", "CustomWorkItemView", string.Format("{0}{1}", CustomWorkItemSampleModule.MediaTypeModuleMedia, interactionOpenMedia.InteractionId),
						new Dictionary<string, object>(e.Context as IDictionary<string, object>)).View;

						interactionOpenMedia.UserData["InteractionView"] = createdView;

					}
				}
			}
		}

		void RegisterCommands()
		{
			log.Debug("RegisterCommands()");

			ICommandManager commandManager = container.Resolve<ICommandManager>();

			commandManager.AddCommandToChainOfCommand("InteractionCustomWorkitemStopProcessing", new List<CommandActivator>() { new CommandActivator() { CommandType = typeof(CustomWorkitemStopProcessingCommand) , Name="StopProcessing" } });

		}
	}
}
