﻿using System.Windows;
using System.Windows.Input;
using System.Windows.Threading;
using Genesyslab.Desktop.Infrastructure.Theming;
using Genesyslab.Desktop.Modules.Core.InactivityTimeout;
using Genesyslab.Desktop.WPFCommon.Controls;
using Genesyslab.Platform.Commons.Logging;
using Microsoft.Practices.Composite.Events;
using Microsoft.Practices.Composite.Wpf.Events;
using Microsoft.Practices.Unity;

namespace Genesyslab.Desktop.Modules.InteractionManagementExtensionSample
{
    /// <summary>
    /// Interaction logic for ChooseReasonWindow.xaml
    /// </summary>
    public partial class ChooseReasonWindow : CustomWindow, IChooseReasonWindow
    {
        readonly ILogger log;
        readonly IUnityContainer container;
        readonly IEventAggregator eventAggregator;

        public ChooseReasonWindow(IUnityContainer container, IEventAggregator eventAggregator, IChooseReasonWindowModel viewModel, ILogger log)
        {
            this.log = log.CreateChildLogger("ChooseReasonWindow");
            this.container = container;
            this.eventAggregator = eventAggregator;
            this.Model = viewModel;

            InitializeComponent();
        }

        #region IView Members

        public object Context { get; set; }

        public void Create()
        {
            container.Resolve<IThemeManager>().Register(this);
            if (eventAggregator != null)
                eventAggregator.GetEvent<InactivityDetectedEvent>().Subscribe(InactivityDetectedHandler, ThreadOption.PublisherThread, true);
        }

        public void Destroy()
        {
            container.Resolve<IThemeManager>().Unregister(this);
            if (eventAggregator != null)
                eventAggregator.GetEvent<InactivityDetectedEvent>().Unsubscribe(InactivityDetectedHandler);
            Model = null;
        }

        #endregion

        #region IChooseReasonWindow Members

        public IChooseReasonWindowModel Model
        {
            get { return this.DataContext as IChooseReasonWindowModel; }
            set { this.DataContext = value; }
        }

        #endregion

        #region Authentication

        private delegate void CloseWindowDelegate();

        void CloseWindow()
        {
            try
            {
                if (Application.Current != null && Application.Current.Dispatcher != null && !Application.Current.Dispatcher.CheckAccess())
                    Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Send, new CloseWindowDelegate(CloseWindow));
                else
                    this.Close();
            }
            catch
            {
            }
        }

        void InactivityDetectedHandler(object o)
        {
            CloseWindow();
        }

        #endregion

        #region UIControls event handlers

        private void TitleBar_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            this.DragMove();
        }

        private void ButtonClose_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            Model.CancelCommand.Execute(this);
        }

        private void radioButtonDelete_Checked(object sender, RoutedEventArgs e)
        {
            Model.SetMarkDoneReason("DeleteConversation");
        }

        private void radioButtonRework_Checked(object sender, RoutedEventArgs e)
        {
            Model.SetMarkDoneReason("ReworkReply");
        }

        private void radioButtonReassigned_Checked(object sender, RoutedEventArgs e)
        {
            Model.SetMarkDoneReason("ReassignedToAnotherAgent");
        }

        #endregion
    }
}
