﻿using System.Collections.Generic;
using System.Drawing;
using System.Windows;
using System.Windows.Media;
using Genesyslab.Desktop.Infrastructure;
using Genesyslab.Desktop.Infrastructure.Commands;
using Genesyslab.Desktop.Infrastructure.ViewManager;
using Genesyslab.Desktop.Modules.Core.Model.Interactions;
using Genesyslab.Desktop.Modules.Windows.Interactions;
using Genesyslab.Platform.Commons.Logging;
using Microsoft.Practices.Unity;

namespace Genesyslab.Desktop.Modules.InteractionManagementExtensionSample
{
    class InteractionManagementControlExtensionSample : InteractionControlExtension, IInteractionControlExtension
    {
        readonly ILogger log;
        readonly ICommandManager commandManager;
        readonly IViewManager viewManager;

        public InteractionManagementControlExtensionSample(IUnityContainer container, ILogger logger, ICommandManager commandManager, IViewManager viewManager)
			: base(container)
		{
            log = logger.CreateChildLogger("InteractionManagementControlExtensionSample");
            log.Debug("InteractionManagementControlExtensionSample()");
            
            this.commandManager = commandManager;
            this.viewManager = viewManager;
        }

        #region IInteractionControlExtension Members

        public bool CanCreateInteractionControlNow(Genesyslab.Desktop.Modules.Core.Model.Interactions.IInteraction interaction)
        {
            return false;
        }

        public bool CreateInteractionControl(IInteraction interaction, object context)
        {
            return false;
        }

        public void RemoveInteractionControl(IInteraction interaction, object context)
        {
        }

        public ImageSource GetInteractionMediaIcon(IInteraction interaction, InteractionMediaIconSource source)
        {
            return null;
        }

        public ImageSource GetInteractionSilentMonitoringMediaIcon(IInteraction interaction)
        {
            return null;
        }

        public Icon GetInteractionMediaDrawingIcon(IInteraction interaction)
        {
            return null;
        }

        public string GetInteractionStateLabel(IInteraction interaction, BundleParty bundleParty)
        {
            return "";
        }

        public IList<RequestedAction> RequestActions(string capacity, ActionTarget target, object context)
        {
			Dictionary<string, object> contextDictionary = context as Dictionary<string, object>;

			List<RequestedAction> result = new List<RequestedAction>();
            if (contextDictionary != null)
            {
                switch (target)
                {
                    case ActionTarget.InteractionActionFromWorkbin:
                        {
                            int nbInteractions = 0;
                            List<string> interactionsIdsList = new List<string>();
                            List<string> interactionsMediaTypesList = new List<string>();
                            List<string> interactionsParentIdsList = new List<string>();
                            if (contextDictionary.ContainsKey("nbInteractions"))
                            {
                                nbInteractions = (int)contextDictionary.TryGetValue("nbInteractions");
                                for (int i = 0; i < nbInteractions; i++)
                                {
                                    interactionsIdsList.Add(contextDictionary.TryGetValue("interactionId" + i) as string);
                                    interactionsMediaTypesList.Add(contextDictionary.TryGetValue("mediaType" + i) as string);
                                    interactionsParentIdsList.Add(contextDictionary.TryGetValue("parentId" + i) as string);
                                }
                            }
                            else
                            {
                                nbInteractions = 1;
                                interactionsIdsList.Add(contextDictionary.TryGetValue("interactionId") as string);
                                interactionsMediaTypesList.Add(contextDictionary.TryGetValue("mediaType") as string);
                                interactionsParentIdsList.Add(contextDictionary.TryGetValue("parentId") as string);
                            }
                            if ( (interactionsIdsList.Count <= 0) || (interactionsMediaTypesList.Count <= 0) )
                                break;

                            string interactionId = interactionsIdsList[0];
                            if (string.IsNullOrEmpty(interactionId))
                                break;

                            string mediaType = interactionsMediaTypesList[0];
                            if (string.IsNullOrEmpty(mediaType))
                                break;

                            string parentId = interactionsParentIdsList[0];

                            string workbinId = contextDictionary.TryGetValue("workbinId") as string;
                            string workbinParam = contextDictionary.TryGetValue("workbinParam") as string;
                            RequestedAction requestedAction = null;

                            // Mark Done with Reason...
                            requestedAction = new RequestedAction();
                            requestedAction.Type = mediaType;
                            requestedAction.NameId = "InteractionManagement.MenuItemInteractionActionMarkDoneWithReason";
                            requestedAction.ImageId = "InteractionManagement.MenuItemInteractionActionMarkDoneWithReason";
                            requestedAction.TooltipId = "InteractionManagement.MenuItemInteractionActionMarkDoneWithReason";
                            requestedAction.Order = 1000;
                            requestedAction.IsPossible = true;
                            requestedAction.IsPossibleWithoutMedia = true;
                            requestedAction.IsPossibleOnMultipleInteractions = true;
                            requestedAction.BasicName = "MarkDoneWithReason";
                            Dictionary<string, object> editCaseDataParameters = new Dictionary<string, object>();
                            requestedAction.Parameters = editCaseDataParameters;
                            requestedAction.Action = delegate()
                            {
                                IChooseReasonWindow chooseReasonWindow = viewManager.InstantiateShell("ChooseReasonRegion", "ChooseReasonView", "chooseReason", null).View as IChooseReasonWindow;

                                if ((chooseReasonWindow != null) && (chooseReasonWindow.Model != null))
                                {
                                    chooseReasonWindow.Model.InteractionIds = interactionsIdsList;
                                    //chooseReasonWindow.Model.InteractionMediaTypes = interactionsMediaTypesList;
                                    //chooseReasonWindow.Model.WorkbinsView = contextDictionary.TryGetValue("WorkbinsView");
                                    Window window = chooseReasonWindow as Window;
                                    if (window != null)
                                    {
                                        window.WindowStartupLocation = WindowStartupLocation.CenterScreen;
                                        window.Owner = Application.Current.MainWindow;
                                        window.ShowDialog();
                                    }
                                }
                                viewManager.RemoveShell("chooseReason");
                            };
                            result.Add(requestedAction);

                            break;
                        }
                }
            }

            return result;
        }

        public string BeforeCloseCommand
        {
            get { return ""; }
        }

        public string CloseInteractionCommand
        {
            get { return ""; }
        }

        public string PossibleToCloseInteractionCommand
        {
            get { return ""; }
        }

        public void UpdateCaseViewContextBeforeCreateCaseView(object context, IInteraction interaction)
        {
        }

        public IList<string> SupportedMedia
        {
            get { return new List<string> { "*" }; }
        }

        #endregion
    }
}
