﻿using System.Collections.Generic;
using Genesyslab.Desktop.Infrastructure.Commands;
using Genesyslab.Desktop.Infrastructure.DependencyInjection;
using Genesyslab.Desktop.Modules.Core.Utils.Context;
using Genesyslab.Desktop.Modules.OpenMedia.Model.Interactions;
using Genesyslab.Desktop.WPFCommon;
using Genesyslab.Enterprise.Model.Envelope;
using Genesyslab.Enterprise.Model.Interaction;
using Genesyslab.Platform.Commons.Logging;

namespace Genesyslab.Desktop.Modules.InteractionManagementExtensionSample
{
    class InteractionManagerInteractionExtensionSample : IInteractionManagerInteractionOpenMediaExtension
    {
        readonly IObjectContainer container;
        readonly ILogger log;

        public InteractionManagerInteractionExtensionSample(IObjectContainer container, ILogger log)
        {
            this.container = container;
            this.log = log;
        }

        #region IInteractionManagerInteractionOpenMediaExtension Members

        public IInteractionOpenMedia CreateInteraction(IInteractionType interactionType)
        {
            return null;
        }

        public IInteractionOpenMedia CreateInteraction(IInteractionType interactionType, object context)
        {
            return null;
        }

        public bool SilentWorkflowEvent(IEnvelope<IInteraction> tsp)
        {
            if (tsp.Header != null && !string.IsNullOrEmpty(tsp.Header.CorrelatorData))
            {
                IContextManager contextManager = container.Resolve<IContextManager>();
                string silentWorkfowContextSample = contextManager.GetContext(tsp.Header.CorrelatorData, "SilentWorkflowContextSample.NextCommand") as string;
                if (silentWorkfowContextSample != null)
                {
                    if (silentWorkfowContextSample == "SetReasonStopProcessing")
                    {
                        // Interaction has been pulled to set a Reason and then to be StopProcessing...
                        this.log.Debug("[.SilentWorkflow.] SilentWorkflowEvent... SetReasonStopProcessing : Interaction has been pulled to set a Reason and then to be StopProcessing...");

                        string reason = contextManager.GetContext(tsp.Header.CorrelatorData, "MarkDoneReason") as string;
                        //object workbinsView = contextManager.GetContext(tsp.Header.CorrelatorData, "WorkbinsView");

                        IDictionary<string, object> parameters = new Dictionary<string, object>();
                        parameters.Add("CommandParameter", tsp.Body);
                        parameters.Add("MarkDoneReason", reason);
                        //parameters.Add("WorkbinsView", workbinsView);
                        parameters = MultipleInteractionsCommandContext.AddMultipleInteractionsCommandContextIdToCommandParameters(contextManager, tsp.Header.CorrelatorData, parameters);

                        ICommandManager commandManager = container.Resolve<ICommandManager>();
                        IChainOfCommand setAttachedDataAndPutBackCommand = commandManager.GetChainOfCommandByName("SetReasonAndStopProcessing");
                        Utils.ExecuteAsynchronousCommand(setAttachedDataAndPutBackCommand, parameters, null);

                        contextManager.RemoveContext(tsp.Header.CorrelatorData, "SilentWorkflowContextSample.NextCommand");
                        contextManager.RemoveContext(tsp.Header.CorrelatorData, "MarkDoneReason");

                        return true;
                    }
                }
            }

            return false;
        }

        #endregion
    }
}
