""" This module initializes global variables
"""
import os

# pylint: disable=W0604
# pylint: disable=C0103

global cfg_file
global crypto_key
global tmp_folder


# Retention period for recording storage metric cached data files in days
retention_period = 3


# cfg_mode: file
cfg_mode = 'file'
cfg_file = '/genesys/config/config.json'

# Used for premise in tenant
overwrite = False

tmp_folder = './temp'

# show the execution plan of a statement
SHOW_EXECUTION_PLAN = True
EXECUTION_PLAN_DIR = '/genesys/log/execution_plan'

# LOGGING CONFIGURATION

LOG_FILE_MAIN = '/genesys/log/bds.log'
LOG_FILE_STATS = '/genesys/log/bds_stats.log'
LOG_FILE_AUDIT = '/genesys/log/bds_audit.log'
LOG_FILE_MIGRATE = '/genesys/log/bds_migrate.log'
LOG_LEVEL = 'DEBUG'
LOG_DAYS_TO_KEEP = 30

BUSINESS_UNITS_NAMES_BLACKLIST = [
    'agents', 'dns', 'persons', 'campaigns', 'switches',
    'configurations', 'agent logins', 'campaign groups'
    ]

# timeout for DB connections and requests. Applicable only to PostgreSQL and FreeTDS connections
DB_REQUEST_TIMEOUT = 60 * 60 * 2  # 2 hours

# we must check sql state code and error message to ensure that Exception indicates lack of required column
# keys of dictionary are SQLSTATE codes which may indicate column error and  values are lists of parts of possible
# error messages returned by db driver to check if error is about missing column
DB_INVALID_COLUMN_SQLSTATES = {
    '42S22': ['Invalid column name ', 'ORA-00904'],
    '42S02': ['Invalid object name ', 'ORA-00942'],
    '42P01': ['[42P01] ERROR: relation '],
    '42703': ['[42703] ERROR: column '],
}

# Maximum duration of the call in seconds
max_call_duration = 60 * 60 * 3
sbc_brs_log_file = '/genesys/log/sbc_brs_comp.log'
sbc_brs_csv_summary_result = '/genesys/log/brs_sbc_summary.csv'
sbc_brs_csv_missing_brs_result = '/genesys/log/present_sbc_missing_brs.csv'
sbc_brs_csv_missing_sbc_result = '/genesys/log/present_brs_missing_sbc.csv'

config_snapshotter_log_file = '/genesys/log/brs_config_snapshotter.log'
config_snapshotter_result_dir = '/genesys/log'

statistic_log_file = '/genesys/log/statistic.log'
statistic_result_dir = '/genesys/log/statistic'

# Monitoring system notifications
cmd_heartbeat = ' '
cmd_error = ' '

# Folder to save a list of unique agents for each enabled and concurrent agents metric run
enabled_seats_detailed_dir = '/genesys/data/enabled_seats_detailed_reports'
concurrent_seats_detailed_dir = '/genesys/data/concurrent_seats_detailed_reports'


# Since simple assignment in python is atomic
# we don't need to use any lock here.
# Since we don't want to use
# some complicate logic based on OOP (at least for now)
# or signal processing, let it be just another global variable
# which utils.log changes when get ERROR/CRITICAL and
# dispatcher uses to determine the return code.
# Looks good until someone invent something better
get_error_or_critical = False
critical_errors = 0
regular_errors = 0

# How many times peak should be more than
# average value for considering this value as suspicious
PEAK_VOLUME_COEFFICIENT = 2
MULTICLOUD_GVP_RETENTION_PERIOD = 15
# Check data availability in GIM DB
check_gim_data_availability = False

# brs/crypto
crypto_key_path = '/genesys/etc/crypto/key'
is_fedramp = False

local_dir_for_tokens = '/genesys/etc/tokens'
local_dir_preshared_key = '/genesys/etc/preshared_keys'

# Do not edit below
crypto_key = None
cfg_server_session = None
logger = None

freezer = None

# FEDRAMP Gap 6
# list of item names that could possibly contain sensitive data
SENSITIVE_ITEMS = [
    'login', 'username', 'user_name', 'userid', 'user_id', '_username', 'usernames'
    'employeeid', 'employee_id', 'agent_first_name', 'agent_last_name',
    # 'agentid', 'agent_id',
    'password',
    'firstname', 'first_name', 'name'
    'lastname', 'last_name',
    'email', 'email_address',
    'ani', 'anis', 'dnis', 'dni',
    ]

MAX_THREADS = 1

# import a local settings
try:
    from .local_settings import *
except ImportError:
    pass

ENABLE_BOTO_LOG = False
LOG_FILE_BOTO = '/genesys/log/boto_debug.log'
MAX_BYTES = 20000000
FILE_COUNT = 20