/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/
/***
Agent Interaction Java API 7.5 Code Examples
***/
package agentserver;

/**
 * Agent Server Listener. 
 * Client applications instanciate this class to pull events from Agent Server.
 * When Agent Server gets events, it notifies this class by calling the {@link #handleEvent(String)} method.
 * @version 7.5.001.00
 */
public class AgentServerListener {

	/** Indicates whether events are available. */
	public boolean gotEvent;
	/** Concatenated event strings. */
	String eventMsg;
	/**
	 * Creates a listener.
	 */
	public AgentServerListener() {
		gotEvent=false;
		eventMsg= null;
	}
	
	/**
	 * Signals an event to the listener.
	 */
	public void handleEvent(String msg)
	{
		// If the previous event was not pulled, the new message is appended to the previous msg.
		if(gotEvent)
		{
			eventMsg = eventMsg+"<br>"+msg;
		}else{
			gotEvent = true;
			eventMsg = msg;
		}
		
	}
	/**
	 * true if Agent Server got an event.
	 * @return
	 */
	public String getEvent()
	{
		String toBeReturned = eventMsg;
		eventMsg = null;
		if(gotEvent)
		{
			gotEvent = false;
		
		}
		
		return toBeReturned;
	}


}
