/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
 =====================================================================*/
package agent.interaction.samples.outbound;
import agent.interaction.samples.OpenMediaTableModel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 * This class creates a graphical user interface that is used by the Agent Outbound Code example.
 * <br>All of the widgets needed by the code example are created before the GUI is
 * displayed, but they are enabled if they are needed by the sample that
 * is being run.
 * <br>The AgentOutboundExample class does not deal with GUI components, 
 * except for enabling/disabling them, or adding actions to buttons. It uses the public method of this class to update tables and tree contents.
 * 
 * @version 7.6.000.00
 */
class AgentOutboundGui {

	static Font BOLD = new Font("", Font.BOLD, 10);

	static Color ACTIVE_BACKGROUND_COLOR = new Color(204, 255, 204);
	static Color ACTIVE_BUTTON_COLOR = new Color(204, 255, 204);


	JFrame mainGuiWindow;
	private Container contentPane;
	private GridBagConstraints gridBagConstraints = new GridBagConstraints();

	JButton loginButton;
	JButton logoutButton;
	JButton readyButton;
	JButton notReadyButton;
	JButton afterCallWorkButton;
	JTextPane logAreaTextPane;
	JPanel masterLoginPanel;
	JTabbedPane mainTabbedPane;

	Calendar calendar = new GregorianCalendar();
	DateFormat timestamp = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss:SSS");

	//--Place Table
	OpenMediaTableModel placeTableModel;
	JScrollPane placeTableScrollPane;

	JLabel loginNameLabel;
	JLabel dnLabel;
	JLabel dnStatusLabel;
	JLabel agentPlaceLabel;
	JLabel agentQueueLabel;
	JLabel interactionDnisLabel;
	JLabel interactionAniLabel;
	JLabel interactionSubjectLabel;
	JLabel interactionPartiesLabel;

	private JPanel masterVoicePanel;
	JPanel simpleVoiceInteractionPanel;
	JLabel simpleVoiceTargetDnLabel;
	JTextField simpleVoiceTargetDnTextField;
	JLabel multipartyVoiceTargetDnLabel;
	// Outbound widgets
	JTabbedPane outboundTabbedPane;

	/// campaign widgets
	public JComboBox campaignComboBox;
	public JLabel campaignModeLabel;
	public JLabel campaignStatusLabel;
	public JTextArea campaignDescriptionTextArea;
	public JButton requestPreviewRecordButton;
	public JButton startPreviewButton;
	public JButton stopPreviewButton;


	// current outbound record panel
	public JButton cancelCurrentRecordButton;
	public JButton doNotCallCurrentRecordButton;
	public JButton rescheduleCurrentRecordButton;
	public JButton updateFromOCSCurrentRecordButton;
	public JLabel currentRecordStatusLabel;
	public JLabel callResultLabel;
	public JComboBox callResultComboBox;
	public JLabel phoneLabel,dailyFromLabel,dailyTillLabel;
	public JLabel phoneTypeLabel;
	public JComboBox phoneTypeComboBox;
	JTree customFieldsTree;
	JScrollPane customFieldsScrollPane ;
	TitledBorder customFieldsTreeTitledBorder = BorderFactory
	.createTitledBorder(" Custom Fields ");
	
	/// chain widgets
	public JButton cancelChainButton;
	JLabel chainTreatmentLabel;
	public JComboBox chainTreatmentComboBox;
	public JButton doNotCallChainButton;
	public JButton closeChainButton;
	public JButton rejectChainButton;
	public JLabel chainIsScheduledLabel ;
	public JButton requestRecordChainButton;
	public JButton markProcessedChainButton;
	JLabel recordsListLabel ; 
	public JComboBox recordsComboBox;
	public OpenMediaTableModel chainedRecordsTableModel;
	JTable chainedRecordsTable;

	JButton answerButton;
	JButton doneButton;
	JButton releaseButton;
	JButton makeCallButton;
	JButton holdButton;
	JButton retrieveButton;
	JButton conferenceButton;
	JButton transferButton;
	JButton completeButton;



	/// Ixn Table
	OpenMediaTableModel ixnTableModel;
	JScrollPane ixnTableScrollPane;
	public JTable ixnTable;

	JTree ixnPropertyTree;
	JScrollPane ixnPropertyScrollPane ;
	TitledBorder selectedIxnTreeTitledBorder = BorderFactory
	.createTitledBorder(" Interaction properties");
	JLabel propNameLabel;
	public JTextField propNameTextField;
	JLabel propValueLabel;
	public JTextField propValueTextField;  


	/**
	 * Constructor.
	 * @param windowTitle
	 */
	public AgentOutboundGui(String windowTitle) {
		createGui(windowTitle);
	}


	/*
	 * This method sets the Java look and feel to the look and feel of the
	 * platform the example is being run on.
	 *
	 * Then it creates the main window (JFrame) and content pane being used by
	 * the GUI. After that, it calls methods that create the various components
	 * of the user interface.
	 *
	 * @param windowTitle
	 *            The title of the GUI window for the example that is currently
	 *            being run.
	 */
	private void createGui(String windowTitle) {

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception exception) {
			exception.printStackTrace();
		}

		// Create the main window
		mainGuiWindow = new JFrame(windowTitle);
		mainGuiWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		contentPane = mainGuiWindow.getContentPane();
		
		contentPane.setLayout(new GridBagLayout());
		GridBagConstraints constr = new GridBagConstraints();
		constr.fill = GridBagConstraints.BOTH;
		
		
		//[0,0 - 3]
		constr.gridx=0;
		constr.gridy=0;
		constr.gridwidth =3;		
		constr.gridheight = 1;
		contentPane.add(createIxnTable(), constr);
		
		//[0,1 - 3]
		constr.gridx=0;
		constr.gridy=1;
		constr.gridwidth =3;	
		contentPane.add(createMainPanels (),constr);
		
		//[0,2 - 2]
		constr.gridx=0;
		constr.gridy=2;
		constr.gridwidth =2;
		contentPane.add(createChainPanel(),constr);

		//[3,2 - 1]
		constr.gridx=2;
		constr.gridy=2;
		constr.gridwidth =1;
		contentPane.add(createCurrentRecordPanel(), constr);
		
		
	}


	/**
	 * Creates the table of interactions.
	 * @return
	 */
	private JScrollPane createIxnTable()
	{
//		Add a status table
		ixnTableModel = new OpenMediaTableModel();
		ixnTableModel.colName0 = "Interaction";
		ixnTableModel.colName1 = "Status";
		ixnTableModel.colName2 = "Type";
		ixnTableModel.colName3 = "Subject";
		ixnTableModel.NUM_COLUMNS = 4;
		ixnTableModel.START_NUM_ROWS =4;
		ixnTable = new JTable(ixnTableModel);

		ixnTable.setSelectionBackground(new Color(2,131,212));
		ixnTable.setSelectionForeground(new Color(255,255,255));


		ixnTableScrollPane = new JScrollPane(ixnTable);
		//ixnTableScrollPane.setBorder(BorderFactory.createTitledBorder("Interactions"));
		ixnTableScrollPane.setBorder(BorderFactory.createEtchedBorder());
		ixnTable.setPreferredScrollableViewportSize(new Dimension(300, 80));
		ixnTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		ixnTable.setToolTipText("Select an interaction by clicking a line in this table.");

		return ixnTableScrollPane;

	}

	/**
	 * Creates the property tree for the interaction selected in the interaction table.
	 * @return the created scrollpane.
	 */
	private JScrollPane createIxnPropertyTree()
	{
		ixnPropertyTree = new JTree(new Vector());
		ixnPropertyScrollPane = new JScrollPane(ixnPropertyTree);
		ixnPropertyScrollPane.setPreferredSize(new Dimension(250, 150));
		ixnPropertyScrollPane.setMinimumSize(new Dimension(200, 150));
		ixnPropertyScrollPane.setBorder(selectedIxnTreeTitledBorder);

		return ixnPropertyScrollPane;
	}  

	/**
	 * Creates the custom field tree for the record displayed.
	 * @return the created scrollpane.
	 */
	private JScrollPane createCustomFieldsTree()
	{		
		customFieldsTree = new JTree(new Vector());
		customFieldsScrollPane = new JScrollPane(customFieldsTree);
		customFieldsScrollPane.setPreferredSize(new Dimension(250, 150));
		customFieldsScrollPane.setMinimumSize(new Dimension(200, 150));
		customFieldsScrollPane.setBorder(customFieldsTreeTitledBorder);

		return customFieldsScrollPane;
	}  
	/*
	 * This method creates buttons that log an agent in and out, and that set
	 * the agent in a state of either ready, not ready or after call waiting.
	 *
	 * The buttons are used by all of the Agent Interaction (Java) code
	 * examples.
	 */
	private JPanel createLoginPanel() {

		JPanel masterLoginPanel = new JPanel();
		masterLoginPanel.setLayout(new GridBagLayout());

		GridBagConstraints constr = new GridBagConstraints();
		// Add a "Log in" button
		loginButton = new JButton("Log In");
		constr.gridx = 0;
		constr.gridy =0;
		constr.fill = GridBagConstraints.BOTH;
		masterLoginPanel.add(loginButton,constr);


		// Add a "Log out" button
		logoutButton = new JButton("Log Out");
		constr.gridx = 0;
		constr.gridy =1;
		masterLoginPanel.add(logoutButton,constr);

		// Add a Ready button
		readyButton = new JButton("Ready");
		constr.gridx = 0;
		constr.gridy =2;
		masterLoginPanel.add(readyButton,constr);

		// Add a Not Ready button
		notReadyButton = new JButton("Not Ready");
		constr.gridx = 0;
		constr.gridy =3;
		constr.gridheight = 1;
		constr.gridwidth = 1;
		masterLoginPanel.add(notReadyButton,constr);

		// Add an After Call Work button
		afterCallWorkButton = new JButton("ACW");
		constr.gridx = 0;
		constr.gridy =4;
		masterLoginPanel.add(afterCallWorkButton,constr);
		
		constr.gridx =1;
		constr.gridy =0;
		constr.gridwidth=1;
		masterLoginPanel.add(Box.createRigidArea(new Dimension(5,0)),constr); 
		
		// Add info
		dnStatusLabel = new JLabel();
		constr.gridx =2;
		constr.gridy = 0;
		masterLoginPanel.add(dnStatusLabel, constr);
	
		agentPlaceLabel = new JLabel();
		constr.gridx =2;
		constr.gridy = 1;
		masterLoginPanel.add(agentPlaceLabel, constr);

		
		
		loginNameLabel = new JLabel();
		constr.gridx = 2;
		constr.gridy = 2;
		masterLoginPanel.add(loginNameLabel, constr);

		// Build a label for the DN status.
		dnLabel = new JLabel();
		constr.gridx =2;
		constr.gridy = 3;
		masterLoginPanel.add(dnLabel, constr);
		

		agentQueueLabel = new JLabel();
		constr.gridx =2;
		constr.gridy = 4;
		masterLoginPanel.add(agentQueueLabel, constr);
		
		constr.gridx =2;
		constr.gridy =5;
		constr.gridwidth=1;
		masterLoginPanel.add(Box.createRigidArea(new Dimension(200,0)),constr); 
		
		constr.gridx = 3;
		constr.gridy =0; 
		constr.gridheight = 6;
		constr.gridwidth = 4;
		masterLoginPanel.add(createCampaignPanel(),constr);



		return masterLoginPanel;
	}

	/*
	 * This method creates a panel that contains two panels used for voice
	 * interactions.
	 *
	 * The first panel holds widgets used for simple voice interactions, such as
	 * making and answering a call, putting a call on hold, and releasing the
	 * call. This panel is used by both the SimpleVoiceInteraction and
	 * MultipartyVoiceInteraction code examples.
	 *
	 * The other panel is used for multiparty voice interactions and contains
	 * widgets used to transfer a call and set up a three-way conference call.
	 */
	private JTabbedPane createMainPanels() {
		JTabbedPane mainTabbedPane = new JTabbedPane();

		//////////////Login ///////////////////////
		masterLoginPanel = createLoginPanel();
		mainTabbedPane.addTab("Place", null,
				masterLoginPanel, "Manage Place");

		/////////////// VOICE ///////////////////////////////////////////////
		masterVoicePanel = createVoiceIxnPanel();
		mainTabbedPane.addTab("Voice", null,
				masterVoicePanel, "Manage voice interactions");
		return mainTabbedPane;
	}



	/**
	 * Creates the panel which manages the voice interaction selected in the interaction table.
	 * @return
	 */

	private JPanel createVoiceIxnPanel()
	{
		// Create a simple voice interaction panel

		JPanel voiceIxnPanel = new JPanel();
		voiceIxnPanel.setLayout(new GridBagLayout());

		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = GridBagConstraints.BOTH;

		simpleVoiceTargetDnLabel = new JLabel("New Party DN: ");
		voiceIxnPanel.add(simpleVoiceTargetDnLabel,gridBagConstraints);

		simpleVoiceTargetDnTextField = new JTextField(20);
		simpleVoiceTargetDnTextField.setEditable(true);
		simpleVoiceTargetDnTextField.setText(" ");
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.weightx = 2.0;
		gridBagConstraints.gridwidth = 2;
		voiceIxnPanel.add(simpleVoiceTargetDnTextField,gridBagConstraints);


		answerButton = new JButton("Answer");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.gridwidth = 1;
		voiceIxnPanel.add(answerButton,gridBagConstraints);

		releaseButton = new JButton("Release");
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		voiceIxnPanel.add(releaseButton,gridBagConstraints);

		doneButton = new JButton("Done");
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 1;
		voiceIxnPanel.add(doneButton,gridBagConstraints);

		makeCallButton = new JButton("Make Call");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		voiceIxnPanel.add(makeCallButton,gridBagConstraints);

		holdButton = new JButton("Hold");
		gridBagConstraints.gridx =1;
		gridBagConstraints.gridy = 2;
		voiceIxnPanel.add(holdButton,gridBagConstraints);

		retrieveButton = new JButton("Retrieve");
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy =2;
		voiceIxnPanel.add(retrieveButton,gridBagConstraints);

		answerButton.setEnabled(false);
		makeCallButton.setEnabled(false);
		releaseButton.setEnabled(false);
		doneButton.setEnabled(false);
		holdButton.setEnabled(false);
		retrieveButton.setEnabled(false);



		/// INFORMATION ABOUT CALL

		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3; 
		gridBagConstraints.weightx = 2.0;
		gridBagConstraints.gridwidth = 3;
		JPanel interactionInfoPanel = createInteractionInfoPanel();

		voiceIxnPanel.add(interactionInfoPanel, gridBagConstraints);

		gridBagConstraints.gridx =0;
		gridBagConstraints.gridy =4; 
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.gridwidth = 1;
		voiceIxnPanel.add(Box.createRigidArea(new Dimension(5,5)),gridBagConstraints);


		gridBagConstraints.gridx =4;
		gridBagConstraints.gridy =0; 
		gridBagConstraints.weighty = 3.0;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.gridheight = 7;
		voiceIxnPanel.add(createIxnPropertyTree(),gridBagConstraints);

		return voiceIxnPanel;
	}
	
	private JPanel createInteractionInfoPanel() {
		JPanel interactionInfoPanel = new JPanel();
		interactionInfoPanel.setLayout(new GridLayout(0, 1, 0, 1));
		interactionInfoPanel.setBorder(BorderFactory
				.createTitledBorder("Interaction Information"));
		interactionInfoPanel.setMaximumSize(new Dimension(180, 150));
		interactionDnisLabel = new JLabel("DNIS: ");
		interactionInfoPanel.add(interactionDnisLabel);

		interactionAniLabel = new JLabel("ANI: ");
		interactionInfoPanel.add(interactionAniLabel);

		interactionSubjectLabel = new JLabel("Subject: ");
		interactionInfoPanel.add(interactionSubjectLabel);

		interactionPartiesLabel = new JLabel("Parties: ");
		interactionInfoPanel.add(interactionPartiesLabel);

		return interactionInfoPanel;
	}

	///////////////////// TREES MANAGEMENT /////////////////////////////
	/**
	 * Creates a tree node corresponding to a map of data.
	 */
	private void setMapCategory(DefaultMutableTreeNode category, Map pairs )
	{
		if(pairs != null)
		{
			Iterator itKeys = pairs.keySet().iterator();
			Iterator itValues = pairs.values().iterator();

			while(itKeys.hasNext())
			{
				String key = itKeys.next().toString();
				Object val = itValues.next();
				if(val ==null || val instanceof String)
				{
					String text = key + " = " + val;
					DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(text);
					category.add(leaf);
				}
				else if (val !=null && val instanceof Map)
				{
					DefaultMutableTreeNode node = new DefaultMutableTreeNode(key);
					setMapCategory(node, (Map) val);
					category.add(node);
				}					
			}
		}
	}
	/**
	 * Expands a tree node.
	 */
	private void expandAll(JTree tree, TreePath parent, boolean expand) {
		// Traverse children
		TreeNode node = (TreeNode)parent.getLastPathComponent();
		if (node.getChildCount() >= 0) {
			for (Enumeration e=node.children(); e.hasMoreElements(); ) {
				TreeNode n = (TreeNode)e.nextElement();
				TreePath path = parent.pathByAddingChild(n);
				expandAll(tree, path, expand);
			}
		}

		// Expansion or collapse must be done bottom-up
		if (expand) {
			tree.expandPath(parent);
		} else {
			tree.collapsePath(parent);
		}
	}
	/**
	 * Updates a tree with data to display.
	 */
	public void switchPropertyTree(String treeName, Map data){		

		DefaultMutableTreeNode top =
		//	new DefaultMutableTreeNode("Properties");
			new DefaultMutableTreeNode(treeName);
		
		if(data!=null)
		{

			Iterator itCategory = data.keySet().iterator();
			Iterator itMapCategories = data.values().iterator();

			while(itCategory.hasNext())
			{
				String categoryName = (String) itCategory.next();
				DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(categoryName);
				Object nodeValue =  itMapCategories.next();
				try
				{
					Map categoryPairs = null;
					if(nodeValue instanceof String)
					{
						categoryNode = new DefaultMutableTreeNode(categoryName+" = "+ nodeValue.toString());
					}else if(nodeValue instanceof Integer)
					{
						categoryNode = new DefaultMutableTreeNode(categoryName+" = "+ ((Integer) nodeValue).toString());

					}else if(nodeValue instanceof ArrayList )
					{
						categoryNode = new DefaultMutableTreeNode(categoryName+" = "+ ((ArrayList) nodeValue).toString());

					}
					else
					{
						categoryPairs = (Map) nodeValue ;
					}					
					setMapCategory(categoryNode, categoryPairs);
				}catch(Exception __e)
				{
					categoryNode = new DefaultMutableTreeNode(categoryName+" = " +nodeValue.toString());

				}
				top.add(categoryNode);
			}

			if(treeName.equals("Interaction properties"))
			{
				this.ixnPropertyTree.setModel(new DefaultTreeModel(top));
				TreeNode root = (TreeNode)ixnPropertyTree.getModel().getRoot();
				// Traverse tree from root
				expandAll(ixnPropertyTree, new TreePath(root), true);
			}else
			{
				this.customFieldsTree.setModel(new DefaultTreeModel(top));
				TreeNode root = (TreeNode)customFieldsTree.getModel().getRoot();
				// Traverse tree from root
				expandAll(customFieldsTree, new TreePath(root), true);
			}
		}
	}


	/**
	 * Clears one of the property trees.
	 */
	public void clearProperties(String name){
		DefaultMutableTreeNode top =
			new DefaultMutableTreeNode(name );
		if(name.equals("Interaction properties"))
		this.ixnPropertyTree.setModel(new DefaultTreeModel(top));
		else
			this.customFieldsTree.setModel(new DefaultTreeModel(top));

	}

	////////////////////////////// OUTBOUND DATA ////////////////////////
	/**
	 * Creates the panel to handle a record.
	 * @return
	 */
	private JPanel createCurrentRecordPanel()
	{
		JPanel currentRecordPanel = new JPanel(); 	


		currentRecordPanel.setLayout(new GridBagLayout()); 	
		currentRecordPanel.setBorder(BorderFactory.createTitledBorder("Active Record"));
		gridBagConstraints.fill = GridBagConstraints.BOTH;     
		
		doNotCallCurrentRecordButton = new JButton("Do not call");
		doNotCallCurrentRecordButton.setToolTipText("Click here to forbide further calls to the record's contact.");
		doNotCallCurrentRecordButton.setEnabled(false);
		gridBagConstraints.gridwidth = 1;
		gridBagConstraints.gridheight = 1;
		
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		currentRecordPanel.add(doNotCallCurrentRecordButton,gridBagConstraints);
			
		cancelCurrentRecordButton = new JButton("Cancel");
		cancelCurrentRecordButton.setToolTipText("Click here to cancel this record.");
		cancelCurrentRecordButton.setEnabled(false);
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 1;
		currentRecordPanel.add(cancelCurrentRecordButton,gridBagConstraints);
		

		rescheduleCurrentRecordButton = new JButton("Reschedule");
		rescheduleCurrentRecordButton.setToolTipText("Click here to reschedule this call.");
		rescheduleCurrentRecordButton.setEnabled(false);
		gridBagConstraints.gridwidth = 1;
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		currentRecordPanel.add(rescheduleCurrentRecordButton,gridBagConstraints);
		
		JLabel phoneTextLabel = new JLabel("Phone: ");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		currentRecordPanel.add(phoneTextLabel,gridBagConstraints);
		
		
		phoneLabel = new JLabel("--");
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		currentRecordPanel.add(phoneLabel,gridBagConstraints);
		
		JLabel statusTextLabel = new JLabel("Status: ");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		currentRecordPanel.add(statusTextLabel,gridBagConstraints);
		
		
		currentRecordStatusLabel = new JLabel("--");
		currentRecordStatusLabel.setMinimumSize(new Dimension(10,10));
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.gridwidth =1;
		currentRecordPanel.add(currentRecordStatusLabel,gridBagConstraints);
				
		JLabel dailyFromTextLabel = new JLabel("Daily from: ");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		currentRecordPanel.add(dailyFromTextLabel,gridBagConstraints);
		
		dailyFromLabel = new JLabel("--");
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		currentRecordPanel.add(dailyFromLabel,gridBagConstraints);
		
		
		
		JLabel dailyTillTextLabel = new JLabel("Daily till: ");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		currentRecordPanel.add(dailyTillTextLabel,gridBagConstraints);
		
		
		dailyTillLabel = new JLabel("-- ");
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 4;
		currentRecordPanel.add(dailyTillLabel,gridBagConstraints);
				
		
		phoneTypeLabel = new JLabel("Type: ");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		currentRecordPanel.add(phoneTypeLabel,gridBagConstraints);
		
		// Set up a combo box with the list of campaigns
		phoneTypeComboBox = new JComboBox();
		phoneTypeComboBox.setAutoscrolls(true);
		phoneTypeComboBox.setEditable(false);
		phoneTypeComboBox.setSize(new Dimension(150, 20));

		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.gridx =1;
		gridBagConstraints.gridy = 5;    	
		currentRecordPanel.add(phoneTypeComboBox, gridBagConstraints);		
		
		callResultLabel = new JLabel("Result: ");
		gridBagConstraints.gridwidth = 1;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		currentRecordPanel.add(callResultLabel,gridBagConstraints);


		// Set up a combo box with the list of campaigns
		callResultComboBox = new JComboBox();    	
		callResultComboBox.setAutoscrolls(true);
		callResultComboBox.setEditable(false);
		callResultComboBox.setSize(new Dimension(150, 20));

		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.gridwidth = 2;
		currentRecordPanel.add(callResultComboBox, gridBagConstraints);
				
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.gridheight = 3;		
		gridBagConstraints.gridx =0;
		gridBagConstraints.gridy =7;    	
		currentRecordPanel.add(createCustomFieldsTree(), gridBagConstraints);	


		return currentRecordPanel;

	}


	/**
	 * Creates the panel to manage the outbound chain.
	 * @return
	 */
	private JPanel createChainPanel()
	{

		//Panel of the outbound chain
		JPanel currentChainPanel = new JPanel();
		currentChainPanel.setBorder(BorderFactory.createTitledBorder(" Chain "));
		currentChainPanel.setLayout(new GridBagLayout());
		gridBagConstraints.fill = GridBagConstraints.BOTH;     


		cancelChainButton = new JButton("Cancel");
		cancelChainButton.setToolTipText("Click here to cancel this chain.");
		cancelChainButton.setEnabled(false);
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;	
		gridBagConstraints.gridwidth = 1;
		gridBagConstraints.weightx = 1;
		gridBagConstraints.gridheight = 1;
		gridBagConstraints.weighty = 1;
		currentChainPanel.add(cancelChainButton,gridBagConstraints);
		
	
		
		rejectChainButton = new JButton("Reject chain");
		rejectChainButton.setEnabled(false);
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		currentChainPanel.add(rejectChainButton,gridBagConstraints);
			
		
		doNotCallChainButton = new JButton("Do not call");
		doNotCallChainButton.setEnabled(false);
		doNotCallChainButton.setToolTipText("Click here to forbide further calls to the record's contact.");
		doNotCallChainButton.setEnabled(false);
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		currentChainPanel.add(doNotCallChainButton,gridBagConstraints);
		
		
		closeChainButton = new JButton("Close chain");
		closeChainButton.setEnabled(false);
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		currentChainPanel.add(closeChainButton,gridBagConstraints);
		
		requestRecordChainButton = new JButton("Chained record");
		requestRecordChainButton.setEnabled(false);
		requestRecordChainButton.setToolTipText("Click here to request a chained record.");
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		currentChainPanel.add(requestRecordChainButton,gridBagConstraints);

		markProcessedChainButton = new JButton("Mark processed");
		markProcessedChainButton.setEnabled(false);
		markProcessedChainButton.setToolTipText("Click here to mark the chain as processed.");
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 1;
		currentChainPanel.add(markProcessedChainButton,gridBagConstraints);

		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.gridheight = 1;
		gridBagConstraints.gridwidth = 1;
		currentChainPanel.add(Box.createRigidArea(new Dimension(10,0)),gridBagConstraints);
		
		
		
		chainTreatmentLabel = new JLabel("Treatment:");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		currentChainPanel.add(chainTreatmentLabel,gridBagConstraints);
		

		

		// Set up a combo box with the list of possible treatments
		chainTreatmentComboBox = new JComboBox();
		chainTreatmentComboBox.setAutoscrolls(true);
		chainTreatmentComboBox.setEditable(false);
		chainTreatmentComboBox.setSize(new Dimension(150, 10));
		
		
		

		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		currentChainPanel.add(chainTreatmentComboBox,gridBagConstraints);
		
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		currentChainPanel.add(Box.createRigidArea(new Dimension(10,5)),gridBagConstraints);
	
		JLabel ch = new JLabel("Chain Type: ");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		currentChainPanel.add(ch,gridBagConstraints);
		
		chainIsScheduledLabel = new JLabel("Unknown");
		gridBagConstraints.gridwidth = 1;
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 5;
		currentChainPanel.add(chainIsScheduledLabel,gridBagConstraints);
		
		
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		currentChainPanel.add(Box.createRigidArea(new Dimension(10,5)),gridBagConstraints);

		JLabel recs = new JLabel("Records of the chain");
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 7;
		currentChainPanel.add(recs,gridBagConstraints);
		
//		Add a status table
		chainedRecordsTableModel = new OpenMediaTableModel();
		chainedRecordsTableModel.colName0 = "Phone";
		chainedRecordsTableModel.colName1 = "Status";
		chainedRecordsTableModel.colName2 = "Result";
		chainedRecordsTableModel.NUM_COLUMNS = 3;
		chainedRecordsTableModel.START_NUM_ROWS = 4;
		
		chainedRecordsTable = new JTable(chainedRecordsTableModel);
		chainedRecordsTable.setSelectionBackground(new Color(2,131,212));
		chainedRecordsTable.setSelectionForeground(new Color(255,255,255));
		JScrollPane chainedRecordsTableScrollPane = new JScrollPane(chainedRecordsTable);
		chainedRecordsTableScrollPane.setBorder(BorderFactory.createEtchedBorder());
		chainedRecordsTable.setPreferredScrollableViewportSize(new Dimension(150, 80));
		chainedRecordsTable.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		chainedRecordsTable.setToolTipText("If you select a record, it becomes the active record of the chain.");
		gridBagConstraints.gridheight = 4;
		gridBagConstraints.gridwidth = 3;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy =8; 	
		currentChainPanel.add(chainedRecordsTableScrollPane, gridBagConstraints);

		return currentChainPanel;
	}

	/**
	 * Creates the panel to manage a campaign.
	 * @return
	 */
	private JPanel createCampaignPanel()
	{
		JPanel masterCampaignPanel = new JPanel();
		masterCampaignPanel.setLayout(new GridBagLayout());
		masterCampaignPanel.setBorder(BorderFactory.createTitledBorder(" Campaign "));
		GridBagConstraints constr = new GridBagConstraints();
		constr.fill = GridBagConstraints.BOTH;		
		
		
		startPreviewButton = new JButton("Start Preview");
		startPreviewButton.setEnabled(false);
		constr.gridx = 0;
		constr.gridy = 0; 
		constr.gridwidth = 1;
		constr.weightx = 1;
		masterCampaignPanel.add(startPreviewButton,constr); 
		

		stopPreviewButton = new JButton("Stop Preview");
		stopPreviewButton.setEnabled(false);
		constr.gridwidth = 1;
		constr.gridheight = 1;
		constr.gridx = 1;
		constr.gridy = 0; 
		masterCampaignPanel.add(stopPreviewButton,constr); 
		
		requestPreviewRecordButton = new JButton("Preview record");
		requestPreviewRecordButton.setEnabled(false);
		constr.gridwidth = 1;
		constr.gridheight = 1;
		constr.weightx = 1.0;
		constr.weighty = 1.0;
		constr.gridx = 2;
		constr.gridy = 0;   
		masterCampaignPanel.add(requestPreviewRecordButton,constr); 
		
		
		
		
		constr.gridx = 0;
		constr.gridy = 1; 
		masterCampaignPanel.add(new JLabel("Select: "), constr);

		// Set up a combo box with the list of campaigns
		campaignComboBox = new JComboBox();
		campaignComboBox.setAutoscrolls(true);
		campaignComboBox.setEditable(false);
		campaignComboBox.setSize(new Dimension(200, 20));
				
		

		constr.gridx = 1;
		constr.gridy = 1;   
		constr.gridwidth = 2;
		constr.weightx = 2;
		masterCampaignPanel.add(campaignComboBox, constr);

		
		
		
		campaignModeLabel = new JLabel("Mode: ");
		constr.gridwidth = 2;
		constr.gridx = 0;
		constr.gridy = 2;  
		masterCampaignPanel.add(campaignModeLabel, constr);
				
		JPanel campaignStatusPanel = new JPanel();
			campaignStatusPanel.setBorder(BorderFactory
					.createTitledBorder("Description"));

			
		campaignDescriptionTextArea = new JTextArea("");
		campaignDescriptionTextArea.setEditable(false);
		campaignDescriptionTextArea.setFont(new Font("Arial",Font.PLAIN,10));
		campaignDescriptionTextArea.setAlignmentX(0);
		campaignDescriptionTextArea.setRows(6);
		campaignDescriptionTextArea.setColumns(30);
		campaignDescriptionTextArea.setSize(new Dimension(200,40));
		campaignDescriptionTextArea.setMinimumSize(new Dimension(150,40));
		constr.gridx = 0;
		constr.gridy = 3; 
		constr.gridwidth = 3;
		constr.gridheight = 3;
		constr.weightx = 5.0;
		constr.weighty = 3.0;
		campaignStatusPanel.add(campaignDescriptionTextArea);
		masterCampaignPanel.add(campaignStatusPanel , constr);
		
	
 
		return masterCampaignPanel;
	}


	///////////////// MANAGEMENT METHODS ////////////////
	/**
	 * Adds or updates a line of the place table.
	 */
	public void setInteractionStatusInTable(String name, String status, String queue, String subject)
	{
		this.ixnTableModel.update(new String[]{name, name,status, queue, subject});

	}

	/**
	 * Removes an interaction from the table.
	 * @param name
	 */
	public void removeIxnStatusInTable(String name)
	{
		this.ixnTableModel.removeID(name);
	}

	/**
	 * Returns the ID of an interaction at the specified row.
	 * @param row
	 * @return
	 */
	public String getSelectedInteractionID(int row)
	{
		return (String) ixnTableModel.getIDAt(row);

	}
	/**
	 * Returns the ID of a record at the specified row.
	 * @param row
	 * @return
	 */
	public String getSelectedChainedRecord(int row)
	{
		return (String) chainedRecordsTableModel.getIDAt(row);
	}

	/**
	 * Updates or adds a record.
	 */
	public void setChainedRecord(String id, String phone, String status, String result)
	{
		chainedRecordsTableModel.update(new String[]{id, phone, status, result});
	}
	/**
	 * Removes a record from the table.
	 * @param id
	 */
	public void removeChainedRecord(String id)
	{
		chainedRecordsTableModel.removeID(id);
		
	}
	/**
	 * Clears the chained records' table.
	 */
	public void clearChainedRecords()
	{
		chainedRecordsTableModel.clear();
	}
	

 /////////////////////// MAIN TO TEST //////////////////	

	/**
	 * You can run the GUI independently for testing.
	 */
	public static void main(String[] args) {
		AgentOutboundGui agentOutboundGui = new AgentOutboundGui(
				"Agent Interaction (Java): Outbound Test"
		);
		agentOutboundGui.mainGuiWindow.pack();
		agentOutboundGui.mainGuiWindow.setVisible(true);
	}



}