/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
package agent.interaction.samples.outbound;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;

import org.apache.log4j.Logger;
import agent.interaction.samples.AgentInteractionData;
import com.genesyslab.ail.Dn;
import com.genesyslab.ail.Place;
import com.genesyslab.ail.event.DnEvent;


/**
 * Handles a place for the Agent Outbound Example.<br>
 * This class performs actions on the DN of the place, and not on the additional media that this place includes. <br>
 * The user can click enabled buttons to modify its place status.
 * The place information and the buttons are updated according to the DnEvents that the AgentOutboundExample instance receives.
 *
 */
public class PlaceAdapterForOutbound {

	AgentInteractionData agentInteractionData;
	/** Adds logs labeled "ForOutbound.CampaignAdapter" in the log file */ 
	Logger sLog = Logger.getLogger("ForOutbound.PlaceAdapter");	    

	// Agent, place, and DN for the AIL examples
	/** Place object used in this example. */
	public Place samplePlace;
	/** Dn object used in this example. */
	public Dn sampleDn;

	JButton loginButton;
	JButton logoutButton;
	JButton readyButton;
	JButton notReadyButton;
	JButton afterCallWorkButton;

	JLabel loginNameLabel;
	JLabel dnLabel;
	JLabel dnStatusLabel;
	JLabel agentPlaceLabel;
	JLabel agentQueueLabel;

	String dnEventStyle = "dnEvent";
	String placeEventStyle = "placeEvent";
	String interactionEventStyle = "interactionEvent";
	String errorStyle = "errorEvent";
	AgentOutboundGui outboundGui;

	/**
	 * Constructor. At creation, the instance links widgets (login buttons) to place actions.
	 *
	 */
	public PlaceAdapterForOutbound(Place _samplePlace,Dn _sampleDn,AgentInteractionData _agentInteractionData, AgentOutboundGui _gui) {

		// Set up an agent, place and DN for use by the examples
		samplePlace = _samplePlace;
		sampleDn = _sampleDn;
		outboundGui = _gui;
		agentInteractionData = _agentInteractionData;


		// Link the GUI components to API functionality
		linkWidgetsToGui();

	}


	/**
	 * Links place buttons to <code>Place</code> methods ( voice 
	 * methods only, no multimedia call).<br>
	 *
	 */
	public void linkWidgetsToGui() {
		// Add a "Log In" button
		loginButton = outboundGui.loginButton;
		loginButton.setAction(new AbstractAction("Log In") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {             	
					// Perform a voice-only login                	
					samplePlace.login(agentInteractionData.getLoginId1(),
							agentInteractionData.getPassword1(),
							agentInteractionData.getQueue(), null, null, null);

				} catch (Exception exception) {
					sLog.error(exception.getMessage()
							+ "cause: " + exception.getCause()                        );
				}
			}
		});

		// Add a "Log Out" button
		logoutButton = outboundGui.logoutButton;
		logoutButton.setAction(new AbstractAction("Log Out") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					samplePlace.logout(agentInteractionData.getQueue(), null, null);

				} catch (Exception exception) {
					exception.printStackTrace();
					sLog.error(exception.getMessage()
							+ "cause: " + exception.getCause());
				}
			}
		});

		// Add a "Ready" button
		readyButton = outboundGui.readyButton;
		readyButton.setAction(new AbstractAction("Ready") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					samplePlace.ready(agentInteractionData.getQueue(), null, null, null);

				} catch (Exception exception) {
					exception.printStackTrace();
					sLog.error(exception.getMessage()
							+ "cause: " + exception.getCause());
				}
			}
		});

		// Add a "Not Ready" button
		notReadyButton = outboundGui.notReadyButton;
		notReadyButton.setAction(new AbstractAction("Not Ready") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {

					samplePlace.notReady(agentInteractionData.getQueue(), null,
							null, null);
				} catch (Exception exception) {
					exception.printStackTrace();
					sLog.error(exception.getMessage()
							+ "cause: " + exception.getCause());
				}
			}
		});

		// Add an After Call Work ("ACW") button
		afterCallWorkButton = outboundGui.afterCallWorkButton;
		afterCallWorkButton.setAction(new AbstractAction("ACW") {
			public void actionPerformed(ActionEvent actionEvent) {
				try {
					samplePlace.afterCallWork(agentInteractionData.getQueue(),
							null, null);
				} catch (Exception exception) {
					exception.printStackTrace();
					sLog.error(exception.getMessage()
							+ "cause: " + exception.getCause());
				}
			}
		});

		// Add other information
		loginNameLabel = outboundGui.loginNameLabel;
		loginNameLabel.setText("Login: "
				+ agentInteractionData.getAgent1UserName());
		dnLabel = outboundGui.dnLabel;
		dnLabel.setText("DN: " + agentInteractionData.getDn1());

		dnStatusLabel = outboundGui.dnStatusLabel;

		agentPlaceLabel = outboundGui.agentPlaceLabel;
		agentPlaceLabel.setText("Place: " + agentInteractionData.getPlace1());
		agentQueueLabel = outboundGui.agentQueueLabel;
		agentQueueLabel.setText("Queue: " + agentInteractionData.getQueue());

		loginButton.setEnabled(true);

	}


	/**
	 * Enables/Disables login buttons according to isPossible values of each button.
	 */
	public synchronized void setPlaceWidgetState() {

		if(sampleDn != null)
		{    		
			loginButton.setEnabled(sampleDn.isPossible(Dn.Action.LOGIN));
			logoutButton.setEnabled(sampleDn.isPossible(Dn.Action.LOGOUT));
			readyButton.setEnabled(sampleDn.isPossible(Dn.Action.READY));
			notReadyButton.setEnabled(sampleDn.isPossible(Dn.Action.NOTREADY));
			afterCallWorkButton.setEnabled(sampleDn.isPossible(Dn.Action.AFTERCALLWORK));

			dnStatusLabel.setText("Status "+sampleDn.getStatus().toString());
			dnStatusLabel.setForeground(Color.BLUE);
		}
	} 



	/**
	 * Receives DnEvents, which report changes to the status or data of a DN. Because this method is called in the PlaceListener, 
	 * it creates a thread to manage the event without delaying the publication of further incoming events. 

	 */
	public void handleDnEvent(DnEvent event) {
		DnEventThread p = new DnEventThread(event);
		p.start();

	}

	/**
	 * Manages one DnEvent by updating the DN status labels.
	 *
	 */		
	class DnEventThread extends Thread {

		DnEvent event;

		public DnEventThread(DnEvent _event) {
			event= _event;
		}


		public void run()
		{
			// Get information about the event
			Dn dn = event.getDn();
			String dnString = dn.getId();
			String dnStatusString = dn.getStatus().toString();
			String eventReason = event.getEventReason().toString();

			// If the user asked for standard log information, collect it
			String dnEventString = "DN: "   + dnString
			+ "    Status: " + dnStatusString
			+ "    Reason: " + eventReason ;
			// Write the message to the application log window
			sLog.debug(dnEventString);


			// THIS IS AN IMPORTANT STEP:
			// As the status changes, enable or disable the buttons
			setPlaceWidgetState();

		}
	}




}
