/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/

package media.sdk.java.examples;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

import com.genesyslab.omsdk.mil.MILESPExtension;
import com.genesyslab.omsdk.mil.MILESPFaultResponse;
import com.genesyslab.omsdk.mil.MILESPRequest;
import com.genesyslab.omsdk.mil.MILESPSuccessResponse;
import com.genesyslab.omsdk.mil.exception.MILRequestFailedException;

/**
 * Implements a custom extension able to process the file
 * that the simple media server attached to an Open Media interaction.
 */
public class SimpleCustomExtension implements MILESPExtension {
	/** Timestamp for logging traces. */
	static DateFormat timestamp = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss:SSS");
	/**
	 * Returns a timestamp for log messages.
	 */
	public String createTimeStamp() {
		String stamp =  timestamp.format(new GregorianCalendar().getTime()) + " SimpleCustomExtension -";
		return stamp;
	}

	/**
	 * Initializes the extension.
	 */
	public void initialize(){
		System.out.println(createTimeStamp()
				+ " Initialized " );
	}
	/**
	 * Shutdown the extension.
	 */
	public void shutdown(){
		System.out.println(createTimeStamp()
				+ " Shutdown " );
	}


	/**
	 * Processes an ESP request by creating a thread dedicated to
	 * the "Gold" search in attached data, and to sending the appropriate response
	 * to Interaction Server.
	 * @param request the ESP request to be processed.
	 */
	public void doProcessRequest(MILESPRequest request){
		ProcessThread p = new ProcessThread(request);
		p.start();
	}

	/**
	 * Processes a MIL ESP request received by a SimpleCustomExtension instance.
	 * <p>It retrieves the file attached to the interaction in the user data of the request.
	 * Then, it searches in the text of the file, the string "Gold", "GOLD", or "gold".
	 * Finally, it sends an ESP response to Interaction Server.
	 */
	class ProcessThread extends Thread {
		/** Request to be processed by the thread.*/
		public MILESPRequest request;

		/** Constructor. */
		public ProcessThread(MILESPRequest _request) {
			this.request = _request;
		}


		/**
		 * Processes the MIL request associated with this thread.
		 */
		public void run() {
			try {
				/* Retrieving the name of the file that will be processed. */
				String fileName = (String) request.getUserData().get("FileName");
				System.out.println(this.createTimeStamp() + " Processing Gold search on "+ fileName+ " \tinteraction ID " + request.getInteractionID());

				/* Retrieving the text to make the search. */
				byte[] b = (byte[]) request.getUserData().get("FileBody");
				ByteArrayInputStream mystream = new ByteArrayInputStream(b);
				BufferedReader d =  new BufferedReader(new InputStreamReader(mystream));

				boolean gold = false;
				while(gold == false){
					try {
						String line = d.readLine();
						if(line==null)
							break;
						if(line!= null && (line.indexOf("gold")!=-1
								|| line.indexOf("Gold")!=-1
								|| line.indexOf("GOLD")!=-1 ))
						{
							gold = true;
						}
					} catch (IOException e) {
						break;
					}
				}


				String goldString = "NotGold";
				if(gold)
					goldString = "GoldCustomer";

				/* Creating a success response. */
				MILESPSuccessResponse successResponse = request.createSuccessResponse();

				/* Adding a gold marker to the response to be sent. */
				successResponse.setUserDataItem("GoldMarker", goldString);

				System.out.println(this.createTimeStamp()
						+ " Send sucess response gold("+ gold +") for ESP Request " +request.getID());

				/* Sending the response. */
				try {
					successResponse.send();
				} catch (MILRequestFailedException e) {
					e.printStackTrace();
				}
			}
			catch(Exception _e)
			{
				_e.printStackTrace();

				/* Sending a fault in case processing the interaction failed. */
				MILESPFaultResponse faultResponse = request.createFaultResponse();
				faultResponse.setFaultCode(0);
				faultResponse.setFaultString("No file found for this interaction");

				System.out.println(this.createTimeStamp()
						+ " Send fault response for ESP Request " +request.getID());
				try {
					faultResponse.send();
				} catch (MILRequestFailedException e) {
					e.printStackTrace();
				}
			}
		}


		/**
		 * Returns a timestamp for log messages.
		 */
		private String createTimeStamp() {
			String stamp =  timestamp.format(new GregorianCalendar().getTime()) + " ProcessThread request "+request.getID()+" - ";
			return stamp;
		}




	}


}
