/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
/**
Queued Interaction Java API 7.5 Code Examples
@version 7.5.001.00
*/
package queued.sdk.java.examples;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.SwingUtilities;

import javax.swing.event.ListSelectionListener;

import java.util.HashMap;
import java.util.Vector;
import java.util.Iterator;

import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;


/**
 * Graphical user interface for the  Multiple Alarm scenario of 
 * Queued Interaction Java code examples.
 *
 */
public class AlarmGui {

	// Colors
    
    public Color obscureWeakGreen = new Color(0, 51, 0);
    public Color darkFadedGreen = new Color(0, 153, 0);
    public Color obscureDullGreen = new Color(0, 102, 0);
    public Color paleWeakCyan = new Color(204, 255, 255);
    public Color lightWeakGreen = new Color(153, 204, 153);
    public Color paleWeakGreen = new Color(204, 255, 204);
    public Color paleWeakYellow = new Color(255, 255, 204);
    public Color paleWeakBlue = new Color(153,204,255);
    public Color paleWeakRed = new Color(255, 204, 204);
    
    public Color activeBackgroundColor = paleWeakYellow;
    public Color inactiveColor = Color.lightGray;
    
    public Color alarmColor =  Color.RED;
    public Color warningColor = Color.ORANGE;
    public Color fiftyColor = paleWeakYellow;
    public Color underWarningColor = lightWeakGreen;
 
    public Color queueEventColor = Color.blue;
    public Color errorColor = Color.red;
    public Color selectedLineColor = new Color(2,131,212);
    
   
    public Font bold = new Font("", Font.BOLD, 10);
    public Font processBarbold = new Font("", Font.BOLD, 11);
    public Font activeFont = bold;
    
    
    public String tooltipDefaultThreshold = 
    	"Enter a default threshold to be associated with all the monitored queues. ";
    public String tooltipAlarm = 
    	"Number of interactions before an alarm is sent. ";
    public String tooltipDefaultThresholdButton	= 
    	"Click on the Apply button below to activate the default threshold.";
    public String tooltipThreshold = 
    	"Enter a threshold to be associated with the selected queue. " +
    	"If this queue contains a number of interactions greater than the default threshold, an alarm is fired. ";
   public String tooltipThresholdButton =  	"\nClick on the Apply button below to activate this threshold.";
    
    public String tooltipDetails = "This panel displays the details of a monitored queue selected in the above list.";
    
    public String tooltipMonitoring = "Percentages depend on the alarm threshold set for each queue. " +
	"If a queue contains a number of interactions greater than its threshold, an alarm is fired. ";
  
    
    
    JFrame mainGuiWindow;
    Container contentPane;
    
    
    
    //--------- Widgets for managing Queues
    // Queue Table
    JScrollPane queueScrollPane;
    JPanel queuePanel;
    TitledBorder queueTitledBorder = BorderFactory
    .createTitledBorder(" Real-Time Activity in Queues ");
    
    Vector mqueues, mbars, mlabels;
    
    GridBagConstraints gridBagConstraints ;
    
    
    JPanel setUpDefaultAlarmPanel;
    TitledBorder defaultAlarmTitledBorder = BorderFactory
    .createTitledBorder(" Set Up Default Alarm Threshold ");
    JLabel defaultThresholdLabel;
    public JTextField defaultThresholdField;
    public JButton applyDefaultThresholdButton;

    
    //--------- Widgets for setUpAlarm
    JPanel setUpAlarmPanel;
    TitledBorder alarmTitledBorder = BorderFactory
    .createTitledBorder(" Set Up Alarm Theshold on a Selected Queue ");
    JLabel selectAQueueLabel;
    JLabel thresholdLabel;
    public JTextField thresholdField;
    public JButton applyThresholdButton;
    public JComboBox queueComboBox; 
    
    
    // Widgets for addtional info
    JPanel  additionalInfoPanel;
	TitledBorder additionalInfoBorder= BorderFactory.createTitledBorder(" Alarm Real-Time Information ");
	JLabel alarmFiredLabel ;
	JButton alarmDetailButton;
	JLabel inWarningLabel ;
	JButton inWarningDetailButton;
	
    
    //-------- Widgets for last alarms sent
    
    JScrollPane	lastAlarmScrollPane;
    TitledBorder lastAlarmTitledBorder = BorderFactory
    .createTitledBorder(" Last alarms fired for...");
    JPanel  lastAlarmsPanel;
    public JList alarmList;
    DefaultListModel alarmModel ;
    JPanel alarmDetailsPanel;
    JScrollPane alarmDetailsTextScrollPane;	
    public JTextArea alarmDetailsText;
    TitledBorder alarmDetailsTitledBorder = BorderFactory
    .createTitledBorder(" Details about the selected queue");
    JProgressBar alarmStatusProgressBar;
    JLabel alarmStatusLabel;
    public ListSelectionListener alarmListener;
    HashMap alarmDetails;
    int totalAlarms = 0;
    
//  -------- Widgets for warning
    
    JScrollPane	warningScrollPane;
    TitledBorder warningTitledBorder = BorderFactory
    .createTitledBorder(" Warning on... ");
    JPanel  warningPanel;
    public JList warningList;
    DefaultListModel warningModel ;
    JPanel warningDetailsPanel;
    JScrollPane warningDetailsTextScrollPane;	
    public JTextArea warningDetailsText;
    TitledBorder warningDetailsTitledBorder = BorderFactory
    .createTitledBorder(" Current status of the queue");
    JProgressBar warningStatusProgressBar;
    JLabel warningStatusLabel;
    public ListSelectionListener warningListener;
    HashMap warningDetails;
    int totalWarning = 0;
    
    
    
    

    /// Information about selected queue
   JProgressBar selectedQueueProgressBar;
    JLabel interactionNumberLabel;
   

    
    //--Log area
    JScrollPane logPaneScrollPane;
    JTextPane logPane;
    Calendar calendar = new GregorianCalendar();
    DateFormat timestamp = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss:SSS");
    StyledDocument logDocument;
    String newline = "\n";
    public static String serviceEventStyle = "serviceEvent";
    public static String interactionEventStyle = "interactionEvent";
    public static String queueEventStyle = "queueEvent";
    public static String errorStyle = "error";

    
    //---------- Constructor and 'create panels' methods.
    /**
     * AlarmGui constructor. Creates an AlarmGui instance.
     * @param windowTitle
     *            The title of the GUI window for the example that is currently
     *            being run..
     */
    public AlarmGui(
            String windowTitle) {
    	mqueues = new Vector();
    	mbars = new Vector();
    	mlabels = new Vector();
        createGui(windowTitle);

    }
    /**
     * Creates the panels that compose the GUI.
     * @param windowTitle
     */
    public void createGui(String windowTitle)
    {
    	 try {
            UIManager
                    .setLookAndFeel(UIManager
                            .getSystemLookAndFeelClassName());
        } catch (Exception exception) {
            exception.printStackTrace();
        }

        // Create the main window
        mainGuiWindow = new JFrame(windowTitle);
        mainGuiWindow
                .setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainGuiWindow.setSize(new Dimension(600,750));
        contentPane = mainGuiWindow
                .getContentPane();
        contentPane
        .setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        
        ////////////////// CONTENT PANE ///////////////////////
        gridBagConstraints.gridx =0;
        gridBagConstraints.gridy =0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        contentPane.add(createQueuesScrollPane(),gridBagConstraints);
        
        gridBagConstraints.gridx =2;
        gridBagConstraints.gridy =0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        contentPane.add(createDefaultAlarmPanel(),gridBagConstraints);
        
        gridBagConstraints.gridx =2;
        gridBagConstraints.gridy =1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        contentPane.add(createSetUpAlarmPanel(),gridBagConstraints);
        
        gridBagConstraints.gridx =2;
        gridBagConstraints.gridy =2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        contentPane.add(createAdditionalInfoPanel(),gridBagConstraints);

        
        createLogAreaScrollPane();
    }


    /**
     * Creates the table displaying the available queues.
     * <br>Includes a renderer class to highlight 
     */
    private JScrollPane createQueuesScrollPane()
    {
    	queuePanel = new JPanel();
    	queuePanel.setLayout(new BoxLayout(
    			queuePanel, BoxLayout.Y_AXIS));   
    	queuePanel.setToolTipText(this.tooltipMonitoring);
    	queuePanel.setMinimumSize(new Dimension(350, 200));
    	queuePanel.setMaximumSize(new Dimension(400, 500));
        
    	queueScrollPane = new JScrollPane(queuePanel);      
        queueScrollPane.setBorder(queueTitledBorder);
        queueTitledBorder.setTitleFont(activeFont);
        queueScrollPane.setMinimumSize(new Dimension(320, 300));
        queueScrollPane.setPreferredSize(new Dimension(320, 460));
        queueScrollPane.setMaximumSize(new Dimension(400, 600));   
        return queueScrollPane;

    }
    /**
     * Adds a listener to the ComboBox component that lists queues.
     * @param actionListener listener to be added.
     */
    public void addQueueComboxBoxItemListener(ItemListener actionListener)
    {
    	queueComboBox.addItemListener(actionListener);

    }

    private JPanel createDefaultAlarmPanel()
    {
    	  setUpDefaultAlarmPanel  = new JPanel();
    	  setUpDefaultAlarmPanel.setToolTipText(this.tooltipDefaultThreshold);
    	  defaultAlarmTitledBorder.setTitleFont(activeFont);
    	  setUpDefaultAlarmPanel.setBorder(defaultAlarmTitledBorder);  
    	  setUpDefaultAlarmPanel.setMinimumSize(new Dimension(300, 100));
    	  setUpDefaultAlarmPanel.setPreferredSize(new Dimension(300, 100));
    	  setUpDefaultAlarmPanel.setMaximumSize(new Dimension(400, 150));   
          
    	  setUpDefaultAlarmPanel.setLayout(new GridBagLayout());
          
    	  GridBagConstraints c = new GridBagConstraints();
          c.fill = GridBagConstraints.BOTH;
          
    	  defaultThresholdLabel = new JLabel("Default ixns threshold: ");    	  
    	  defaultThresholdLabel.setFont(activeFont);
          c.gridx = 0;
          c.gridy = 0;
          c.gridwidth = 1;
          setUpDefaultAlarmPanel.add(defaultThresholdLabel, c);
          
          defaultThresholdField = new JTextField();
          defaultThresholdField.setMinimumSize(new Dimension(150,20));
          defaultThresholdField.setPreferredSize(new Dimension(150, 20));
          defaultThresholdField.setMaximumSize(new Dimension(150, 20));   
          c.gridx = 1;
          c.gridy = 0;
          c.gridwidth = 1;
          setUpDefaultAlarmPanel.add(defaultThresholdField, c);
          
          applyDefaultThresholdButton = new JButton("Apply Default ");
          applyDefaultThresholdButton.setFont(activeFont);
          c.gridx = 1;
          c.gridy = 1;
          c.gridwidth = 1;
          setUpDefaultAlarmPanel.add(applyDefaultThresholdButton, c);
          
          
          
          return setUpDefaultAlarmPanel;
          
    }
    private JPanel createSetUpAlarmPanel()
    {
    	
        setUpAlarmPanel = new JPanel();
        setUpAlarmPanel.setToolTipText(this.tooltipThreshold);
        alarmTitledBorder.setTitleFont(activeFont);
        setUpAlarmPanel.setBorder(alarmTitledBorder);  
        setUpAlarmPanel.setLayout(new GridBagLayout());
        setUpAlarmPanel.setMinimumSize(new Dimension(300, 160));
        setUpAlarmPanel.setPreferredSize(new Dimension(300, 160));
        setUpAlarmPanel.setMaximumSize(new Dimension(400, 300));   
        
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;

        selectAQueueLabel = new JLabel("Select a Queue: ");
        selectAQueueLabel.setFont(activeFont);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        setUpAlarmPanel.add(selectAQueueLabel, c);
        
        c.gridx = 1;
        c.gridy = 0;
        queueComboBox = new JComboBox();
        queueComboBox.setMinimumSize(new Dimension(170,20));
        queueComboBox.setPreferredSize(new Dimension(170,20));
        queueComboBox.setMaximumSize(new Dimension(300, 20));  
        setUpAlarmPanel.add(queueComboBox, c);
        
       
        
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        interactionNumberLabel = new JLabel("Interactions: ");
        interactionNumberLabel.setFont(activeFont);
        interactionNumberLabel.setMinimumSize(new Dimension(250,60));
        setUpAlarmPanel.add(interactionNumberLabel,c);
        
        selectedQueueProgressBar = new JProgressBar( 0, 100);       
        selectedQueueProgressBar.setForeground(colorProgressBar(0));
        selectedQueueProgressBar.setStringPainted(true);
        selectedQueueProgressBar.setFont(processBarbold);
        selectedQueueProgressBar.setValue(0);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        setUpAlarmPanel.add(selectedQueueProgressBar,c);
        
        
        thresholdLabel = new JLabel("Ixn Threshold: ");
        thresholdLabel.setFont(activeFont);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        setUpAlarmPanel.add(thresholdLabel, c);
        
        thresholdField = new JTextField();
        thresholdField.setMinimumSize(new Dimension(150,20));
        c.gridx = 1;
        c.gridy = 3;
        setUpAlarmPanel.add(thresholdField, c);
        
        applyThresholdButton = new JButton("Set Threshold");
        applyThresholdButton.setFont(activeFont);
        c.gridx = 1;
        c.gridy =4;
        setUpAlarmPanel.add(applyThresholdButton, c);
        
       
        
        return setUpAlarmPanel;
        
    	
    }
    
    private JPanel createAdditionalInfoPanel()
    {
    	additionalInfoPanel = new JPanel();
    	additionalInfoPanel.setMinimumSize(new Dimension(300, 160));
    	additionalInfoPanel.setPreferredSize(new Dimension(300, 160));
    	additionalInfoPanel.setMaximumSize(new Dimension(400, 300));  
    	additionalInfoPanel.setBorder(additionalInfoBorder);    	
    	additionalInfoBorder.setTitleFont(activeFont);
    	additionalInfoPanel.setLayout(new GridBagLayout());
        
    	GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        
    	alarmFiredLabel = new JLabel("No alarm fired");
    	alarmFiredLabel.setFont(activeFont);
    	c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
    	additionalInfoPanel.add(alarmFiredLabel,c);
    	
    	alarmDetailButton = new JButton("Further details about fired alarms...");
    	alarmDetailButton.setFont(activeFont);
    	alarmDetailButton.setAction(new AbstractAction("Further details...") {
			public void actionPerformed(ActionEvent actionEvent) {
				{
					   // Create the frame
				    String title = "Details about fired alarms";
				    JFrame frame = new JFrame(title);
				    
				    // Add the component to the frame's content pane;
				    // by default, the content pane has a border layout
				    frame.getContentPane().add(createLastAlarmsPanel(), BorderLayout.CENTER);
				    
				    // Show the frame
				    int width = 350;
				    int height = 280;
				    frame.setSize(width, height);
				    
				    frame.addWindowListener(new SimpleOnCloseAlarmDetail());

				    	
				    frame.setVisible(true);

				}
			}
			});
    	alarmDetailButton.setEnabled(true);
    	c.gridx = 0;
        c.gridy = 1;
    	additionalInfoPanel.add(alarmDetailButton,c);
    	
    	alarmDetails = new HashMap();
    	alarmModel = new DefaultListModel();
    	
    	inWarningLabel = new JLabel("No queues approach threshold");
    	inWarningLabel.setFont(activeFont);
    	c.gridx = 0;
        c.gridy = 2;
    	additionalInfoPanel.add(inWarningLabel,c);
    	
    	inWarningDetailButton = new JButton("Further details about warning on queues...");
    	inWarningDetailButton.setFont(activeFont);
    	inWarningDetailButton.setAction(new AbstractAction("Further details...") {
			public void actionPerformed(ActionEvent actionEvent) {
				{
					   // Create the frame
				    String title = "Queues that are approaching threshold";
				    JFrame frame = new JFrame(title);
				    
				    // Add the component to the frame's content pane;
				    // by default, the content pane has a border layout
				    frame.getContentPane().add(createWarningPanel(), BorderLayout.CENTER);
				    
				    // Show the frame
				    int width = 350;
				    int height = 280;
				    frame.setSize(width, height);
				    
				    frame.addWindowListener(new SimpleOnCloseWarningDetail());

				    	
				    frame.setVisible(true);

				}
			}
			});
    	
    	inWarningDetailButton.setEnabled(true);
    	
    	c.gridx = 0;
        c.gridy = 3;
    	additionalInfoPanel.add(inWarningDetailButton,c);
    	warningDetails = new HashMap();
    	warningModel = new DefaultListModel();
    	
    	return additionalInfoPanel;
    }
    
    
    /**
     * Listener for enabling or disabling the 'Further details' button.
     */
    class SimpleOnCloseAlarmDetail implements WindowListener{
		public void windowActivated(WindowEvent arg0) {}
		public void windowClosed(WindowEvent arg0) {}	
		public void windowClosing(WindowEvent arg0) {
			alarmDetailButton.setEnabled(true);
			}
		public void windowDeactivated(WindowEvent arg0) {}
		public void windowDeiconified(WindowEvent arg0) {}
		public void windowIconified(WindowEvent arg0) {}
		public void windowOpened(WindowEvent arg0) {
			alarmDetailButton.setEnabled(false);
		}
    }
    /**
     * Listener for enabling or disabling the 'Further details' button.
     */ 
    class SimpleOnCloseWarningDetail implements WindowListener{
		public void windowActivated(WindowEvent arg0) {}
		public void windowClosed(WindowEvent arg0) {}	
		public void windowClosing(WindowEvent arg0) {
			inWarningDetailButton.setEnabled(true);
			}
		public void windowDeactivated(WindowEvent arg0) {}
		public void windowDeiconified(WindowEvent arg0) {}
		public void windowIconified(WindowEvent arg0) {}
		public void windowOpened(WindowEvent arg0) {
			inWarningDetailButton.setEnabled(false);
		}
    }
 
    /**
     * Updates the components of the 'Set up Alam' panel, according to the current selected queue name.
     */ 
    public void setSelectedQueueDetails(String queueName, int interactionNumber, int ratio)
    {
    	interactionNumberLabel.setText("Interactions: "+interactionNumber);
    	selectedQueueProgressBar.setValue(ratio);       
        selectedQueueProgressBar.setForeground(colorProgressBar(ratio));
		this.setUpAlarmPanel.repaint();
    }
    
   /**
     * Creates a panel in a dialog box. The created panel lists the queues for which alarm weres fired. 
     * <p>By clicking on a queue, the user can see details about fired alarm, and also the current status of a queue.</p>
     * @see #setDetailsAboutSelectedAlarm(String, int, int)
     */
    private JPanel createLastAlarmsPanel(){

    	
    	 lastAlarmsPanel = new JPanel();
    	     	 
    	 // alarm list 
    	 alarmList = new JList(alarmModel);
    	
    	 alarmList.setPreferredSize(new Dimension(290, 110));
    	 alarmList.setMinimumSize(new Dimension(250, 110));
    	 //Register a selection listener
    	 alarmList.addListSelectionListener(this.alarmListener);

    	 lastAlarmScrollPane = new JScrollPane(alarmList);
    	 lastAlarmScrollPane.setPreferredSize(new Dimension(290, 110));
    	 lastAlarmScrollPane.setMinimumSize(new Dimension(250, 110));
    	 lastAlarmScrollPane.setBorder(lastAlarmTitledBorder);
    	 lastAlarmTitledBorder.setTitleFont(activeFont);
    	 lastAlarmsPanel.add(lastAlarmScrollPane);
    	 
    	 /// details about the queue selected in the alarm list    	 
    	 alarmDetailsPanel = new JPanel();
    	 alarmDetailsPanel.setBorder(this.alarmDetailsTitledBorder);
    	 alarmDetailsTitledBorder.setTitleFont(activeFont);
    	 alarmDetailsPanel.setLayout(new GridBagLayout());
    	 GridBagConstraints c = new GridBagConstraints();
         c.fill = GridBagConstraints.BOTH;
         
         
         c.gridx = 0;
         c.gridy = 0;
         alarmStatusLabel = new JLabel("Current status: No queue selected.");
         alarmStatusLabel.setFont(activeFont);
         alarmDetailsPanel.add(alarmStatusLabel,c);
         
    	 alarmStatusProgressBar = new JProgressBar( 0, 100);       
    	 alarmStatusProgressBar.setForeground(colorProgressBar(0));
    	 alarmStatusProgressBar.setStringPainted(true);
    	 alarmStatusProgressBar.setFont(processBarbold);
    	 alarmStatusProgressBar.setValue(0);
    	 
         c.gridx = 0;
         c.gridy = 1;
         alarmDetailsPanel.add(alarmStatusProgressBar,c);
         
         
         
    	    
    	 alarmDetailsText = new JTextArea("No queue selected.", 50, 7);
    	 alarmDetailsText.setFont(new Font("regular", Font.PLAIN, 10));
    	 
    	 alarmDetailsTextScrollPane = new JScrollPane(alarmDetailsText,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    	 alarmDetailsTextScrollPane.setPreferredSize(new Dimension(280, 80));
    	 alarmDetailsTextScrollPane.setMinimumSize(new Dimension(240, 50));
    	 
    	 
         c.gridwidth = GridBagConstraints.REMAINDER;
         c.gridheight = GridBagConstraints.REMAINDER;
         c.weightx = 1.0;
         c.weighty = 1.0;
         c.fill = GridBagConstraints.BOTH;
         c.gridx = 0;
         c.gridy = -1;
         
         alarmDetailsPanel.add(alarmDetailsTextScrollPane,c);
    	 
    	 
    	lastAlarmsPanel.add(alarmDetailsPanel);
    	 return lastAlarmsPanel;
    	 
    	 
    	    
    }
    /**
     * Displays details about alarms fired for the specified queue, including its current status and progress bar.  
     * @param queueName name of the queue.
     * @param ixns interaction number.
     * @param ratio activity in the queue (percentage.)
     */
    public void setDetailsAboutSelectedAlarm(String queueName, int ixns, int ratio)
    {
    	alarmStatusLabel.setText(queueName+ " currently contains: "+ixns+" ixns");
		alarmStatusProgressBar.setValue(ratio);
		alarmStatusProgressBar.setForeground(colorProgressBar(ratio));	
		alarmStatusProgressBar.repaint();
		String details= (String) alarmDetails.get(queueName) ;
		alarmDetailsText.setText(details);
		
    }
    
    /** Creates a panel in a dialog box. The created panel lists the queues that approach the alarm threshold. 
    * <p>By clicking on a queue, the user can see the current status of the queue.</p>
    * @see #setDetailsAboutSelectedWarning(String, int, int)
    * 
    */
    private JPanel createWarningPanel(){

    	
    	 warningPanel = new JPanel();    	 
    	 // alarm list 
    	 warningList = new JList(warningModel);
    	 warningList.setPreferredSize(new Dimension(290, 110));
    	 warningList.setMinimumSize(new Dimension(250, 110));
    	 //Register a selection listener
    	 warningList.addListSelectionListener(this.warningListener);

    	 warningScrollPane = new JScrollPane(warningList);
    	 warningScrollPane.setPreferredSize(new Dimension(290, 110));
    	 warningScrollPane.setMinimumSize(new Dimension(250, 110));
    	 warningScrollPane.setBorder(warningTitledBorder);  
    	 warningTitledBorder.setTitleFont(activeFont);
    	 warningPanel.add(warningScrollPane);
    	 
    	 /// details about the queue selected in the alarm list    
    	 warningDetailsPanel= new JPanel();
    	 warningDetailsPanel.setBorder(this.alarmDetailsTitledBorder);
    	 alarmDetailsTitledBorder.setTitleFont(activeFont);
         warningDetailsPanel.setLayout(new GridBagLayout());
    	 warningDetailsPanel.setPreferredSize(new Dimension(290, 110));
    	 warningDetailsPanel.setMinimumSize(new Dimension(250, 110));
    	 
    	 GridBagConstraints c = new GridBagConstraints();
         c.fill = GridBagConstraints.BOTH;
         c.gridx = 0;
         c.gridy = 0;
         warningStatusLabel = new JLabel("Current status: No queue selected");
         warningStatusLabel.setFont(activeFont);
         warningStatusLabel.setMinimumSize(new Dimension(290,110));
         warningDetailsPanel.add(warningStatusLabel,c);
         
         
         warningStatusProgressBar = new JProgressBar( 0, 100);       
         warningStatusProgressBar.setForeground(colorProgressBar(0));
         warningStatusProgressBar.setStringPainted(true);
         warningStatusProgressBar.setFont(processBarbold);
         warningStatusProgressBar.setValue(0);
         warningStatusProgressBar.setMinimumSize(new Dimension(250,100));
    	 
         c.gridx = 0;
         c.gridy = 1;
         warningDetailsPanel.add(warningStatusProgressBar,c);
         
    	 
    	 
         warningPanel.add(warningDetailsPanel);
    	 return warningPanel;
    	 
    	 
    	    
    }

    /**
     * Displays the current status of the queue that approaches its alarm threshold.
     * @param queueName queue name.
     * @param ixns number of interactions in this queue.
     * @param ratio activity in this queue.
     */
    public void setDetailsAboutSelectedWarning(String queueName, int ixns, int ratio)
    {
    	warningStatusLabel.setText(queueName+ " currently contains: "+ixns+" ixns");
    	warningStatusProgressBar.setValue(ratio);
    	warningStatusProgressBar.setForeground(colorProgressBar(ratio));	
    	warningStatusProgressBar.repaint();
		
    }
    
 
	

    /**
     * Returns the color associated with the ratio.
     * @param ratio
     */
    private Color colorProgressBar(int ratio)
    {
    	if(ratio <65)
    		return this.underWarningColor;
    	else if(ratio >= 65 && ratio <90)
    		return this.warningColor;
    	else return this.alarmColor;
    }
    
   /**
    * Updates all GUI component that displays queue information.
    * @param queueName
    * @param nbInteractions
    * @param ratio
    */
    public void setQueueInfo(String queueName, int nbInteractions, int ratio)
    {
   
    	// 1. updating the Queues activity panel
    	if(mqueues.indexOf(queueName)>=0)
    	{    		
    		Iterator labels = mlabels.iterator();
    		Iterator bars = mbars.iterator();   		
    		insert(queueName, ratio, labels, bars);
    		
    	}else
    	{
    		mqueues.addElement(queueName);
    		
    		JPanel aPanel = new JPanel();
    		aPanel.setLayout(new BorderLayout());
    		JLabel queueLabel = new JLabel(queueName);
    		queueLabel.setFont(activeFont);
    		aPanel.add( queueLabel, BorderLayout.NORTH);
    		
    		mlabels.add(queueLabel);
    	        
    		JProgressBar progressBar = new JProgressBar( 0, 100);
    	    progressBar.setValue(0);
    		progressBar.setForeground(colorProgressBar(ratio));
    		progressBar.setFont(processBarbold);
    	    progressBar.setStringPainted(true);
    	    aPanel.add(progressBar, BorderLayout.CENTER);
    	    queuePanel.add(aPanel);
    	    
    	    mbars.add(progressBar);
    	    
    	    queueComboBox.addItem(queueName);
    	    
    	}
    	
    	//updating the combobox managing the ixn threshold for alarms
    	if(queueName.equals((String) queueComboBox.getSelectedItem()))
		{
			selectedQueueProgressBar.setValue(ratio);			
			selectedQueueProgressBar.setForeground(colorProgressBar(ratio));
			interactionNumberLabel.setText("Number of interactions in this queue: "+nbInteractions);
			selectedQueueProgressBar.repaint();
		}
    	//Updating dialog box of they are opened.
    	if(alarmList != null && queueName.equals((String) this.alarmList.getSelectedValue()) )
		{ 			
			alarmStatusLabel.setText(queueName+ " currently contains: "+nbInteractions+" ixns");
			alarmStatusProgressBar.setValue(ratio);
			alarmStatusProgressBar.setForeground(colorProgressBar(ratio));	
			alarmStatusProgressBar.repaint();
		}
    	
    	if(warningList != null && queueName.equals((String) this.warningList.getSelectedValue()) )
		{ 			
			warningStatusLabel.setText(queueName+ " currently contains: "+nbInteractions+" ixns");
			warningStatusProgressBar.setValue(ratio);
			warningStatusProgressBar.setForeground(colorProgressBar(ratio));	
			warningStatusProgressBar.repaint();
		}
    	
    	// alarm widgets that change if alarm !
    	if(ratio >=100)
    	{
    		
    		this.totalAlarms++;
    		alarmFiredLabel.setText(totalAlarms+" alarms fired");
    		
    		// Fired alarm     		    		
    		String details ="";
    		if(alarmDetails.containsKey(queueName))
    			details = (String) alarmDetails.get(queueName) ;
    		
    		details = details.concat(new String("Alarm fired for "+ queueName + " \nat: "+createTimeStamp() 
			+ " \nfor "+nbInteractions+" ixns\n\n"));
    		this.alarmDetails.put(queueName, details);
    		
    		if(alarmList != null && queueName.equals((String) this.alarmList.getSelectedValue()) )
    		{
    			alarmDetailsText.setText(details);
    			alarmDetailsText.repaint();					
    			
    			
    		}
    		if(this.alarmModel.contains(queueName))    			
    			this.alarmModel.removeElement(queueName);    				
    		alarmModel.add(0,queueName);
    		
    		// removing the queue from the warning list
    		if(this.warningModel.contains(queueName))
    		{
    			if(this.warningList != null && queueName.equals(this.warningList.getSelectedValue()))
    			{
    				warningStatusLabel.setText("No queue selected.");
    				warningStatusProgressBar.setValue(0);
    				warningStatusProgressBar.setForeground(colorProgressBar(0));	
    				warningStatusProgressBar.repaint();
    				
    			}
    			this.warningModel.removeElement(queueName);
    			if(totalWarning >0)
    			{
        			this.totalWarning--;
        			if(totalWarning >0)
        				inWarningLabel.setText(totalWarning+" queues approach threshold");
        			else
        				inWarningLabel.setText(" No queues approach threshold");
    			}
    		}
    	}else if(ratio<100 && ratio >= 80 )
    	{
    		if(! warningModel.contains(queueName))
    		{
				warningModel.add(0,queueName);
				this.totalWarning++;
				inWarningLabel.setText(totalWarning+" queues approach threshold");
				inWarningLabel.repaint();
    		}
			
			
    	}else
    	{
    		if(warningModel.contains(queueName))
    		{
				   		
    			if(this.warningList != null && queueName.equals(this.warningList.getSelectedValue()))
    			{
    				warningStatusLabel.setText("No queue selected.");
    				warningStatusProgressBar.setValue(0);
    				warningStatusProgressBar.setForeground(colorProgressBar(0));	
    				warningStatusProgressBar.repaint();

    			}
    			this.warningModel.removeElement(queueName);
    			this.totalWarning--;
    			if(totalWarning >0)
    				inWarningLabel.setText(totalWarning+" queues approach threshold");
    			else 
    				inWarningLabel.setText(" No queues approach threshold");
    		}
    	}
    	
    }
    
	/**
	 * Inserts the log message with the accurate style in the log panel.
	 */
	public void writeLogMessage(String eventString, String eventStyle) {
	    try {
	        logDocument.insertString(logDocument.getLength(),
	        		createTimeStamp()+" "+ eventString+newline,
	                logDocument.getStyle(eventStyle));
	        setCaretPosition();
	    } catch (BadLocationException badLocationException) {
	        System.err.println("Couldn't insert text into text pane.");
	    }
	}

	/**
	 * Sets the log pane position at the end of the document.
	 */
	private void setCaretPosition() {
	    SwingUtilities.invokeLater(new Runnable() {
	        public void run() {
	            logPane.setCaretPosition(logDocument.getLength());
	        }
	    });
	}

	/**
	 * Creates the time stamp added to each log message.
	 */
	private String createTimeStamp() {
	    return timestamp.format(new GregorianCalendar().getTime());
	}
    /**
     * Creates a panel for displaying log messages.
     */
    private void createLogAreaScrollPane() {
        logPane = new JTextPane();
        logDocument = logPane.getStyledDocument();
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle(
                StyleContext.DEFAULT_STYLE);

        Style regular = logDocument.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, "SansSerif");

        Style style = logDocument.addStyle(errorStyle, regular);
        StyleConstants.ColorConstants.setForeground(style,
                errorColor);

        style = logDocument.addStyle(queueEventStyle, regular);
        StyleConstants.ColorConstants.setForeground(style,
        		queueEventColor);

        logPaneScrollPane = new JScrollPane(logPane,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        logPaneScrollPane.setPreferredSize(new Dimension(250, 155));
        logPaneScrollPane.setMinimumSize(new Dimension(10, 10));
        logPane.setEditable(false);
        gridBagConstraints.gridwidth = GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        contentPane.add(logPaneScrollPane, gridBagConstraints);
    }


    private void insert(String nameToInsert, int ratio, Iterator labels, Iterator bars)
    {
    	JLabel nextLabel = (JLabel) labels.next();
    	JProgressBar nextBar = (JProgressBar) bars.next();
    	
    	if(nameToInsert.equals(nextLabel.getText()))
    	{
    		nextBar.setValue(ratio);
    		nextBar.setForeground(colorProgressBar(ratio));
    		nextBar.repaint();
    		return;
    	}
    	if(ratio<nextBar.getValue())
    	{
    		if(labels.hasNext())
    			insert(nameToInsert,ratio, labels, bars);
    	}else
    	{
    		String queueToPush = nextLabel.getText();
    		nextLabel.setText(nameToInsert);
    		int valueToPush = nextBar.getValue();
    		nextBar.setValue(ratio);
    		nextBar.setForeground(colorProgressBar(ratio));
    		nextBar.repaint();
    		
    		if(labels.hasNext())
    			pushBack(queueToPush, valueToPush,nameToInsert,labels,  bars) ;
    	}
    	
    	
    }
    
    private void pushBack(String queueToPush, int valueToPush, String nameInserted, Iterator labels,  Iterator bars) 
    {
    	JLabel nextLabel = (JLabel) labels.next();
    	JProgressBar nextBar = (JProgressBar) bars.next();
    	
    	String nextQueueToPush = nextLabel.getText();
    	int nextValueToPush = nextBar.getValue();
    	
    	nextLabel.setText(queueToPush);
    	nextBar.setValue(valueToPush);
    	nextBar.setForeground(colorProgressBar(valueToPush));
		nextBar.repaint();
		
    	if( nextQueueToPush.equals(nameInserted))
    		return;
    	else if(labels.hasNext())
    		pushBack(nextQueueToPush, nextValueToPush,nameInserted,labels,  bars) ;    		
    	
    }
    
  
}