/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
/**
Queued Interaction Java API 7.5 Code Examples
*/
package queued.sdk.java.examples;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.lang.String;

/**
 * Reads Configuration Layer data from the
 * <code>OpenMediaSdk.properties</code> file. This data includes information such as the host
 * and port to use, the name of an application to connect to, and so on.<p>
 *
 * Once this data has been stored in the fields of this class, it is available
 * to the Queued Interaction Java Library's code examples by means of getter and
 * setter methods.
 * @version 7.5.001.00
 */
public class OpenMediaSdkData {

    public OpenMediaSdkData() {
        try {
            loadData();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }


    /**
     * Returns the application name.
     */
    public String getApplicationName() {
        return applicationName;
    }


    /**
     * Returns the backup host name.
     */
    public String getConfigServerBackupHost() {
        return configServerBackupHost;
    }
    /**
     * Returns the backup port.
     */
    public int getConfigServerBackupPort() {
        return configServerBackupPort;
    }

    /**
     * Returns the primary hostname.
     */
    public String getConfigServerPrimaryHost() {
        return configServerPrimaryHost;
    }
    /**
     * Returns the primary port.
     */
    public int getConfigServerPrimaryPort() {
        return configServerPrimaryPort;
    }

    /** Returns the reconnection period, in milliseconds. */
    public int getReconnectionPeriod() {
        return reconnectionPeriod;
    }


    /** Returns the maximum number of reconnection attempts. */
    public int getReconnectionAttempts(){
        return reconnectionAttempts;
    }
    /**
     * Loads the properties from the OpenMediaSdk.properties file.
     */
    public void loadData() throws Exception {


        File propertiesFile = new File("OpenMediaSdk.properties");
        FileInputStream fileInputStream = new FileInputStream(propertiesFile);
        Properties properties = new java.util.Properties();
        properties.load(fileInputStream);

        /* Retrieve Connection information from the properties file */
        configServerPrimaryHost = properties
                .getProperty("ConfigServerPrimaryHost");
        configServerPrimaryPort = Integer
                .parseInt(properties
                        .getProperty("ConfigServerPrimaryPort"));

        configServerBackupHost = properties
                .getProperty("ConfigServerBackupHost");
        configServerBackupPort = Integer
                .parseInt(properties
                        .getProperty("ConfigServerBackupPort"));


        applicationName = properties
                .getProperty("ApplicationName");

        reconnectionPeriod = Integer
                .parseInt(properties
                        .getProperty("ReconnectionPeriod"));
        reconnectionAttempts = Integer
                .parseInt(properties
                        .getProperty("ReconnectionAttempts"));

    }

    // QIL configuration information
    private String configServerPrimaryHost;
    private int configServerPrimaryPort;
    private String configServerBackupHost;
    private int configServerBackupPort;
    private String applicationName;
    private int reconnectionPeriod;
    private int reconnectionAttempts;

}