/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
/**
Queued Interaction Java API 7.5 Code Examples
@version 7.5.001.00
*/
package queued.sdk.java.examples;

import javax.swing.table.*;
import java.util.Vector;

/**
 * This table model contains a vector of rows.
 * Each row contains a vector of strings corresponding to a QIL object.
 * The max numbers of columns displayed is 3.
 * <br>By default, it does not displays QIL objects' IDs.
 */
class OpenMediaSdkTableModel extends AbstractTableModel {
	public int NUM_COLUMNS = 2;
	public int START_NUM_ROWS = 2;
    protected int nextEmptyRow = 0;
    protected int numRows = 0;

    public String colName0;
    public String colName1;
    public String colName2;
    public String colName3;
    public String colName4;
    public String colName5;

    protected Vector data = null;

    public OpenMediaSdkTableModel() {
        data = new Vector();
    }

    public String getColumnName(int column) {
	switch (column) {
	  case 0:
	    return colName0;
	  case 1:
	    return colName1;
	  case 2:
	    return colName2;
	  case 3:
	    return colName3;
	  case 4:
	    return colName4;
	  case 5:
	    return colName5;
	}
	return "";
    }

    public synchronized int getColumnCount() {
        return NUM_COLUMNS;
    }

    public synchronized int getRowCount() {
        if (numRows < START_NUM_ROWS) {
            return START_NUM_ROWS;
        } else {
            return numRows;
        }
    }

    public boolean isCellEditable(int row, int col)
    { return false; }

    public synchronized Object getValueAt(int row, int column) {
    	try {
    		String[] p = (String[])data.elementAt(row);
    		return p[column+1];
    	} catch (Exception e) {
    	}
    	return "";
    }

    public synchronized Object getValueAt(String val0, int column) {
    	String[] p = null;
        int index = -1;
        boolean found = false;
        boolean addedRow = false;

        int i = 0;
        while (!found && (i < nextEmptyRow)) {
            p = (String[])data.elementAt(i);
            if (p[0].equals(val0)) {
                return p[column];
            } 
        }
        return null;
    }
    
    public synchronized Object getIDAt(int row) {
    	try {
    		String[] p = (String[])data.elementAt(row);
    		return p[0];
    	} catch (Exception e) {
    	}
    	return "";
    }

    public synchronized int update(String[] values) {
        String[] p = null;
        int index = -1;
        boolean found = false;
        boolean addedRow = false;

        int i = 0;
        while (!found && (i < nextEmptyRow)) {
            p = (String[])data.elementAt(i);
            if (p[0].equals(values[0]) ){            	
                found = true;
                index = i;
            } else {
                i++;
            }
        }

        if (found) {
        	//update old player
        	data.setElementAt(values, index);
        } else { //add new player
        	if (numRows <= nextEmptyRow) {
        		//add a row
        		numRows++;
        		addedRow = true;
        	}
        	index = nextEmptyRow;
        	data.addElement(values);
        	nextEmptyRow++;
        }

    	//Notify listeners that the data changed.
    	if (addedRow) {
    	    fireTableRowsInserted(index, index);
    	} else {
    	    fireTableRowsUpdated(index, index);
    	}

    	return index;

    }
    
    

    public synchronized int update(String val0, String val1, String val2) {
        String[] p = null;
        int index = -1;
        boolean found = false;
        boolean addedRow = false;

        int i = 0;
        while (!found && (i < nextEmptyRow)) {
            p = (String[])data.elementAt(i);
            if (p[0].equals(val0)) {
                found = true;
                index = i;
            } else {
                i++;
            }
        }

        if (found) {
        	//update old player
        	data.setElementAt(new String[]{val0, val1, val2}, index);
        } else { //add new player
        	if (numRows <= nextEmptyRow) {
        		//add a row
        		numRows++;
        		addedRow = true;
        	}
        	index = nextEmptyRow;
        	data.addElement(new String[]{val0, val1, val2});
        	nextEmptyRow++;
        }
       

    	//Notify listeners that the data changed.
    	if (addedRow) {
    	    fireTableRowsInserted(index, index);
    	} else {
    	    fireTableRowsUpdated(index, index);
    	}

    	return index;

    }
    public synchronized void removeID(String val0) {
        String[] p = null;
        int index = -1;
        boolean found = false;

        int i = 0;
        while (!found && (i < nextEmptyRow)) {
            p = (String[])data.elementAt(i);
            if (p[0] == val0) {
                found = true;
                index = i;
            } else {
                i++;
            }
        }

        if (found) {
        	//update old player
        	data.remove(index);
        	numRows--;
        	nextEmptyRow--;
        	fireTableRowsDeleted(index, index);
        }

    }
    public synchronized void clear() {
    	int oldNumRows = numRows;
        numRows = START_NUM_ROWS;
        data.removeAllElements();
        nextEmptyRow = 0;

        if (oldNumRows > START_NUM_ROWS) {
        	fireTableRowsDeleted(START_NUM_ROWS, oldNumRows - 1);
        }
        fireTableRowsUpdated(0, START_NUM_ROWS - 1);
    }
    
    
}
