/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
/**
Queued Interaction Java API 7.5 Code Examples

*/
package queued.sdk.java.examples;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import com.genesyslab.omsdk.commons.exception.InitializationException;
import com.genesyslab.omsdk.qil.applicationblocks.monitoring.ConnectorQIL;
import com.genesyslab.omsdk.qil.exception.QILInitializationException;

/**
 * Connects to and disconnects from the Genesys servers, and closes the associated GUI windows on disconnection.
 * <br>To manage connection and disconnection, this class uses the <code>ConnectorQIL</code> application block.
 * @version 7.5.001.00
 */
public class SimpleConnector implements WindowListener{

	ConnectorQIL connector;
	
	/**
	 * Constructor.
	 */
	public SimpleConnector()
	{
		try{
			OpenMediaSdkData data = new OpenMediaSdkData();
			connector=new ConnectorQIL();
			connector.connect(data.getConfigServerPrimaryHost(),
					data.getConfigServerPrimaryPort(),
					data.getConfigServerBackupHost(),
					data.getConfigServerBackupPort(),
					data.getApplicationName(),
					data.getReconnectionPeriod(),
					data.getReconnectionAttempts());
			System.out.println("Open Media SDK Connector connected successfully.");
			
		}catch(InitializationException __e)
		{
			System.out.println("OMSDKConnector: Initialization Failed.");
			__e.printStackTrace();
			System.exit(0);
		}catch(QILInitializationException __e)
		{
			System.out.println("OMSDKConnector: Initialization Failed.");
			__e.printStackTrace();
			System.exit(0);
		}
	}
	
    ////////////////////////////////////////////////////////////////////
    
	/// window listener methods
	/**
	 * Not implemented.
	 */
    public void windowActivated(WindowEvent e) {}
    /**
	 * Not implemented.
	 */
    public void windowClosed(WindowEvent e){}
    /**
     * Releases QIL when a listened window closes.
     */
    public void windowClosing(WindowEvent e){
    	connector.shutdown();
    	System.out.println("Open Media SDK Connector released successfully.");
    	e.getWindow().dispose();
    	System.exit(0); 		
    }
    /**
	 * Not implemented.
	 */
    public void windowDeactivated(WindowEvent e){}
    /**
	 * Not implemented.
	 */
    public void windowDeiconified(WindowEvent e){}
    /**
	 * Not implemented.
	 */
    public void windowIconified(WindowEvent e) {}
    /**
	 * Not implemented.
	 */
    public void windowOpened(WindowEvent e){}
}
