/*=====================================================================
Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:
The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.
The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.
THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
Copyright &copy; 2006 Genesys Telecommunications Laboratories, Inc. All rights reserved.
=====================================================================*/
/**
Queued Interaction Java API 7.5 Code Examples
*/
package queued.sdk.java.examples;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

import com.genesyslab.omsdk.qil.QILFactory;
import com.genesyslab.omsdk.qil.QILQueue;
import com.genesyslab.omsdk.qil.event.QILQueueContentChangedEvent;
import com.genesyslab.omsdk.qil.event.QILQueueEvent;
import com.genesyslab.omsdk.qil.event.QILQueueListener;
import com.genesyslab.omsdk.qil.exception.QILRequestFailedException;

/**
 * Monitors a queue and sends an alarm if the number of interactions
 * in this queue is greater than a particular alarm value.
 * @version 7.5.001.00
 */
public class SimpleQueueAlarm implements QILQueueListener {
	/** Connection to the Genesys servers. */
	SimpleConnector connection;
	int nbInteractions=0;
	int alarm = 1;
	QILQueue queue;
	/** Timestamp for logging traces. */
	static DateFormat timestamp = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss:SSS");
	/**
	 * Returns a timestamp for log messages.
	 */
	public String createTimeStamp() {
		String stamp =  timestamp.format(new GregorianCalendar().getTime());
		return stamp;
	}

	/**
	 * Constructor. Connects to Configuration Server and Interaction Server.
	 */
	public SimpleQueueAlarm(String queueName, int _alarm)
	{
		alarm = _alarm;
		connection = new SimpleConnector();
		try {
			QILQueue queue = QILFactory.getQILFactory().getQueue(queueName);
			queue.addQueueListener(this);
			queue.startMonitoring();
			System.out.println(createTimeStamp()+" starting monitoring "+ queueName);
		} catch (QILRequestFailedException e) {
			e.printStackTrace();
		}
	}
	/**
	 * Launches the simple queue alarm example.
	 * @param args arguments:
	 * <ul><li>&#60;queue_name&#62;: name of the queue to be monitored.</li>
	 * <li>&#60;alarm&#62;: maximum number of interactions reached before sending an alarm.</li></ul>
	 */
	public static void main(String[] args) {
		SimpleQueueAlarm queueAlarm = new SimpleQueueAlarm(args[0], new Integer(args[1]).intValue());
	}

	/**
	 * Receives QILQueueEvent, which report changes in the monitored queue.
	 * If you implement the QILQueueListener interface, you must implement this method.
	 * <br>The SimpleQueueAlarm example uses this method to manage the queue alarm.
	 *
	 */
	public void handleQueueEvent(QILQueueEvent event) {


		if(event instanceof QILQueueContentChangedEvent)
		{
			QILQueueContentChangedEvent changeEvent = (QILQueueContentChangedEvent)event;
			nbInteractions += changeEvent.getAddedInteractions().size()
				- changeEvent.getRemovedInteractions().size();

			System.out.println(createTimeStamp()+ " "+changeEvent.getAddedInteractions().size()
					+" ixn(s) added and "+ changeEvent.getRemovedInteractions().size()
					+ " ixn(s) removed; => "
					+ nbInteractions +" ixn(s) left");

			if(nbInteractions > alarm)
				System.out.println(createTimeStamp()+ " !!!!!!!! Alarm !!!!!!!!!!! More than "+alarm+" ixns in queue!");
		}

	}
}
