/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using System.Xml;

public class GetConfigurationInformationExample
{

	// get all Agents
	string queryAllAgents     = "CfgAgent";
	// get Agent Groups where specific agent participates
	string queryAgentGroups   = "CfgAgent[@name='Lucent_1000']/agentGroups/*/baseDBID";
	// get all Agents from some Agent Group
	string queryAgents        = "CfgAgentGroup[@name='Agent Group']/agentDBIDs/*/linkDBID";
	// get all Skills for some Agent
	string querySkills        = "CfgAgent[@name='Lucent_1001']/skillLevels/*/linkDBID";
	// get all Switches connected to some Agent (through its Login)
	string querySwitches      = "CfgAgent[@name='Lucent_1001']/agentLogins/*/linkDBID/ownerDBID";
	// get all Agents assigned to a particular Place
	string queryAgentsByPlace = "CfgAgent[placeDBID/@name='Place_1000']";
	// get the all DNs of type 'ACD Position' under some Switch
	string queryDNs           = "CfgSwitch[@name='LucentG3']/DNs/CfgDN[@type='2']";
	// get all the Agents under some Folder
	string queryAgentsByFolder= "CfgFolder[@name='SubFolder']/objectIDs/CfgPersonShortcut/linkDBID";

	public void execute(String targetHost)
	{
		RegisterToConfigurationServiceExample registerExample = new RegisterToConfigurationServiceExample();
		registerExample.execute(targetHost);

		GCE cfgService = registerExample.cfgService;

		// get Configuration Service version
		Console.WriteLine("==>Configuration Service version is ..." + 
			cfgService.getVersion());

			
		// read information about all the agents
			
		DisplayResults(queryAllAgents, ((System.Xml.XmlNode[]) cfgService.get(queryAllAgents))[0]);

		// read information about all the Agent's Agent Groups
		DisplayResults(queryAgentGroups,((System.Xml.XmlNode[])cfgService.get(queryAgentGroups))[0]);

		// read information about all the Agents from some Agent Group
		DisplayResults(queryAgents,((System.Xml.XmlNode[])cfgService.get(queryAgents))[0]);

		// read information about all the Skills for some Agent
		DisplayResults(querySkills,((System.Xml.XmlNode[])cfgService.get(querySkills))[0]);

		// read information about all the Switches for some Agent
		DisplayResults(querySwitches,((System.Xml.XmlNode[])cfgService.get(querySwitches))[0]);

		// read information about all the Agents assigned to a particular Place
		DisplayResults(queryAgentsByPlace,((System.Xml.XmlNode[])cfgService.get(queryAgentsByPlace))[0]);

		// read information about all the DNs of type 'ACD Position' under some Switch
		DisplayResults(queryDNs,((System.Xml.XmlNode[])cfgService.get(queryDNs))[0]);

		// read information about all the Agents under some Folder
		DisplayResults(queryAgentsByFolder,((System.Xml.XmlNode[])cfgService.get(queryAgentsByFolder))[0]);

		// close session
		cfgService.unregister();
	}

	void DisplayResults(string query,XmlNode result)
	{
		Console.WriteLine("Results of the query : '{0}'",query);
		// display all the result elements
		foreach (XmlNode node in result.ChildNodes)
			Console.WriteLine(" =>Object [{0}], name [{1}]",node.Name,((XmlElement)node).GetAttribute("name"));
	}
}
