/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/
package gis.cfgExamples;

import java.io.*;
import java.util.Iterator;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.message.MessageElement;

import gis.services.csproxy.*;

/*
 * This example explains how to work with Configuration Service notification
 * mechanism by the polling method. The example demonstrates how to subscribe to
 * a configuration service and how the call to the refresh() method before and
 * after a configuration data update returns different results. Note the
 * output difference between the first and second check point.
 */

public class SolicitedNotificationByPollingExample {

  // Connection parameters used to connect and register at GIS and Configuration Service

  String gisPrincipal    = "default";
  String gisCredentials  = "password";
  String cfgUserName     = "default";
  String cfgUserPassw    = "password";
  String cfgAppName      = "default";

  String[] services = new String[]{"GIS_CONFIGSERVICE"};

  // Execute method - accomplishes all the sample's application logic
  public void execute(String gisServer) throws Exception {

     //the xml data is stored in a separate file for readability
    String dataFile = "gis/cfgExamples/data/sample_01x.xml";    //creates a skill object

      //this class provides functionality to register, unsubscribe, release and log out from the GIS configuration service
    RegisterToConfigurationServiceExample subConfig = new RegisterToConfigurationServiceExample();
    subConfig.register(gisServer);	//register to GIS configuration service

    // subscribe to agent skill set notification
    System.out.println("==>Subscription on notifications completed ..." +
                       subConfig.configPort.subscribe("CfgSkill","",""));

 // set the engine option which will prevent from putting 'multiRef' elements in the method parameters
    subConfig.configService.getEngine().setOption(org.apache.axis.AxisEngine.PROP_DOMULTIREFS,Boolean.FALSE);

    // get the current checkpoint
    CSResult result = subConfig.configPort.refresh("");
    MessageElement checkpointValue = (MessageElement)result.get_any()[0];
    System.out.println("==>Current checkpoint is [" + checkpointValue.getValue() + "]");

  //---------------------------------------------------------------------------------------//
  // make an update to demonstrate the data change in the second call to refresh() method later.
  //---------------------------------------------------------------------------------------//

    javax.xml.parsers.DocumentBuilderFactory documentBuilderFactory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
    javax.xml.parsers.DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    org.w3c.dom.Document xmlDocument = documentBuilder.parse(dataFile);

    // prepare data
    CSXmlData updateData = new CSXmlData();
    MessageElement messageElement = new MessageElement(xmlDocument.getDocumentElement());
    MessageElement[] any = new org.apache.axis.message.MessageElement[] { messageElement };
    updateData.set_any(any);

    // call update method
    System.out.print("==>Updating configuration using sample_01x.xml ...");
    CSResult updateResponse = subConfig.configPort.update(updateData);
    System.out.println("done");

  //------------------------------------------------------------------------------------//

    // call refresh again
    result = subConfig.configPort.refresh(checkpointValue.getValue());
    Iterator iter = result.get_any()[0].getChildElements();
    checkpointValue = (MessageElement)result.get_any()[0];
    System.out.println("===>Current checkpoint is [" + checkpointValue.getValue() + "]");

    MessageElement cfgData = (MessageElement)result.get_any()[1];
    // print results
    displayNotification(cfgData,"CfgCreate","Created");
    displayNotification(cfgData,"CfgUpdate","Updated");
    displayNotification(cfgData,"CfgRemove","Removed");

    subConfig.configPort.unsubscribe();
    // Logout from the Session service
    subConfig.releaseAndLogout();
  }

  /// Displays results of the notification
  public void displayNotification(MessageElement cfgData,String elementName,String textStr) {

    Iterator iter = cfgData.getChildElements();
    MessageElement oper = null;
    while (iter.hasNext())
      if (((oper = (MessageElement)iter.next()) != null) && oper.getName().equals(elementName))
      {
        System.out.println(" ===>" + textStr + ":");
        Iterator subIter = oper.getChildElements();
        MessageElement obj = null;
        while (subIter.hasNext())
          if ((obj = (MessageElement)subIter.next()) != null)
            System.out.println("  Object [" + obj.getName() + "], DBID [" + obj.getAttributeValue("DBID") +
                               ", name [" + obj.getAttributeValue("name") + "]");
      }
  }


  /// The main entry point for the application.
  public static void main (String args[])  throws Exception
  {
    SolicitedNotificationByPollingExample example = new SolicitedNotificationByPollingExample();
    example.execute("HOST_NAME:PORT");
  }
}
