/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/
package gis.cfgExamples;

import java.io.*;
import java.util.Iterator;
import java.net.URL;

import org.apache.axis.client.*;
import org.apache.axis.message.MessageElement;
import org.apache.axis.AxisFault;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.utils.Options;

import javax.xml.rpc.ParameterMode;
import javax.xml.namespace.QName;

import gis.services.session.*;
import gis.services.csproxy.*;

/**
 * This example uses the UnsolictedNotification example to make
 * an unsolicited notification request and demonstrates one implementation
 * to receive messages from a client side notification service.
 *
 * To test this example, you must implement the modified notification.wsdl example.
 * The modified wsdl includes a simple client message retrieval service.
 * The code calls this client service and receives the messages.
 *
 * Date: Nov 25, 2003
 *
 */

public class UnsolicitedNotificationClientExample {

   public UnsolicitedNotificationClientExample() {}

   /*
    * This method calls the client web server and request for the notification service.
    * retrieveMessage() method in NotifyService.java is an exposed method via the notification service.
    * It returns the configuration data received by the notifyMessage() method.
    */
   public void getMessage(String[] args) throws Exception {

      Options opts = new Options( args );
      args = opts.getRemainingArgs();
      Service  service = new Service();
      Call call = (Call) service.createCall();
      call.setTargetEndpointAddress( new java.net.URL(opts.getURL()) );
      call.setOperationName( new QName("cfgNotification", "retrieveMessage") );
      call.setReturnType( XMLType.XSD_STRING );

      String res = (String) call.invoke(new Object[]{});
      System.out.println();  //blank line
      System.out.println("GIS Configuration request received from client http server:");
      System.out.println(res);    //display the information requested for this session client
    }


    /*
     * NOTE: You must run UnsolicitedNotificationExample first. After that, make some modification to a skill object in
     * Configuration Manager. Then run this example to retrieve the information about that change.
     *
     * Standalone option to test run this example. Creates a new instance of
     * this object and starts the process.
     *
     * This class needs an input argument. Variable args0 must be
     * the url to the client http notification service.
     *
     * e.g. java gis.cfgExamples.UnsolicitedNotificationClient -lhttp://<hostName:port>/gisClient/myCfgNotificationService
     *
     *
     * Sample output after running the example:
     *
     * C:\>java gis.cfgExamples.UnsolicitedNotificationClientExample -lhttp://HOST_123:8080/axis/services/cfgNotification
     *
     * GIS Configuration request received from client http server:
     * <CfgData><CfgUpdate><CfgSkill DBID="107" ownerDBID="101" name="Skill_test" tenantDBID="101" state="1"><userProperties/></CfgSkill></CfgUpdate></CfgData>
     */

    public static void main(String[] args){

        try {
            UnsolicitedNotificationClientExample receiveMsg = new UnsolicitedNotificationClientExample();
            receiveMsg.getMessage(args);

        } catch (Exception serviceException) {
            System.out.println(serviceException.getMessage());
        }
    }
}